/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ricoh;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class DalpBuilder
extends Task {
    private List filesets = new LinkedList();
    private File file;
    private String iconName;

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Hashtable props = this.getProject().getProperties();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(this.file));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<dalp dsdk=\"\" version=\"" + this.getProject().getProperty("ricoh.dalp.version") + "\" spec=\"" + this.getProject().getProperty("ricoh.dalp.resources.dsdk.version") + "\">");
            pw.println("  <information>");
            pw.println("    <product-id>" + this.getProject().getProperty("ricoh.application.uid") + "</product-id>");
            pw.println("    <title>" + this.getProject().getProperty("application.name") + "</title>");
            pw.println("    <vendor>" + this.getProject().getProperty("application.vendor") + "</vendor>");
            if ("true".equals(this.getProject().getProperty("ricoh.dalp.information.is-icon-used")) && this.iconName != null) {
                if ("false".equals(this.getProject().getProperty("ricoh.icon.invalid"))) {
                    pw.println("    <icon href=\"./" + this.getProject().getProperty("dist.jar") + "\" basepath=\"current\" location=\"jar\">" + this.iconName + "</icon>");
                }
            } else {
                pw.println("    <abbreviation>" + this.getProject().getProperty("ricoh.dalp.information.abbreviation") + "</abbreviation>");
            }
            pw.println("    <description>" + this.getProject().getProperty("application.description") + "</description>");
            pw.println("    <description type=\"detail\">" + this.getProject().getProperty("application.description.detail") + "</description>");
            pw.println("    <telephone>" + this.getProject().getProperty("ricoh.application.telephone") + "</telephone>");
            pw.println("    <fax>" + this.getProject().getProperty("ricoh.application.fax") + "</fax>");
            pw.println("    <e-mail>" + this.getProject().getProperty("ricoh.application.email") + "</e-mail>");
            pw.println("    <application-ver>" + this.getProject().getProperty("application.version") + "</application-ver>");
            pw.println("    <offline-allowed/>");
            pw.println("  </information>");
            pw.println("  <security>");
            pw.println("    <all-permissions/>");
            pw.println("  </security>");
            pw.println("  <resources>");
            pw.println("    <dsdk version=\"" + this.getProject().getProperty("ricoh.dalp.resources.dsdk.version") + "\"/>");
            String version = this.getProject().getProperty("application.version") != null ? "version=\"" + this.getProject().getProperty("application.version") + "\"" : "";
            pw.println("    <jar href=\"./" + this.getProject().getProperty("dist.jar") + "\" " + version + " basepath=\"current\" main=\"true\" />");
            this.addLibraries(pw);
            if (this.getProject().getProperty("main.class") != null || !"".equals(this.getProject().getProperty("main.class"))) {
                pw.println("    <encode-file>" + this.getProject().getProperty("main.class").toLowerCase() + "</encode-file>");
            }
            pw.println("  </resources>");
            String mainClassStr = this.getProject().getProperty("main.class");
            String visibleStr = this.getProject().getProperty("ricoh.dalp.application-desc.visible");
            pw.println("  <application-desc type=\"xlet\" main-class=\"" + mainClassStr + "\" visible=\"" + visibleStr + "\">");
            String args = this.getProject().getProperty("application.args");
            StringTokenizer st = new StringTokenizer(args, " ");
            while (st.hasMoreTokens()) {
                pw.println("    <argument>" + st.nextToken() + "</argument>");
            }
            pw.println("  </application-desc>");
            String dsdkVerProp = this.getProject().getProperty("ricoh.dalp.resources.dsdk.version");
            if ("1.0".equals(dsdkVerProp)) {
                pw.println("  <install mode=\"" + this.getProject().getProperty("ricoh.dalp.install.mode") + "\" destination=\"" + this.getProject().getProperty("ricoh.dalp.install.destination") + "\"/>");
            } else {
                pw.println("  <install mode=\"" + this.getProject().getProperty("ricoh.dalp.install.mode") + "\" destination=\"" + this.getProject().getProperty("ricoh.dalp.install.destination") + "\" work-dir=\"" + this.getProject().getProperty("ricoh.dalp.install.work-dir") + "\"/>");
            }
            this.addDisplayModes(pw);
            pw.println("</dalp>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    private void addLibraries(PrintWriter pw) {
        Iterator it = this.filesets.iterator();
        while (it.hasNext()) {
            FileSet fs = (FileSet)it.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File basedir = ds.getBasedir();
            String[] files = ds.getIncludedFiles();
            String version = this.getProject().getProperty("application.version") != null ? "version=\"" + this.getProject().getProperty("application.version") + "\"" : "";
            for (int i = 0; i < files.length; ++i) {
                pw.println("    <jar href=\"./" + files[i] + "\" " + version + " basepath=\"current\" />");
            }
        }
    }

    private void addDisplayModes(PrintWriter pw) {
        if ("COLOR".equals(this.getProject().getProperty("ricoh.dalp.display-mode.type"))) {
            if (this.getProject().getProperty("ricoh.dalp.display-mode.is-hvga-support").equals("true")) {
                pw.println("<display-mode size=\"HVGA\" type=\"COLOR\"/>");
            }
            if (this.getProject().getProperty("ricoh.dalp.display-mode.is-vga-support").equals("true")) {
                pw.println("<display-mode size=\"VGA\" type=\"COLOR\"/>");
            }
            if (this.getProject().getProperty("ricoh.dalp.display-mode.is-wvga-support").equals("true")) {
                pw.println("<display-mode size=\"WVGA\" type=\"COLOR\"/>");
            }
            if (this.getProject().getProperty("ricoh.dalp.display-mode.is-4line-support").equals("true")) {
                pw.println("<display-mode size=\"4LINE\" type=\"COLOR\"/>");
            }
        } else if ("MONO".equals(this.getProject().getProperty("ricoh.dalp.display-mode.type"))) {
            if (this.getProject().getProperty("ricoh.dalp.display-mode.is-hvga-support").equals("true")) {
                pw.println("<display-mode size=\"HVGA\" type=\"MONO\"/>");
            }
            if (this.getProject().getProperty("ricoh.dalp.display-mode.is-vga-support").equals("true")) {
                pw.println("<display-mode size=\"VGA\" type=\"MONO\"/>");
            }
            if (this.getProject().getProperty("ricoh.dalp.display-mode.is-wvga-support").equals("true")) {
                pw.println("<display-mode size=\"WVGA\" type=\"MONO\"/>");
            }
            if (this.getProject().getProperty("ricoh.dalp.display-mode.is-4line-support").equals("true")) {
                pw.println("<display-mode size=\"4LINE\" type=\"MONO\"/>");
            }
        } else {
            pw.println("<display-mode size=\"HVGA\" type=\"MONO\"/>");
        }
    }
}

