/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InvalidJSRAnnotations
extends AbstractWebServiceRule {
    @Override
    protected ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        AnnotationMirror annotationMirror = Utilities.findAnnotation(typeElement, "javax.jws.WebService");
        if (typeElement.getKind() == ElementKind.CLASS && Utilities.getAnnotationAttrValue(annotationMirror, "endpointInterface") != null) {
            for (String string : new String[]{"javax.jws.WebMethod", "javax.jws.WebParam", "javax.jws.WebResult", "javax.jws.Oneway", "javax.jws.soap.SOAPMessageHandlers", "javax.jws.soap.InitParam", "javax.jws.soap.SOAPBinding", "javax.jws.soap.SOAPMessageHandler"}) {
                AnnotationMirror annotationMirror2 = Utilities.findAnnotation(typeElement, string);
                if (annotationMirror2 == null) continue;
                String string2 = NbBundle.getMessage(InvalidJSRAnnotations.class, (String)"MSG_Invalid_JSR181Annotation");
                Tree tree = problemContext.getCompilationInfo().getTrees().getTree(typeElement, annotationMirror2);
                RemoveAnnotation removeAnnotation = new RemoveAnnotation(problemContext.getFileObject(), typeElement, annotationMirror2);
                problemContext.setElementToAnnotate(tree);
                arrayList.add(InvalidJSRAnnotations.createProblem((Element)typeElement, problemContext, string2, removeAnnotation));
                problemContext.setElementToAnnotate(null);
            }
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new ErrorDescription[arrayList.size()]);
    }
}

