/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.packets.DbgpCommand;

public class FeatureGetCommand
extends DbgpCommand {
    static final String FEATURE_GET = "feature_get";
    private static final String NAME_ARG = "-n ";
    private String myName;

    public FeatureGetCommand(String transactionId) {
        this(FEATURE_GET, transactionId);
    }

    protected FeatureGetCommand(String command, String transactionId) {
        super(command, transactionId);
    }

    public void setFeature(Feature feature) {
        this.myName = feature.toString();
    }

    public void setFeature(String name) {
        this.myName = name;
    }

    @Override
    protected String getArguments() {
        return NAME_ARG + this.myName;
    }

    @Override
    public boolean wantAcknowledgment() {
        return true;
    }

    public static enum Feature {
        LANGUAGE_SUPPORTS_THREADS,
        LANGUAGE_NAME,
        LANGUAGE_VERSION,
        ENCODING,
        PROTOCOL_VERSION,
        SUPPORTS_ASYNC,
        DATA_ENCODING,
        BREAKPOINT_LANGUAGES,
        BREAKPOINT_TYPES,
        MULTIPLE_SESSIONS,
        MAX_CHILDREN,
        MAX_DATA,
        MAX_DEPTH,
        SUPPORTS_POSTMORTEM,
        SHOW_HIDDEN,
        NOTIFY_OK,
        BREAK,
        EVAL,
        EXPR,
        EXEC;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public Feature forString(String str) {
            Feature[] features;
            for (Feature feature : features = Feature.values()) {
                if (!str.equals(feature.toString())) continue;
                return feature;
            }
            return null;
        }
    }
}

