/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.ui.manager;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.server.ServerRegistry;
import org.netbeans.modules.server.ui.wizard.AddServerInstanceWizard;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ServerManagerPanel
extends JPanel
implements PropertyChangeListener,
VetoableChangeListener,
ExplorerManager.Provider {
    private static final String SERVERS_ICON = "org/netbeans/modules/server/ui/resources/servers.png";
    private static final Logger LOGGER = Logger.getLogger(ServerManagerPanel.class.getName());
    private static final Dimension MINIMUM_SIZE = new Dimension(750, 450);
    private ServersChildren children;
    private ExplorerManager manager;
    private ServerInstance initialInstance;
    private JButton addButton;
    private JPanel cardsPanel;
    private JPanel clientPanel;
    private JPanel customizerPanel;
    private JPanel emptyPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel3;
    private JButton removeButton;
    private JTextField serverName;
    private JTextField serverType;
    private JLabel serversLabel;
    private BeanTreeView serversView;

    public ServerManagerPanel(ServerInstance initialInstance) {
        this.initComponents();
        this.serverName.setColumns(30);
        this.serverType.setColumns(30);
        this.serversView.setPreferredSize(new Dimension(200, 200));
        this.initialInstance = initialInstance;
        this.setPreferredSize(MINIMUM_SIZE);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.expandServers(this.initialInstance);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] nodes = (Node[])evt.getNewValue();
            if (nodes.length != 1) {
                this.selectServer(null);
            } else {
                this.selectServer(nodes[0]);
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Node[] nodes;
        if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = (Node[])evt.getNewValue()).length != 1) {
            throw new PropertyVetoException("Invalid length", evt);
        }
    }

    public synchronized ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.setRootContext((Node)new ServersNode(Children.create((ChildFactory)this.getChildren(), (boolean)false)));
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
        }
        return this.manager;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.serversView = new BeanTreeView();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.cardsPanel = new JPanel();
        this.emptyPanel = new JPanel();
        this.customizerPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.serverName = new JTextField();
        this.jLabel2 = new JLabel();
        this.serverType = new JTextField();
        this.clientPanel = new JPanel();
        this.serversLabel = new JLabel();
        this.serversView.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
        this.serversView.setPopupAllowed(false);
        this.serversView.setPreferredSize(new Dimension(220, 400));
        this.serversView.setSelectionMode(0);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_AddServer"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerManagerPanel.this.addServer(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerManagerPanel.this.removeServer(evt);
            }
        });
        this.cardsPanel.setLayout(new CardLayout());
        this.emptyPanel.setLayout(new GridBagLayout());
        this.cardsPanel.add((Component)this.emptyPanel, "card3");
        this.customizerPanel.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.serverName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_ServerName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.customizerPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_ServerName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_ServerName"));
        this.serverName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.customizerPanel.add((Component)this.serverName, gridBagConstraints);
        this.serverName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_ServerName"));
        this.serverName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_ServerName"));
        this.jLabel2.setLabelFor(this.serverType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_ServerType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.customizerPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_ServerType"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_ServerType"));
        this.serverType.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.customizerPanel.add((Component)this.serverType, gridBagConstraints);
        this.serverType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_ServerType"));
        this.serverType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_ServerType"));
        this.clientPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.customizerPanel.add((Component)this.clientPanel, gridBagConstraints);
        this.cardsPanel.add((Component)this.customizerPanel, "card2");
        this.serversLabel.setLabelFor((Component)this.serversView);
        Mnemonics.setLocalizedText((JLabel)this.serversLabel, (String)NbBundle.getMessage(ServerManagerPanel.class, (String)"CTL_Servers"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.serversLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.serversView, -2, 0, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton))).addPreferredGap(1).add((Component)this.cardsPanel, -1, 267, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.serversLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.cardsPanel, -1, 271, Short.MAX_VALUE).add(1, (Component)this.serversView, -1, 271, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.addButton).add((Component)this.removeButton)).addContainerGap()));
        this.serversView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_InstalledServers"));
        this.serversView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_InstalledServers"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_AddServer"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_AddServer"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCN_Remove"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ASCD_Remove"));
        this.serversLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ACSN_ServerList"));
        this.serversLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ACSD_ServerList"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerManagerPanel.class, (String)"ACSN_ServerManager"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"ACSD_ServerManager"));
    }

    private void removeServer(ActionEvent evt) {
        ServerInstance serverInstance;
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes[0] instanceof ServerNode && (serverInstance = ((ServerNode)nodes[0]).getServerInstance()).isRemovable()) {
            serverInstance.remove();
            this.getChildren().refresh();
            this.expandServers(null);
        }
    }

    private void addServer(ActionEvent evt) {
        ServerInstance instance = AddServerInstanceWizard.showAddServerInstanceWizard();
        if (instance != null) {
            this.getChildren().refresh();
            this.expandServers(instance);
        }
    }

    private synchronized ServersChildren getChildren() {
        if (this.children == null) {
            this.children = new ServersChildren();
        }
        return this.children;
    }

    private void selectServer(Node aNode) {
        JComponent component;
        this.clientPanel.removeAll();
        ServerInstance serverInstance = null;
        if (aNode instanceof ServerNode) {
            serverInstance = ((ServerNode)aNode).getServerInstance();
            this.serverName.setText(serverInstance.getDisplayName());
            this.serverType.setText(serverInstance.getServerDisplayName());
            if (!serverInstance.isRemovable()) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
            }
        } else {
            this.removeButton.setEnabled(false);
            ((CardLayout)this.cardsPanel.getLayout()).first(this.cardsPanel);
            return;
        }
        if (serverInstance.getCustomizer() != null && (component = serverInstance.getCustomizer()) != null) {
            ServerManagerPanel.addComponent(this.clientPanel, component);
        }
        int height = this.getHeight();
        int width = this.getWidth();
        this.setPreferredSize(null);
        this.revalidate();
        Dimension prefSize = this.getPreferredSize();
        int prefWidth = (int)(prefSize.getWidth() > MINIMUM_SIZE.getWidth() ? prefSize.getWidth() : MINIMUM_SIZE.getWidth());
        int prefHeight = (int)(prefSize.getHeight() > MINIMUM_SIZE.getHeight() ? prefSize.getHeight() : MINIMUM_SIZE.getHeight());
        if (prefHeight > height || prefWidth > width) {
            this.setPreferredSize(new Dimension(prefWidth > width ? prefWidth : width, prefHeight > height ? prefHeight : height));
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Window)) continue;
                ((Window)parent).pack();
                break;
            }
        }
        CardLayout cl = (CardLayout)this.cardsPanel.getLayout();
        cl.last(this.cardsPanel);
    }

    private static void addComponent(Container container, Component component) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = -1;
        c.gridx = -1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weighty = 1.0;
        c.weightx = 1.0;
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    private void expandServers(ServerInstance servInst) {
        ExplorerManager mgr = this.getExplorerManager();
        Node node = mgr.getRootContext();
        ServerManagerPanel.expandAllNodes(this.serversView, node, mgr, servInst);
    }

    private static void expandAllNodes(BeanTreeView btv, Node node, ExplorerManager mgr, ServerInstance servInst) {
        Children ch = node.getChildren();
        if (servInst != null && ch == Children.LEAF && node instanceof ServerNode) {
            try {
                if (((ServerNode)node).getServerInstance() == servInst) {
                    mgr.setSelectedNodes(new Node[]{node});
                }
            }
            catch (PropertyVetoException e) {
                LOGGER.log(Level.FINE, null, e);
            }
        }
        if (servInst == null && ch == Children.LEAF && mgr.getSelectedNodes().length == 0) {
            try {
                mgr.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException e) {
                LOGGER.log(Level.FINE, null, e);
            }
        }
        Node[] nodes = ch.getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            ServerManagerPanel.expandAllNodes(btv, nodes[i], mgr, servInst);
        }
    }

    private static class InstanceComparator
    implements Comparator<ServerInstance>,
    Serializable {
        private InstanceComparator() {
        }

        @Override
        public int compare(ServerInstance o1, ServerInstance o2) {
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    }

    private static class ServerNode
    extends FilterNode {
        private final ServerInstance serverInstance;

        public ServerNode(ServerInstance serverInstance) {
            super(serverInstance.getBasicNode());
            this.serverInstance = serverInstance;
            this.setChildren(FilterNode.Children.LEAF);
        }

        public ServerInstance getServerInstance() {
            return this.serverInstance;
        }
    }

    private static class ServersChildren
    extends ChildFactory<ServerInstance> {
        private static final Comparator<ServerInstance> COMPARATOR = new InstanceComparator();

        protected final void refresh() {
            this.refresh(true);
        }

        protected Node createNodeForKey(ServerInstance key) {
            boolean assertsEnabled = false;
            if (!$assertionsDisabled) {
                assertsEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (null != key.getBasicNode()) {
                return new ServerNode(key);
            }
            if (assertsEnabled) {
                LOGGER.log(Level.WARNING, "Server instance {0} return null basic node.While this may be ok it is usually a bug.", key);
            }
            return null;
        }

        protected boolean createKeys(List<ServerInstance> toPopulate) {
            ArrayList<ServerInstance> fresh = new ArrayList<ServerInstance>();
            for (ServerInstanceProvider serverInstanceProvider : ServerRegistry.getInstance().getProviders()) {
                for (ServerInstance instance : serverInstanceProvider.getInstances()) {
                    if (null != instance.getDisplayName()) {
                        fresh.add(instance);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Found server instance with a null display name {0} {1}", new Object[]{instance.getServerDisplayName(), instance.toString()});
                }
            }
            Collections.sort(fresh, COMPARATOR);
            toPopulate.addAll(fresh);
            return true;
        }
    }

    private static class ServersNode
    extends AbstractNode {
        public ServersNode(Children children) {
            super(children);
            this.setName("");
            this.setDisplayName(NbBundle.getMessage(ServerManagerPanel.class, (String)"Server_Registry_Node_Name"));
            this.setShortDescription(NbBundle.getMessage(ServerManagerPanel.class, (String)"Server_Registry_Node_Short_Description"));
            this.setIconBaseWithExtension(ServerManagerPanel.SERVERS_ICON);
        }
    }
}

