/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.modules.cnd.repository.sfs.BufferDataInput;
import org.netbeans.modules.cnd.repository.sfs.FileRWAccess;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class BufferedRWAccess
implements FileRWAccess {
    private RandomAccessFile randomAccessFile;
    protected FileChannel channel;
    private ByteBuffer writeBuffer;
    private int bufSize = Stats.bufSize > 0 ? Stats.bufSize : 32768;

    public BufferedRWAccess(File file) throws IOException {
        File parent = new File(file.getParent());
        if (!parent.exists()) {
            parent.mkdirs();
        }
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        this.channel = this.randomAccessFile.getChannel();
        ByteBuffer.allocateDirect(this.bufSize);
    }

    @Override
    public Persistent read(PersistentFactory factory, long offset, int size) throws IOException {
        try {
            ByteBuffer buffer = this.getReadBuffer(size);
            this.channel.read(buffer, offset);
            buffer.flip();
            BufferDataInput in = new BufferDataInput(buffer);
            return factory.read((DataInput)in);
        }
        catch (BufferOverflowException e) {
            e.printStackTrace(System.err);
            throw e;
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    @Override
    public int write(PersistentFactory factory, Persistent object, long offset) throws IOException {
        this.channel.position(offset);
        ByteBufferOutputStream bos = new ByteBufferOutputStream(this.getWriteBuffer());
        DataOutputStream out = new DataOutputStream(bos);
        factory.write((DataOutput)out, object);
        int count = bos.count();
        this.writeBuffer();
        return count;
    }

    protected ByteBuffer getWriteBuffer() {
        if (this.writeBuffer == null) {
            this.writeBuffer = ByteBuffer.allocateDirect(this.bufSize);
        }
        return this.writeBuffer;
    }

    protected ByteBuffer getReadBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        return buffer;
    }

    protected void writeBuffer() throws IOException {
        this.writeBuffer.flip();
        this.channel.write(this.writeBuffer);
        this.writeBuffer.clear();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public void truncate(long size) throws IOException {
        this.channel.truncate(size);
        this.channel.position(size);
    }

    @Override
    public void move(long offset, int size, long newOffset) throws IOException {
        ByteBuffer buffer = this.getReadBuffer(size);
        this.channel.read(buffer, offset);
        buffer.flip();
        this.channel.write(buffer, newOffset);
    }

    @Override
    public void move(FileRWAccess from, long offset, int size, long newOffset) throws IOException {
        if (!(from instanceof BufferedRWAccess)) {
            throw new IllegalArgumentException("Illegal class to move from: " + from.getClass().getName());
        }
        BufferedRWAccess from2 = (BufferedRWAccess)from;
        ByteBuffer buffer = this.getReadBuffer(size);
        from2.channel.read(buffer, offset);
        buffer.flip();
        this.channel.write(buffer, newOffset);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    private class ByteBufferOutputStream
    extends OutputStream {
        private int oldPosition;
        private int flushed = 0;
        private ByteBuffer buffer;

        public ByteBufferOutputStream(ByteBuffer buffer) {
            this.buffer = buffer;
            this.oldPosition = buffer.position();
        }

        @Override
        public void write(int b) throws IOException {
            if (this.buffer.remaining() <= 0) {
                this.flushed += this.buffer.position();
                BufferedRWAccess.this.writeBuffer();
            }
            this.buffer.put((byte)b);
        }

        private int count() {
            return this.flushed + this.buffer.position() - this.oldPosition;
        }
    }
}

