/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import org.netbeans.modules.cnd.repository.testbench.Stats;

public class WriteStatistics {
    private static final WriteStatistics instance = new WriteStatistics();
    private long writeStatIntervalStart = 0L;
    private int writeStatInterval = 1000;
    private int writeCount = 0;
    private long totalWriteCount = 0L;

    private WriteStatistics() {
    }

    public static final WriteStatistics instance() {
        return instance;
    }

    public void update(int increment) {
        this.totalWriteCount += (long)increment;
        long currTime = System.currentTimeMillis();
        if (this.writeStatIntervalStart == 0L) {
            this.writeCount = increment;
            this.writeStatIntervalStart = System.currentTimeMillis();
        } else if (currTime - this.writeStatIntervalStart < (long)this.writeStatInterval) {
            this.writeCount += increment;
        } else {
            int currentWPS = (int)(1000L * (long)this.writeCount / (currTime - this.writeStatIntervalStart));
            this.writeStatIntervalStart = currTime;
            if (Stats.writeStatistics) {
                System.err.printf("\tcurrent writes: %4d current WPS: %4d  total writes: %8d \n", this.writeCount, currentWPS, this.totalWriteCount);
            }
            this.writeCount = increment;
        }
    }
}

