/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.design.view.DesignView;
import org.netbeans.modules.websvc.design.view.DesignViewPopupProvider;
import org.netbeans.modules.websvc.design.view.actions.GotoSourceAction;
import org.netbeans.modules.websvc.design.view.actions.RemoveOperationAction;
import org.netbeans.modules.websvc.design.view.widget.AbstractTitledWidget;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.DescriptionWidget;
import org.netbeans.modules.websvc.design.view.widget.FaultsWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.netbeans.modules.websvc.design.view.widget.OutputWidget;
import org.netbeans.modules.websvc.design.view.widget.ParametersWidget;
import org.netbeans.modules.websvc.design.view.widget.SampleMessageWidget;
import org.netbeans.modules.websvc.design.view.widget.TabbedPaneWidget;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class OperationWidget
extends AbstractTitledWidget {
    private static final String IMAGE_ONE_WAY = "org/netbeans/modules/websvc/design/view/resources/oneway_operation.png";
    private static final String IMAGE_REQUEST_RESPONSE = "org/netbeans/modules/websvc/design/view/resources/requestresponse_operation.png";
    private static final String IMAGE_NOTIFICATION = "org/netbeans/modules/websvc/design/view/resources/notification_operation.png";
    private Service service;
    private MethodModel operation;
    private ServiceModel serviceModel;
    private transient Widget buttons;
    private transient ImageLabelWidget headerLabelWidget;
    private transient TabbedPaneWidget tabbedWidget;
    private transient Widget listWidget;
    private transient ButtonWidget viewButton;
    private transient RemoveOperationAction removeAction;
    private ParametersWidget inputWidget;
    private OutputWidget outputWidget;
    private FaultsWidget faultWidget;
    private DescriptionWidget descriptionWidget;

    public OperationWidget(ObjectScene objectScene, ServiceModel serviceModel, Service service, MethodModel methodModel) {
        super(objectScene, 12, 12, 6, BORDER_COLOR);
        this.service = service;
        this.operation = methodModel;
        this.serviceModel = serviceModel;
        this.removeAction = new RemoveOperationAction(service);
        this.removeAction.setWorkingSet(Collections.singleton(methodModel));
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)new DesignViewPopupProvider(new Action[]{new GotoSourceAction(methodModel, serviceModel.getImplementationClass()), this.removeAction})));
        this.createContent();
    }

    public MethodModel getMethodModel() {
        return this.operation;
    }

    private void createContent() {
        String string = "";
        Image image = null;
        if (this.operation.isOneWay()) {
            string = NbBundle.getMessage(OperationWidget.class, (String)"LBL_OneWay");
            image = ImageUtilities.loadImage((String)IMAGE_ONE_WAY);
        } else if (!this.operation.getParams().isEmpty()) {
            string = NbBundle.getMessage(OperationWidget.class, (String)"LBL_RequestResponse");
            image = ImageUtilities.loadImage((String)IMAGE_REQUEST_RESPONSE);
        } else {
            string = NbBundle.getMessage(OperationWidget.class, (String)"LBL_Notification");
            image = ImageUtilities.loadImage((String)IMAGE_NOTIFICATION);
        }
        this.headerLabelWidget = new ImageLabelWidget(this.getScene(), image, this.operation.getOperationName()){
            private Object key;
            {
                this.key = new Object();
            }

            protected void notifyAdded() {
                super.notifyAdded();
                OperationWidget.this.getObjectScene().addObject(this.key, new Widget[]{OperationWidget.this.headerLabelWidget});
            }

            protected void notifyRemoved() {
                super.notifyRemoved();
                OperationWidget.this.getObjectScene().removeObject(this.key);
            }
        };
        this.headerLabelWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
        this.headerLabelWidget.setLabelEditor(new TextFieldInplaceEditor(){

            public boolean isEnabled(Widget widget) {
                return OperationWidget.this.isNameEditable();
            }

            public String getText(Widget widget) {
                return OperationWidget.this.headerLabelWidget.getLabel();
            }

            public void setText(Widget widget, String string) {
                OperationWidget.this.operation.setOperationName(string);
                OperationWidget.this.headerLabelWidget.setLabel(string);
            }
        });
        this.headerLabelWidget.setToolTipText(string);
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)8));
        this.viewButton = new ButtonWidget(this.getScene(), null, null);
        this.viewButton.setImage(new TabImageWidget(this.getScene(), 16));
        this.viewButton.setSelectedImage((Object)new ListImageWidget(this.getScene(), 16));
        this.viewButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OperationWidget.this.setTabbedView(!OperationWidget.this.viewButton.isSelected());
            }
        });
        this.buttons.addChild((Widget)this.viewButton);
        for (final SampleMessageWidget.Type type : SampleMessageWidget.Type.values()) {
            final ButtonWidget buttonWidget = new ButtonWidget(this.getScene(), null, null);
            buttonWidget.setImage(type.getIcon(this.getScene()));
            buttonWidget.setAction(new AbstractAction(){
                SampleMessageWidget messageWidget;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Widget widget = OperationWidget.this.getObjectScene().findWidget(DesignView.messageLayerKey);
                    if (this.messageWidget != null && widget.getChildren().contains(this.messageWidget)) {
                        widget.removeChild((Widget)this.messageWidget);
                        this.messageWidget = null;
                    } else {
                        widget.removeChildren();
                        this.messageWidget = new SampleMessageWidget(OperationWidget.this.getObjectScene(), OperationWidget.this.operation, type){

                            @Override
                            protected void notifyAdded() {
                                super.notifyAdded();
                                buttonWidget.setOpaque(true);
                                buttonWidget.setSelected(true);
                            }

                            @Override
                            protected void notifyRemoved() {
                                super.notifyRemoved();
                                buttonWidget.setOpaque(false);
                                buttonWidget.setSelected(false);
                            }
                        };
                        widget.addChild((Widget)this.messageWidget);
                    }
                }
            });
            buttonWidget.setToolTipText(type.getDescription());
            this.buttons.addChild((Widget)buttonWidget);
        }
        this.buttons.addChild((Widget)this.getExpanderWidget());
        this.getHeaderWidget().addChild(this.buttons);
        this.listWidget = new Widget(this.getScene());
        this.listWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)6));
        this.inputWidget = new ParametersWidget(this.getObjectScene(), this.operation, this.isNameEditable());
        this.outputWidget = new OutputWidget(this.getObjectScene(), this.operation);
        this.faultWidget = new FaultsWidget(this.getObjectScene(), this.operation);
        this.descriptionWidget = new DescriptionWidget(this.getObjectScene(), this.operation);
        this.listWidget.addChild((Widget)this.inputWidget);
        this.listWidget.addChild((Widget)this.outputWidget);
        this.listWidget.addChild((Widget)this.faultWidget);
        this.listWidget.addChild((Widget)this.descriptionWidget);
        this.tabbedWidget = new TabbedPaneWidget(this.getScene());
        this.tabbedWidget.addTab(this.inputWidget);
        this.tabbedWidget.addTab(this.outputWidget);
        this.tabbedWidget.addTab(this.faultWidget);
        this.tabbedWidget.addTab(this.descriptionWidget);
        this.setTabbedView(!this.viewButton.isSelected());
    }

    @Override
    protected void collapseWidget() {
        if (this.buttons != null && this.buttons.getParentWidget() != null) {
            this.getHeaderWidget().revalidate(true);
            this.buttons.removeChild((Widget)this.getExpanderWidget());
            this.getHeaderWidget().removeChild(this.buttons);
            this.getHeaderWidget().addChild((Widget)this.getExpanderWidget());
        }
        super.collapseWidget();
        if (this.hashKey() != null) {
            this.getObjectScene().setSelectedObjects(Collections.singleton(this.hashKey()));
            this.getObjectScene().setFocusedObject(this.hashKey());
        }
    }

    @Override
    protected void expandWidget() {
        if (this.buttons != null && this.buttons.getParentWidget() == null) {
            this.getHeaderWidget().revalidate(true);
            this.getHeaderWidget().removeChild((Widget)this.getExpanderWidget());
            this.buttons.addChild((Widget)this.getExpanderWidget());
            this.getHeaderWidget().addChild(this.buttons);
        }
        super.expandWidget();
        if (this.hashKey() != null) {
            this.getObjectScene().setSelectedObjects(Collections.singleton(this.hashKey()));
            this.getObjectScene().setFocusedObject(this.hashKey());
        }
    }

    @Override
    public Object hashKey() {
        return this.operation;
    }

    private void setTabbedView(boolean bl) {
        if (this.viewButton.isSelected() != bl) {
            this.viewButton.setSelected(bl);
            if (bl) {
                if (this.listWidget.getParentWidget() == this.getContentWidget()) {
                    this.getContentWidget().removeChild(this.listWidget);
                }
                this.getContentWidget().addChild((Widget)this.tabbedWidget);
            } else {
                if (this.tabbedWidget.getParentWidget() == this.getContentWidget()) {
                    this.getContentWidget().removeChild((Widget)this.tabbedWidget);
                }
                this.getContentWidget().addChild(this.listWidget);
            }
        }
    }

    private boolean isNameEditable() {
        return this.service != null && this.service.getWsdlUrl() == null;
    }

    private static class TabImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        public TabImageWidget(Scene scene, int n) {
            super(scene, Color.LIGHT_GRAY, n, n);
            this.setBorder(BorderFactory.createLineBorder((int)0, (Color)Color.LIGHT_GRAY));
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.setToolTipText(NbBundle.getMessage(OperationWidget.class, (String)"Hint_TabbedView"));
        }

        @Override
        protected Shape createImage(int n, int n2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(1.0f, n2 / 6);
            generalPath.lineTo(2 * n / 3, n2 / 6);
            generalPath.moveTo(1.0f, n2 / 3 + 1);
            generalPath.lineTo(n - 1, n2 / 3 + 1);
            generalPath.moveTo(n / 3, n2 / 6 + 1);
            generalPath.lineTo(n / 3, n2 / 3);
            generalPath.moveTo(2 * n / 3, n2 / 6 + 1);
            generalPath.lineTo(2 * n / 3, n2 / 3);
            return generalPath;
        }
    }

    private static class ListImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        public ListImageWidget(Scene scene, int n) {
            super(scene, Color.LIGHT_GRAY, n, n);
            this.setBorder(BorderFactory.createLineBorder((int)0, (Color)Color.LIGHT_GRAY));
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.setToolTipText(NbBundle.getMessage(OperationWidget.class, (String)"Hint_ListView"));
        }

        @Override
        protected Shape createImage(int n, int n2) {
            GeneralPath generalPath = new GeneralPath();
            float f = n / 5;
            generalPath.moveTo(f, n2 / 4);
            generalPath.lineTo((float)n - f, n2 / 4);
            generalPath.moveTo(f, n2 / 2);
            generalPath.lineTo((float)n - f, n2 / 2);
            generalPath.moveTo(f, 3 * n2 / 4);
            generalPath.lineTo((float)n - 2.0f * f, 3 * n2 / 4);
            return generalPath;
        }
    }
}

