/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.ClassMap;
import org.netbeans.modules.junit.TestGeneratorSetup;

final class JUnit4TestGenerator
extends AbstractTestGenerator {
    static final String ANN_BEFORE_CLASS = "org.junit.BeforeClass";
    static final String ANN_AFTER_CLASS = "org.junit.AfterClass";
    static final String ANN_BEFORE = "org.junit.Before";
    static final String ANN_AFTER = "org.junit.After";
    static final String ANN_TEST = "org.junit.Test";
    private static final String ANN_RUN_WITH = "org.junit.runner.RunWith";
    private static final String ANN_SUITE = "org.junit.runners.Suite";
    private static final String ANN_SUITE_MEMBERS = "SuiteClasses";
    private static final String BEFORE_CLASS_METHOD_NAME = "setUpClass";
    private static final String AFTER_CLASS_METHOD_NAME = "tearDownClass";
    private static final String BEFORE_METHOD_NAME = "setUp";
    private static final String AFTER_METHOD_NAME = "tearDown";

    JUnit4TestGenerator(TestGeneratorSetup testGeneratorSetup) {
        super(testGeneratorSetup);
    }

    JUnit4TestGenerator(TestGeneratorSetup testGeneratorSetup, List<ElementHandle<TypeElement>> list, List<String> list2, boolean bl) {
        super(testGeneratorSetup, list, list2, bl);
    }

    @Override
    protected ClassTree composeNewTestClass(WorkingCopy workingCopy, String string, List<? extends Tree> list) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        return treeMaker.Class(modifiersTree, (CharSequence)string, Collections.emptyList(), null, Collections.emptyList(), list);
    }

    @Override
    protected List<? extends Tree> generateInitMembers(WorkingCopy workingCopy) {
        if (!(this.setup.isGenerateBefore() || this.setup.isGenerateAfter() || this.setup.isGenerateBeforeClass() || this.setup.isGenerateAfterClass())) {
            return Collections.emptyList();
        }
        ArrayList<MethodTree> arrayList = new ArrayList<MethodTree>(4);
        if (this.setup.isGenerateBeforeClass()) {
            arrayList.add(this.generateInitMethod(BEFORE_CLASS_METHOD_NAME, ANN_BEFORE_CLASS, true, workingCopy));
        }
        if (this.setup.isGenerateAfterClass()) {
            arrayList.add(this.generateInitMethod(AFTER_CLASS_METHOD_NAME, ANN_AFTER_CLASS, true, workingCopy));
        }
        if (this.setup.isGenerateBefore()) {
            arrayList.add(this.generateInitMethod(BEFORE_METHOD_NAME, ANN_BEFORE, false, workingCopy));
        }
        if (this.setup.isGenerateAfter()) {
            arrayList.add(this.generateInitMethod(AFTER_METHOD_NAME, ANN_AFTER, false, workingCopy));
        }
        return arrayList;
    }

    @Override
    protected ClassTree generateMissingInitMembers(ClassTree classTree, TreePath treePath, WorkingCopy workingCopy) {
        if (!(this.setup.isGenerateBefore() || this.setup.isGenerateAfter() || this.setup.isGenerateBeforeClass() || this.setup.isGenerateAfterClass())) {
            return classTree;
        }
        ClassMap classMap = ClassMap.forClass(classTree, treePath, workingCopy.getTrees());
        if (!(this.setup.isGenerateBefore() && !classMap.containsBefore() || this.setup.isGenerateAfter() && !classMap.containsAfter() || this.setup.isGenerateBeforeClass() && !classMap.containsBeforeClass() || this.setup.isGenerateAfterClass() && !classMap.containsAfterClass())) {
            return classTree;
        }
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        List<? extends Tree> list = classTree.getMembers();
        ArrayList<Tree> arrayList = new ArrayList<Tree>(list.size() + 4);
        arrayList.addAll(list);
        this.generateMissingInitMembers(arrayList, classMap, workingCopy);
        ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
        return classTree2;
    }

    @Override
    protected boolean generateMissingInitMembers(List<Tree> list, ClassMap classMap, WorkingCopy workingCopy) {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        if (this.setup.isGenerateBeforeClass() && !classMap.containsBeforeClass()) {
            if (classMap.containsAfterClass()) {
                n3 = classMap.getAfterClassIndex();
            } else {
                n2 = classMap.getBeforeIndex();
                n = classMap.getAfterIndex();
                n3 = n2 != -1 && n != -1 ? Math.min(n2, n) : Math.max(n2, n);
            }
            this.addInitMethod(BEFORE_CLASS_METHOD_NAME, ANN_BEFORE_CLASS, true, n3, list, classMap, workingCopy);
            bl = true;
        }
        if (this.setup.isGenerateAfterClass() && !classMap.containsAfterClass()) {
            if (classMap.containsBeforeClass()) {
                n3 = classMap.getBeforeClassIndex() + 1;
            } else {
                n2 = classMap.getBeforeIndex();
                n = classMap.getAfterIndex();
                n3 = n2 != -1 && n != -1 ? Math.min(n2, n) : Math.max(n2, n);
            }
            this.addInitMethod(AFTER_CLASS_METHOD_NAME, ANN_AFTER_CLASS, true, n3, list, classMap, workingCopy);
            bl = true;
        }
        if (this.setup.isGenerateBefore() && !classMap.containsBefore()) {
            if (classMap.containsAfter()) {
                n3 = classMap.getAfterIndex();
            } else {
                n2 = classMap.getBeforeClassIndex();
                n3 = Math.max(n2, n = classMap.getAfterClassIndex());
                if (n3 != -1) {
                    ++n3;
                }
            }
            this.addInitMethod(BEFORE_METHOD_NAME, ANN_BEFORE, false, n3, list, classMap, workingCopy);
            bl = true;
        }
        if (this.setup.isGenerateAfter() && !classMap.containsAfter()) {
            if (classMap.containsBefore()) {
                n3 = classMap.getBeforeIndex() + 1;
            } else {
                n2 = classMap.getBeforeClassIndex();
                n3 = Math.max(n2, n = classMap.getAfterClassIndex());
                if (n3 != -1) {
                    ++n3;
                }
            }
            this.addInitMethod(AFTER_METHOD_NAME, ANN_AFTER, false, n3, list, classMap, workingCopy);
            bl = true;
        }
        return bl;
    }

    private void addInitMethod(String string, String string2, boolean bl, int n, List<Tree> list, ClassMap classMap, WorkingCopy workingCopy) {
        MethodTree methodTree = this.generateInitMethod(string, string2, bl, workingCopy);
        if (n == -1) {
            n = this.getPlaceForFirstInitMethod(classMap);
        }
        if (n != -1) {
            list.add(n, methodTree);
        } else {
            list.add(methodTree);
        }
        classMap.addNoArgMethod(string, string2, n);
    }

    private MethodTree generateInitMethod(String string, String string2, boolean bl, WorkingCopy workingCopy) {
        Set<Modifier> set = bl ? JUnit4TestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC) : Collections.singleton(Modifier.PUBLIC);
        ModifiersTree modifiersTree = this.createModifiersTree(string2, set, workingCopy);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        BlockTree blockTree = treeMaker.Block(Collections.emptyList(), false);
        MethodTree methodTree = treeMaker.Method(modifiersTree, (CharSequence)string, (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(treeMaker.Identifier((CharSequence)"Exception")), blockTree, null);
        return methodTree;
    }

    @Override
    protected void generateMissingPostInitMethods(TreePath treePath, List<Tree> list, ClassMap classMap, WorkingCopy workingCopy) {
    }

    @Override
    protected MethodTree composeNewTestMethod(String string, BlockTree blockTree, List<ExpressionTree> list, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        return treeMaker.Method(this.createModifiersTree(ANN_TEST, JUnit4TestGenerator.createModifierSet(Modifier.PUBLIC), workingCopy), (CharSequence)string, (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), list, blockTree, null);
    }

    @Override
    protected ClassTree finishSuiteClass(ClassTree classTree, TreePath treePath, List<Tree> list, List<String> list2, boolean bl, ClassMap classMap, WorkingCopy workingCopy) {
        ModifiersTree modifiersTree = classTree.getModifiers();
        ModifiersTree modifiersTree2 = this.fixSuiteClassModifiers(classTree, treePath, modifiersTree, list2, workingCopy);
        if (!bl) {
            if (modifiersTree2 != modifiersTree) {
                workingCopy.rewrite((Tree)modifiersTree, (Tree)modifiersTree2);
            }
            return classTree;
        }
        return workingCopy.getTreeMaker().Class(modifiersTree2, (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), list);
    }

    /*
     * WARNING - void declaration
     */
    private ModifiersTree fixSuiteClassModifiers(ClassTree classTree, TreePath treePath, ModifiersTree modifiersTree, List<String> list, WorkingCopy workingCopy) {
        Object object;
        boolean bl = false;
        Set<Modifier> set = modifiersTree.getFlags();
        Set<Modifier> set2 = EnumSet.copyOf(set);
        bl |= set2.remove((Object)Modifier.PRIVATE);
        bl |= set2.remove((Object)Modifier.PROTECTED);
        if (!(bl |= set2.add(Modifier.PUBLIC))) {
            set2 = set;
        }
        boolean bl2 = false;
        List<? extends AnnotationTree> list2 = modifiersTree.getAnnotations();
        if (list2.isEmpty()) {
            ArrayList<AnnotationTree> arrayList = new ArrayList<AnnotationTree>(2);
            arrayList.add(this.createRunWithSuiteAnnotation(workingCopy));
            arrayList.add(this.createSuiteAnnotation(list, workingCopy));
            object = arrayList;
            bl2 = true;
        } else {
            void var19_23;
            Object object2;
            Trees trees = workingCopy.getTrees();
            Element element = trees.getElement(treePath);
            List<? extends AnnotationMirror> list3 = element.getAnnotationMirrors();
            assert (list3.size() == list2.size());
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            for (AnnotationMirror object32 : list3) {
                ++n;
                object2 = object32.getAnnotationType().asElement();
                assert (object2 instanceof TypeElement);
                TypeElement typeElement = (TypeElement)object2;
                Name name = typeElement.getQualifiedName();
                if (n2 == -1 && name.contentEquals(ANN_RUN_WITH)) {
                    n2 = n;
                    continue;
                }
                if (n3 != -1 || !name.contentEquals("org.junit.runners.Suite.SuiteClasses")) continue;
                n3 = n;
            }
            AnnotationTree annotationTree = n2 == -1 || !this.checkRunWithSuiteAnnotation(list3.get(n2), workingCopy) ? this.createRunWithSuiteAnnotation(workingCopy) : list2.get(n2);
            if (n3 == -1 || !this.checkSuiteMembersAnnotation(list3.get(n3), list, workingCopy)) {
                AnnotationTree annotationTree2 = this.createSuiteAnnotation(list, workingCopy);
            } else {
                AnnotationTree annotationTree3 = list2.get(n3);
            }
            if (n2 != -1 && n3 != -1) {
                if (annotationTree != list2.get(n2)) {
                    workingCopy.rewrite((Tree)list2.get(n2), (Tree)annotationTree);
                }
                if (var19_23 != list2.get(n3)) {
                    workingCopy.rewrite((Tree)list2.get(n3), (Tree)var19_23);
                }
                object = list2;
            } else {
                object2 = new ArrayList(list2.size() + 2);
                if (n2 == -1 && n3 == -1) {
                    object2.add(annotationTree);
                    object2.add(var19_23);
                    if (!list2.isEmpty()) {
                        object2.addAll(list2);
                    }
                } else {
                    object2.addAll(list2);
                    if (n2 == -1) {
                        assert (n3 != 1);
                        object2.add(n3, annotationTree);
                    } else {
                        assert (n2 != -1);
                        object2.add(n2 + 1, var19_23);
                    }
                }
                object = object2;
                bl2 = true;
            }
        }
        if (!bl && !bl2) {
            return modifiersTree;
        }
        return workingCopy.getTreeMaker().Modifiers(set2, object);
    }

    private boolean checkRunWithSuiteAnnotation(AnnotationMirror annotationMirror, WorkingCopy workingCopy) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
        if (map.size() != 1) {
            return false;
        }
        AnnotationValue annotationValue = map.values().iterator().next();
        Name name = this.getAnnotationValueClassName(annotationValue, workingCopy.getTypes());
        return name != null ? name.contentEquals(ANN_SUITE) : false;
    }

    private boolean checkSuiteMembersAnnotation(AnnotationMirror annotationMirror, List<String> list, WorkingCopy workingCopy) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
        if (map.size() != 1) {
            return false;
        }
        AnnotationValue annotationValue = map.values().iterator().next();
        Object object = annotationValue.getValue();
        if (object instanceof List) {
            List list2 = (List)object;
            if (list2.size() != list.size()) {
                return false;
            }
            Types types = workingCopy.getTypes();
            Iterator<String> iterator = list.iterator();
            for (AnnotationValue annotationValue2 : list2) {
                Name name = this.getAnnotationValueClassName(annotationValue2, types);
                if (name == null) {
                    return false;
                }
                if (name.contentEquals(iterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Name getAnnotationValueClassName(AnnotationValue annotationValue, Types types) {
        TypeMirror typeMirror;
        Element element;
        Object object = annotationValue.getValue();
        if (object instanceof TypeMirror && (element = types.asElement(typeMirror = (TypeMirror)object)).getKind() == ElementKind.CLASS) {
            return ((TypeElement)element).getQualifiedName();
        }
        return null;
    }

    private AnnotationTree createRunWithSuiteAnnotation(WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        return treeMaker.Annotation((Tree)this.getClassIdentifierTree(ANN_RUN_WITH, workingCopy), Collections.singletonList(treeMaker.MemberSelect(this.getClassIdentifierTree(ANN_SUITE, workingCopy), (CharSequence)"class")));
    }

    private AnnotationTree createSuiteAnnotation(List<String> list, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ArrayList<MemberSelectTree> arrayList = new ArrayList<MemberSelectTree>(list.size());
        for (String string : list) {
            arrayList.add(treeMaker.MemberSelect(this.getClassIdentifierTree(string, workingCopy), (CharSequence)"class"));
        }
        return treeMaker.Annotation((Tree)treeMaker.MemberSelect(this.getClassIdentifierTree(ANN_SUITE, workingCopy), (CharSequence)ANN_SUITE_MEMBERS), Collections.singletonList(treeMaker.NewArray(null, Collections.emptyList(), arrayList)));
    }
}

