/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.junit.TestabilityJudge;
import org.netbeans.modules.junit.TestabilityResult;
import org.openide.filesystems.FileObject;

final class TopClassFinder {
    private TopClassFinder() {
    }

    static List<ElementHandle<TypeElement>> findTopClasses(JavaSource javaSource) throws IOException {
        TopClassFinderTask topClassFinderTask = new TopClassFinderTask();
        javaSource.runUserActionTask((Task)topClassFinderTask, true);
        return topClassFinderTask.topClassElems;
    }

    static List<ElementHandle<TypeElement>> findMainTopClasses(JavaSource javaSource) throws IOException {
        TopClassFinderTask topClassFinderTask = new TopClassFinderTask(new MainClassOnly());
        javaSource.runUserActionTask((Task)topClassFinderTask, true);
        return topClassFinderTask.topClassElems;
    }

    static List<ElementHandle<TypeElement>> findTestableTopClasses(JavaSource javaSource, TestabilityJudge testabilityJudge, Collection<TestabilityResult.SkippedClass> collection, long l) throws IOException {
        TopClassFinderTask topClassFinderTask = new TopClassFinderTask(new ExtendedTestabilityFilter(testabilityJudge, collection, l));
        javaSource.runUserActionTask((Task)topClassFinderTask, true);
        return topClassFinderTask.topClassElems;
    }

    static List<ClassTree> findTopClasses(CompilationUnitTree compilationUnitTree, TreeUtilities treeUtilities) {
        List<? extends Tree> list = compilationUnitTree.getTypeDecls();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClassTree> arrayList = new ArrayList<ClassTree>(list.size());
        for (Tree tree : list) {
            ClassTree classTree;
            if (tree.getKind() != Tree.Kind.CLASS || !TopClassFinder.isTestable(classTree = (ClassTree)tree, treeUtilities)) continue;
            arrayList.add(classTree);
        }
        return arrayList;
    }

    private static List<TypeElement> findTopClassElems(CompilationInfo compilationInfo, CompilationUnitTree compilationUnitTree, Filter filter) {
        List<? extends Tree> list = compilationUnitTree.getTypeDecls();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>(list.size());
        Trees trees = compilationInfo.getTrees();
        for (Tree tree : list) {
            Element element;
            TypeElement typeElement;
            if (tree.getKind() != Tree.Kind.CLASS || !filter.passes(typeElement = (TypeElement)(element = trees.getElement(new TreePath(new TreePath(compilationUnitTree), tree))), compilationInfo)) continue;
            arrayList.add(typeElement);
        }
        return arrayList;
    }

    private static List<ElementHandle<TypeElement>> findTopClassElemHandles(CompilationInfo compilationInfo, CompilationUnitTree compilationUnitTree, Filter filter) {
        return TopClassFinder.getElemHandles(TopClassFinder.findTopClassElems(compilationInfo, compilationUnitTree, filter));
    }

    private static <T extends Element> List<ElementHandle<T>> getElemHandles(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ElementHandle<T>> arrayList = new ArrayList<ElementHandle<T>>(list.size());
        for (Element element : list) {
            arrayList.add(ElementHandle.create((Element)element));
        }
        return arrayList;
    }

    private static boolean isTestable(ClassTree classTree, TreeUtilities treeUtilities) {
        return !treeUtilities.isAnnotation(classTree);
    }

    static boolean isTestable(TypeElement typeElement) {
        ElementKind elementKind = typeElement.getKind();
        return elementKind != ElementKind.ANNOTATION_TYPE && (elementKind.isClass() || elementKind.isInterface());
    }

    private static class TopClassFinderTask
    implements CancellableTask<CompilationController> {
        private final Filter filter;
        private List<ElementHandle<TypeElement>> topClassElems;
        private volatile boolean cancelled;

        private TopClassFinderTask() {
            this(new BasicTestabilityFilter());
        }

        private TopClassFinderTask(Filter filter) {
            this.filter = filter;
        }

        public void run(CompilationController compilationController) throws IOException {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            if (this.cancelled) {
                return;
            }
            if (this.topClassElems == null) {
                this.topClassElems = new ArrayList<ElementHandle<TypeElement>>(10);
            }
            this.topClassElems.addAll(TopClassFinder.findTopClassElemHandles((CompilationInfo)compilationController, compilationController.getCompilationUnit(), this.filter));
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    static final class ExtendedTestabilityFilter
    implements Filter {
        private final TestabilityJudge testabilityJudge;
        private final Collection<TestabilityResult.SkippedClass> nonTestable;
        private final long skipTestabilityResultMask;

        ExtendedTestabilityFilter(TestabilityJudge testabilityJudge, Collection<TestabilityResult.SkippedClass> collection, long l) {
            this.testabilityJudge = testabilityJudge;
            this.nonTestable = collection;
            this.skipTestabilityResultMask = l;
        }

        @Override
        public boolean passes(TypeElement typeElement, CompilationInfo compilationInfo) {
            TestabilityResult testabilityResult = this.testabilityJudge.isClassTestable(compilationInfo, typeElement, this.skipTestabilityResultMask);
            if (testabilityResult.isTestable()) {
                return true;
            }
            this.nonTestable.add(new TestabilityResult.SkippedClass(typeElement.getQualifiedName().toString(), testabilityResult));
            return false;
        }
    }

    static final class MainClassOnly
    extends BasicTestabilityFilter {
        MainClassOnly() {
        }

        @Override
        public boolean passes(TypeElement typeElement, CompilationInfo compilationInfo) {
            if (!super.passes(typeElement, compilationInfo)) {
                return false;
            }
            FileObject fileObject = compilationInfo.getFileObject();
            ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
            String string = typeElement.getQualifiedName().toString();
            return string.equals(classPath.getResourceName(fileObject, '.', false));
        }
    }

    static class BasicTestabilityFilter
    implements Filter {
        BasicTestabilityFilter() {
        }

        @Override
        public boolean passes(TypeElement typeElement, CompilationInfo compilationInfo) {
            ElementKind elementKind = typeElement.getKind();
            return elementKind != ElementKind.ANNOTATION_TYPE && (elementKind.isClass() || elementKind.isInterface());
        }
    }

    static interface Filter {
        public boolean passes(TypeElement var1, CompilationInfo var2);
    }
}

