/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.doclet;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import org.netbeans.tax.TreeAttlistDeclAttributeDef;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeComment;
import org.netbeans.tax.TreeDTD;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeParameterEntityReference;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.decl.ANYType;
import org.netbeans.tax.decl.ChildrenType;
import org.netbeans.tax.decl.EMPTYType;
import org.netbeans.tax.decl.LeafType;
import org.netbeans.tax.decl.TypeCollection;
import org.openide.util.NbBundle;

public class DTDDoclet {
    private RefList s;
    private RefList elementIndex = new RefList();
    private String comment;
    private String currentElement = null;
    private HashMap elementRefs = new HashMap();
    private final String HEADLINE1 = "h2";
    private final String HEADLINE2 = "b";
    private final String LIST = "ul";
    private final String LIST_ITEM = "li";
    private final String PAR = "p";
    private final String ROOT = "html";
    private final String BODY = "body";

    public String createDoclet(TreeDTD dtd, String encoding) {
        if (dtd == null) {
            return "";
        }
        this.s = new RefList();
        this.s.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
        this.s.appendStartTag("html").append("\n<head>\n<title>" + NbBundle.getMessage((Class)DTDDoclet.class, (String)"PAGE_TITLE") + "</title>\n");
        this.s.append("<meta http-equiv=\"Content-Type\" content=\"text/xhtml; charset=" + encoding + "\" />\n");
        this.s.append("</head>\n");
        this.s.append("\n<!-- Generated on " + DateFormat.getDateInstance().format(new Date()) + " by NetBeans XML module. -->\n");
        this.s.appendStartTag("body");
        this.headline1(NbBundle.getMessage((Class)DTDDoclet.class, (String)"TEXT_Element_Index"));
        this.s.append(this.elementIndex);
        this.headline1(NbBundle.getMessage((Class)DTDDoclet.class, (String)"TEXT_Element_Details"));
        Iterator<Object> it = dtd.getChildNodes(TreeChild.class, true).iterator();
        Vector list = new Vector();
        while (it.hasNext()) {
            TreeNode child = (TreeNode)it.next();
            if (child instanceof TreeElementDecl) {
                this.commentElement((TreeElementDecl)child);
                this.comment = null;
                continue;
            }
            if (child instanceof TreeComment) {
                this.comment = this.decodeComment((TreeComment)child);
                continue;
            }
            if (child instanceof TreeText || child instanceof TreeParameterEntityReference) continue;
            this.comment = null;
        }
        TreeSet<Object> index = new TreeSet<Object>();
        it = this.elementRefs.keySet().iterator();
        while (it.hasNext()) {
            index.add(it.next());
        }
        this.elementIndex.appendStartTag("ul");
        it = index.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            this.listitem(this.elementIndex, "<a href=\"#" + next + "\">" + next + "</a>");
        }
        this.elementIndex.appendEndTag("ul");
        this.s.appendEndTag("body").appendEndTag("html");
        return this.s.toString();
    }

    private String decodeComment(TreeComment node) {
        return node.getData().startsWith("-") ? node.getData().substring(1).trim() : null;
    }

    private void commentElement(TreeElementDecl node) {
        String tag;
        this.currentElement = tag = node.getName();
        this.headline1(tag, tag);
        this.s.append(this.comment == null ? "" : "<div>" + this.comment + "</div>");
        this.commentAttributes(node);
        this.headline2(NbBundle.getMessage((Class)DTDDoclet.class, (String)"TEXT_ContentModel"));
        TreeElementDecl.ContentType type = node.getContentType();
        this.s.append("<p><tt>");
        this.commentContentModel(type);
        this.s.append("</tt></p>");
        this.headline2(NbBundle.getMessage((Class)DTDDoclet.class, (String)"TEXT_Referenced_by"));
        this.s.append("<p><tt>");
        this.s.append(this.getRefList(tag));
        this.s.append("</tt></p>");
        this.s.append("\n");
    }

    private void commentAttributes(TreeElementDecl element) {
        Iterator it = element.getAttributeDefs().iterator();
        if (!it.hasNext()) {
            return;
        }
        this.headline2(NbBundle.getMessage((Class)DTDDoclet.class, (String)"TEXT_Declared_Attributes"));
        this.s.appendStartTag("ul");
        while (it.hasNext()) {
            TreeAttlistDeclAttributeDef next = (TreeAttlistDeclAttributeDef)it.next();
            String defVal = next.getDefaultValue();
            defVal = defVal == null || defVal.length() == 0 ? "" : " = " + defVal;
            String defType = next.getDefaultTypeName() == null ? "#DEFAULT" : next.getDefaultTypeName();
            String text = "";
            text = next.getType() == 8 ? defType + " ENUMERATION " + next.getEnumeratedTypeString() : defType + " " + next.getTypeName();
            text = text + " " + next.getName() + defVal;
            this.listitem(this.s, text);
        }
        this.s.appendEndTag("ul");
    }

    private void commentContentModel(TreeElementDecl.ContentType type) {
        if (type instanceof EMPTYType) {
            this.s.append("EMPTY");
            return;
        }
        if (type instanceof ANYType) {
            this.s.append("ANY");
            return;
        }
        if (type instanceof LeafType) {
            LeafType leaf = (LeafType)type;
            String tag = leaf.getName();
            this.s.append("<a href=\"#").append(tag).append("\">");
            this.s.append(tag).append("</a>").append(leaf.getMultiplicity());
            RefList refs = this.getRefList(tag);
            String prefixSeparator = ", ";
            if (refs.isEmpty()) {
                prefixSeparator = "";
            }
            refs.appendUniq(prefixSeparator + "<a href=\"#" + this.currentElement + "\">" + this.currentElement + "</a>");
            return;
        }
        this.s.append("(");
        if (type.allowText()) {
            this.s.append("#PCDATA");
        }
        String separator = "";
        if (type instanceof ChildrenType) {
            String sepChar = ((ChildrenType)type).getSeparator();
            String prefix = !sepChar.equals(",") ? "&nbsp;" : "";
            separator = prefix + sepChar + " ";
        }
        boolean prependSeparator = type.allowText();
        if (type instanceof TypeCollection) {
            TypeCollection col = (TypeCollection)type;
            Collection types = col.getTypes();
            Iterator it = types.iterator();
            while (it.hasNext()) {
                TreeElementDecl.ContentType next = (TreeElementDecl.ContentType)it.next();
                if (prependSeparator) {
                    this.s.append(separator);
                }
                prependSeparator = true;
                this.commentContentModel(next);
            }
        }
        this.s.append(")" + type.getMultiplicity());
    }

    private void headline1(String text, String id) {
        this.s.append("\n\n<hr />\n").appendStartTag("h2");
        if (id != null) {
            this.s.append("<a name=\"" + id + "\"></a>");
        }
        this.s.append(text).appendEndTag("h2").append("\n");
    }

    private void headline1(String text) {
        this.headline1(text, null);
    }

    private void headline2(String text) {
        this.s.append("\n").appendStartTag("p").appendStartTag("b").append(text).appendEndTag("b").appendEndTag("p").append("\n");
    }

    private void listitem(RefList s, String text) {
        s.appendStartTag("li").append("<tt>").append(text).append("</tt>").appendEndTag("li").append("\n");
    }

    private RefList getRefList(String element) {
        RefList toret = (RefList)this.elementRefs.get(element);
        if (toret == null) {
            toret = new RefList();
            this.elementRefs.put(element, toret);
        }
        return toret;
    }

    private class RefList
    extends LinkedList {
        private static final long serialVersionUID = 4291872863957329823L;

        private RefList() {
        }

        public boolean add(Object obj) {
            if (obj instanceof StringBuffer || obj instanceof RefList || obj instanceof String) {
                return super.add(obj);
            }
            throw new ClassCastException("String or RefList required.");
        }

        public RefList append(String s) {
            if (this.size() != 0 && this.getLast() instanceof StringBuffer) {
                StringBuffer last = (StringBuffer)this.getLast();
                last.append(s);
            } else {
                this.add(new StringBuffer(s));
            }
            return this;
        }

        public RefList append(RefList s) {
            this.add(s);
            return this;
        }

        public RefList appendUniq(String fragment) {
            if (!this.contains(fragment)) {
                this.add(fragment);
            }
            return this;
        }

        RefList appendStartTag(String tag) {
            return this.append("<" + tag + ">");
        }

        RefList appendEndTag(String tag) {
            return this.append("</" + tag + ">");
        }

        public String toString() {
            Iterator it = this.iterator();
            StringBuffer buf = new StringBuffer();
            while (it.hasNext()) {
                buf.append(it.next().toString());
            }
            return buf.toString();
        }
    }
}

