/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.extras.api.ViewportModelState;
import org.netbeans.modules.dlight.util.Range;
import org.openide.util.ChangeSupport;

public final class DefaultViewportModel
implements ViewportModel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private long lowerLimit;
    private long upperLimit;
    private long viewportStart;
    private long viewportEnd;
    private long minViewportSize;
    private boolean autoscroll;

    public DefaultViewportModel(Range<Long> limits, Range<Long> viewport) {
        this.lowerLimit = (Long)limits.getStart();
        this.upperLimit = (Long)limits.getEnd();
        this.viewportStart = (Long)viewport.getStart();
        this.viewportEnd = (Long)viewport.getEnd();
        this.minViewportSize = 0L;
        this.autoscroll = true;
    }

    public synchronized boolean getAutoscroll() {
        return this.autoscroll;
    }

    public synchronized void setAutoscroll(boolean autoscroll) {
        this.autoscroll = autoscroll;
    }

    public synchronized long getMinViewportSize() {
        return this.minViewportSize;
    }

    public synchronized void setMinViewportSize(long minViewportSize) {
        this.minViewportSize = minViewportSize;
    }

    @Override
    public synchronized Range<Long> getLimits() {
        return new Range((Number)this.lowerLimit, (Number)this.upperLimit);
    }

    @Override
    public synchronized void setLimits(Range<Long> limits) {
        long newLowerLimit = limits.getStart() != null ? Math.min((Long)limits.getStart(), this.lowerLimit) : this.lowerLimit;
        long newUpperLimit = limits.getEnd() != null ? Math.max((Long)limits.getEnd(), this.upperLimit) : this.upperLimit;
        if (newLowerLimit < this.lowerLimit || this.upperLimit < newUpperLimit) {
            if (newUpperLimit - newLowerLimit < 0L) {
                return;
            }
            boolean scroll = this.autoscroll && this.viewportStart <= this.upperLimit && this.upperLimit <= this.viewportEnd;
            long extent = this.viewportEnd - this.viewportStart;
            this.lowerLimit = newLowerLimit;
            this.upperLimit = newUpperLimit;
            if (scroll) {
                this.viewportStart = Math.max(0L, this.upperLimit - extent);
                this.viewportEnd = this.viewportStart + extent;
            }
            this.changeSupport.fireChange();
        }
    }

    @Override
    public synchronized Range<Long> getViewport() {
        return new Range((Number)this.viewportStart, (Number)this.viewportEnd);
    }

    @Override
    public synchronized void setViewport(Range<Long> viewport) {
        long newViewportStart = viewport.getStart() != null ? (Long)viewport.getStart() : this.viewportStart;
        long newViewportEnd = viewport.getEnd() != null ? (Long)viewport.getEnd() : this.viewportEnd;
        if (newViewportStart != this.viewportStart || newViewportEnd != this.viewportEnd) {
            if (newViewportEnd - newViewportStart < this.minViewportSize) {
                return;
            }
            this.viewportStart = newViewportStart;
            this.viewportEnd = newViewportEnd;
            this.changeSupport.fireChange();
        }
    }

    @Override
    public synchronized ViewportModelState getState() {
        return new StateImpl(this.getLimits(), this.getViewport());
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private static class StateImpl
    implements ViewportModelState {
        private final Range<Long> limits;
        private final Range<Long> viewport;

        public StateImpl(Range<Long> limits, Range<Long> viewport) {
            this.limits = limits;
            this.viewport = viewport;
        }

        @Override
        public Range<Long> getLimits() {
            return this.limits;
        }

        @Override
        public Range<Long> getViewport() {
            return this.viewport;
        }
    }
}

