/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore;

import java.awt.Container;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.mobility.svgcore.SVGDataLoader;
import org.netbeans.modules.mobility.svgcore.SVGDataNode;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewMultiViewElement;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.xml.sax.InputSource;

public final class SVGDataObject
extends XmlMultiViewDataObject {
    private static final long serialVersionUID = 123471457562776148L;
    private static final Image SVGFILE_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/svgcore/resources/svg.png");
    public static final int XML_VIEW_INDEX = 0;
    public static final int SVG_VIEW_INDEX = 1;
    public static final String PROP_EXT_CHANGE = "external_change";
    public static final String EXT_SVG = "svg";
    public static final String EXT_SVGZ = "svgz";
    private transient SVGFileModel m_model;
    private transient SceneManager m_sceneManager;
    private transient MultiViewElement m_activeElement = null;
    private final XmlMultiViewDataObject.DataCache m_dataCache = new XmlMultiViewDataObject.DataCache(){

        public void loadData(FileObject file, FileLock dataLock) throws IOException {
            if (SVGDataObject.isSVGZ(file.getExt())) {
                file = new FileObjectGZIPDelegator(file);
            }
            super.loadData(file, dataLock);
        }
    };

    public SVGDataObject(FileObject pf, SVGDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, (MultiFileLoader)loader);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
        XmlMultiViewEditorSupport edSup = this.getEditorSupport();
        edSup.setSuppressXmlView(true);
        this.setLastOpenView(1);
        edSup.getMultiViewDescriptions();
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                SVGDataObject.this.getEditorSupport().saveAs(folder, fileName);
            }
        }});
        SceneManager.log(Level.INFO, "SVGDataObject created for " + pf.getPath());
    }

    public XmlMultiViewDataObject.DataCache getDataCache() {
        return this.m_dataCache;
    }

    public void fireContentChanged() {
        this.firePropertyChange(PROP_EXT_CHANGE, null, null);
    }

    public TopComponent getMTVC() {
        this.getCookieSet();
        return this.getEditorSupport().getMVTC();
    }

    public MultiViewElement getActiveElement() {
        return this.m_activeElement;
    }

    public void setMultiViewElement(MultiViewElement active) {
        this.m_activeElement = active;
    }

    public synchronized SVGFileModel getModel() {
        if (this.m_model == null) {
            this.m_model = new SVGFileModel(this.getEditorSupport());
            SceneManager.log(Level.INFO, "Model created for " + this.getPrimaryFile().getPath());
        }
        return this.m_model;
    }

    public synchronized SceneManager getSceneManager() {
        if (this.m_sceneManager == null) {
            this.m_sceneManager = new SceneManager();
            SceneManager.log(Level.INFO, "SceneManager created for " + this.getPrimaryFile().getPath());
            this.m_sceneManager.initialize(this);
        }
        return this.m_sceneManager;
    }

    public static boolean isSVGZ(String fileExt) {
        return EXT_SVGZ.equals(fileExt.toLowerCase());
    }

    private synchronized void release() {
        if (this.m_model != null) {
            this.m_model.detachDocument();
        }
        this.m_model = null;
        this.m_sceneManager = null;
        SceneManager.log(Level.INFO, "SVGDataObject released for " + this.getPrimaryFile().getPath());
    }

    protected synchronized XmlMultiViewEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new SVGEditorSupport();
            this.editorSupport.getMultiViewDescriptions();
        }
        return this.editorSupport;
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        return new DesignMultiViewDesc[]{new XMLTextView(this), new VisualView(this)};
    }

    protected Node createNodeDelegate() {
        return new SVGDataNode(this);
    }

    protected String getPrefixMark() {
        return null;
    }

    public static boolean isSVGFile(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".svg") || name.endsWith(".svgz");
    }

    public static SVGDataObject getActiveDataObject(Container comp) {
        while (comp != null) {
            SVGDataObject dObj;
            if (comp instanceof CloneableTopComponent && (dObj = (SVGDataObject)((Object)((CloneableTopComponent)comp).getLookup().lookup(SVGDataObject.class))) != null) {
                return dObj;
            }
            comp = comp.getParent();
        }
        return null;
    }

    private static final class FileObjectGZIPDelegator
    extends FileObject {
        private final FileObject m_delegate;

        public FileObjectGZIPDelegator(FileObject delegate) {
            this.m_delegate = delegate;
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getExt() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject getParent() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isFolder() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Date lastModified() {
            return this.m_delegate.lastModified();
        }

        public boolean isRoot() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isData() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isValid() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void delete(FileLock lock) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getAttribute(String attrName) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Enumeration<String> getAttributes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addFileChangeListener(FileChangeListener fcl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InputStream getInputStream() throws FileNotFoundException {
            try {
                InputStream in = this.m_delegate.getInputStream();
                return new GZIPInputStream(in);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileLock lock() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setImportant(boolean b) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject[] getChildren() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject getFileObject(String name, String ext) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject createFolder(String name) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject createData(String name, String ext) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isReadOnly() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class XMLTextView
    extends DesignMultiViewDesc {
        private static final long serialVersionUID = 7526471457562776147L;

        XMLTextView(SVGDataObject dObj) {
            super((XmlMultiViewDataObject)dObj, NbBundle.getMessage(SVGDataObject.class, (String)"LBL_MULVIEW_TITLE_SOURCE"));
        }

        public MultiViewElement createElement() {
            return new SVGSourceMultiViewElement((SVGDataObject)this.getDataObject());
        }

        public Image getIcon() {
            return ((SVGDataObject)this.getDataObject()).getXmlViewIcon();
        }

        public String preferredID() {
            return "multiview_xml";
        }

        public int getPersistenceType() {
            return 1;
        }
    }

    private static final class VisualView
    extends DesignMultiViewDesc {
        private static final long serialVersionUID = 7526471457562776148L;
        private static final HelpCtx DEFAULT_HELP = new HelpCtx(HelpCtx.class.getName() + ".DEFAULT_HELP");

        VisualView(SVGDataObject dObj) {
            super((XmlMultiViewDataObject)dObj, NbBundle.getMessage(SVGDataObject.class, (String)"LBL_MULVIEW_TITLE_VIEW"));
        }

        public MultiViewElement createElement() {
            SVGDataObject dObj = (SVGDataObject)this.getDataObject();
            return new SVGViewMultiViewElement(dObj);
        }

        public Image getIcon() {
            return SVGFILE_ICON;
        }

        public String preferredID() {
            return "multiview_svgview";
        }

        public HelpCtx getHelpCtx() {
            return DEFAULT_HELP;
        }

        public int getPersistenceType() {
            return 1;
        }
    }

    private final class SVGEditorSupport
    extends XmlMultiViewEditorSupport {
        private static final long serialVersionUID = 123471457562776148L;
        private Logger LOG;
        private String m_errorMessage;

        public SVGEditorSupport() {
            super((XmlMultiViewDataObject)SVGDataObject.this);
            this.LOG = Logger.getLogger(SVGEditorSupport.class.getName());
            this.m_errorMessage = null;
        }

        protected void notifyClosed() {
            super.notifyClosed();
            SVGDataObject.this.release();
        }

        public void open() {
            if (SVGDataObject.this.getModel().getModel() != null || this.getDocument().getLength() == 0) {
                super.open();
            } else {
                this.showErrorDialog(this.m_errorMessage);
            }
        }

        public void edit() {
            if (SVGDataObject.this.getModel().getModel() != null || this.getDocument().getLength() == 0) {
                super.edit();
            } else {
                this.showErrorDialog(this.m_errorMessage);
            }
        }

        public StyledDocument openDocument() throws IOException {
            this.m_errorMessage = null;
            try {
                return super.openDocument();
            }
            catch (IOException io) {
                this.m_errorMessage = "Could not open the document: " + io.getMessage();
                this.LOG.log(Level.WARNING, io.getMessage());
                throw io;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
            FileObject fo = SVGDataObject.this.getPrimaryFile();
            if (SVGDataObject.isSVGZ(fo.getExt())) {
                GZIPOutputStream gzipStream = new GZIPOutputStream(stream);
                try {
                    kit.write(new OutputStreamWriter((OutputStream)gzipStream, SVGDataObject.this.getEncodingHelper().getEncoding()), (Document)doc, 0, doc.getLength());
                }
                finally {
                    gzipStream.close();
                }
            } else {
                kit.write(new OutputStreamWriter(stream, SVGDataObject.this.getEncodingHelper().getEncoding()), (Document)doc, 0, doc.getLength());
            }
        }

        private void showErrorDialog(String message) {
            if (message != null) {
                NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)message, 2);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
            }
        }
    }
}

