/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.PackageIdentifier;

public class StaticMethodRefInfo
extends Info {
    protected int staticMethodToken;

    StaticMethodRefInfo(PackageIdentifier packageIdentifier, String string) {
        super(6, packageIdentifier, string, string.substring(string.lastIndexOf(40)));
    }

    StaticMethodRefInfo(PackageIdentifier packageIdentifier, int n, int n2, String string) {
        super(6, packageIdentifier, n, string);
        this.staticMethodToken = n2;
    }

    public int getStaticMethodToken() {
        return this.staticMethodToken;
    }

    @Override
    public byte[] toByteArray(JCPackage jCPackage) {
        byte[] byArray = super.toByteArray(jCPackage);
        if (this.isPackageInternal()) {
            int n = this.resolvedTo.getRelocAddr();
            byArray[1] = 0;
            byArray[2] = (byte)(n >> 8 & 0xFF);
            byArray[3] = (byte)(n & 0xFF);
        } else {
            byArray[1] = (byte)jCPackage.getPackageToken(this.packageIdentifier);
            byArray[1] = (byte)(byArray[1] | 0x80);
            byArray[2] = (byte)this.classToken;
            byArray[3] = (byte)this.staticMethodToken;
        }
        return byArray;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("." + Integer.toHexString(this.staticMethodToken));
        return stringBuffer.toString();
    }
}

