/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.netbeans.modules.subversion.util.SvnUtils;

public class SvnWcUtils {
    static final String ENTRIES = "entries";
    private static final String PROPS = "props";
    private static final String PROPS_BASE = "prop-base";

    public static File getSvnFile(File file, String svnFileName) {
        File svnFile = new File(file, SvnUtils.SVN_ADMIN_DIR + "/" + svnFileName);
        if (svnFile.canRead()) {
            return svnFile;
        }
        return null;
    }

    public static File getPropertiesFile(File file, boolean base) {
        if (file.isFile()) {
            if (base) {
                return SvnWcUtils.getSvnFile(file.getParentFile(), "prop-base/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(base));
            }
            return SvnWcUtils.getSvnFile(file.getParentFile(), "props/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(base));
        }
        return SvnWcUtils.getSvnFile(file, base ? "/dir-prop-base" : "/dir-props");
    }

    private static String getPropFileNameSuffix(boolean base) {
        if (base) {
            return ".svn-base";
        }
        return ".svn-work";
    }

    public static File getTextBaseFile(File file) throws IOException {
        return SvnWcUtils.getSvnFile(file.getParentFile(), "text-base/" + file.getName() + ".svn-base");
    }

    public static Date parseSvnDate(String inputValue) throws ParseException {
        Date returnValue = null;
        if (inputValue != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            int idx = inputValue.lastIndexOf(".");
            if (idx > 0) {
                idx = idx + 4 > inputValue.length() ? inputValue.length() : idx + 4;
                inputValue = inputValue.substring(0, idx) + "Z";
            }
            returnValue = dateFormat.parse(inputValue);
        }
        return returnValue;
    }

    static File getEntriesFile(File file) throws IOException {
        return SvnWcUtils.getSvnFile(!file.isDirectory() ? file.getParentFile() : file, ENTRIES);
    }
}

