/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.ui.update.UpdateResultNode;
import org.netbeans.modules.subversion.ui.update.UpdateResultsTable;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class UpdateResults
extends JComponent {
    private final List<FileUpdateInfo> results;

    public UpdateResults(List<FileUpdateInfo> results, SVNUrl url, String contextDisplayName) {
        this.results = results;
        String time = DateFormat.getTimeInstance().format(new Date());
        this.setName(NbBundle.getMessage(UpdateResults.class, (String)"CTL_UpdateResults_Title", (Object)url.toString(), (Object)contextDisplayName, (Object)time));
        this.setLayout(new BorderLayout());
        if (results.size() == 0) {
            this.add((Component)new NoContentPanel(NbBundle.getMessage(UpdateResults.class, (String)"MSG_NoFilesUpdated")));
        } else {
            final UpdateResultsTable urt = new UpdateResultsTable();
            Subversion.getInstance().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    final UpdateResultNode[] nodes = UpdateResults.this.createNodes();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            urt.setTableModel(nodes);
                            UpdateResults.this.add(urt.getComponent());
                        }
                    });
                }
            });
        }
    }

    private UpdateResultNode[] createNodes() {
        UpdateResultNode[] nodes = new UpdateResultNode[this.results.size()];
        int idx = 0;
        for (FileUpdateInfo info : this.results) {
            nodes[idx++] = new UpdateResultNode(info);
        }
        return nodes;
    }
}

