/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.ChildrenUpdater;
import org.netbeans.modules.cnd.classview.ClassViewUpdater;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.HostKeyArray;
import org.netbeans.modules.cnd.classview.ProjectsKeyArray;
import org.netbeans.modules.cnd.classview.RootNode;
import org.netbeans.modules.cnd.classview.SmartChangeEvent;
import org.netbeans.modules.cnd.classview.model.ProjectNode;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.nodes.Node;

class ClassViewModel {
    private static final boolean showLibs = CndUtils.getBoolean((String)"cnd.classview.sys-includes", (boolean)true);
    private ClassViewUpdater updater = new ClassViewUpdater(this);
    private ChildrenUpdater childrenUpdater = new ChildrenUpdater();
    private volatile boolean userActivity = false;
    private RootNode root;

    public ClassViewModel() {
        this.updater.start();
    }

    public RootNode getRoot() {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        return this.root;
    }

    private RootNode createRoot() {
        return new RootNode(this.childrenUpdater);
    }

    public static boolean isShowLibs() {
        return showLibs;
    }

    void openProject(CsmProject project) {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        if (!ClassViewModel.isShowLibs() && project.isArtificial()) {
            return;
        }
        ProjectsKeyArray children = (ProjectsKeyArray)this.root.getChildren();
        children.openProject(project);
    }

    void closeProject(CsmProject project) {
        if (this.root == null) {
            return;
        }
        this.childrenUpdater.unregister(project);
        ProjectsKeyArray children = (ProjectsKeyArray)this.root.getChildren();
        children.closeProject(project);
    }

    void scheduleUpdate(CsmChangeEvent e) {
        this.updater.scheduleUpdate(e);
    }

    void setUserActivity(boolean active) {
        this.userActivity = active;
    }

    boolean isUserActivity() {
        return this.userActivity;
    }

    void dispose() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesM: Dispose model");
        }
        this.updater.setStop();
        this.childrenUpdater.unregister();
        if (this.root != null) {
            this.root.destroy();
            this.root = null;
        }
        this.updater = null;
        this.childrenUpdater = null;
    }

    void update(SmartChangeEvent e) {
        if (this.childrenUpdater != null) {
            this.childrenUpdater.update(e);
        }
    }

    Node findDeclaration(CsmOffsetableDeclaration decl) {
        CsmNamespace ns;
        if (this.root == null) {
            return null;
        }
        ProjectsKeyArray children = (ProjectsKeyArray)this.root.getChildren();
        CsmFile file = decl.getContainingFile();
        CsmProject project = file.getProject();
        children.ensureAddNotify();
        ProjectNode projectNode = (ProjectNode)children.findChild(((Object)project.getName()).toString());
        if (projectNode == null) {
            return null;
        }
        ArrayList<Object> path = new ArrayList<Object>();
        CsmScope scope = null;
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)decl)) {
            CsmFunction func = ((CsmFunctionDefinition)decl).getDeclaration();
            if (func != null) {
                decl = func;
            }
            path.add(decl);
            scope = decl.getScope();
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)decl)) {
            ns = ((CsmNamespaceDefinition)decl).getNamespace();
            path.add(ns);
            scope = ns.getParent();
        } else {
            path.add(decl);
            scope = decl.getScope();
        }
        while (scope != null) {
            if (CsmKindUtilities.isFile((CsmObject)scope)) {
                path.add(project.getGlobalNamespace());
                break;
            }
            path.add(scope);
            if (CsmKindUtilities.isNamespace((Object)scope)) {
                ns = (CsmNamespace)scope;
                if (ns.isGlobal()) break;
                scope = ns.getParent();
                continue;
            }
            if (!CsmKindUtilities.isClass((CsmObject)scope)) break;
            CsmClass cls = (CsmClass)scope;
            scope = cls.getScope();
        }
        Node res = null;
        HostKeyArray child = (HostKeyArray)projectNode.getChildren();
        for (int i = path.size() - 2; i >= 0; --i) {
            child.ensureInited();
            scope = (CsmObject)path.get(i);
            res = child.findChild((CsmObject)scope);
            if (res == null || !(res.getChildren() instanceof HostKeyArray)) continue;
            child = (HostKeyArray)res.getChildren();
        }
        return res;
    }

    private void dump(Project[] projects) {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("Dumping projects:");
            for (int i = 0; i < projects.length; ++i) {
                this.dump(projects[i]);
            }
        }
    }

    private void dump(Project p) {
        if (Diagnostic.DEBUG) {
            ProjectInformation pi = ProjectUtils.getInformation((Project)p);
            Diagnostic.trace("Project " + pi.getName() + " (" + pi.getDisplayName() + ')');
            SourceGroup[] sg = ProjectUtils.getSources((Project)p).getSourceGroups("generic");
            Diagnostic.trace("  Source groups are");
            for (int i = 0; i < sg.length; ++i) {
                Diagnostic.trace("    " + sg[i].getName() + " (" + sg[i].getDisplayName() + ") " + sg[i].getRootFolder().getName());
            }
        }
    }
}

