/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.properties;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.properties.DesignEventFilterResolver;
import org.netbeans.modules.vmd.api.properties.DesignPropertyDescriptor;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.api.properties.PropertiesPresenter;

public class DefaultPropertiesPresenter
extends PropertiesPresenter {
    private static final String NULL_DEFAULT = "Null DefaultPropertyEditorSupport";
    private List<DesignPropertyDescriptor> descriptors = new ArrayList<DesignPropertyDescriptor>();
    private List<String> categories = new ArrayList<String>();
    private String category;
    private DesignEventFilterResolver designEventFilterResolver;

    public DefaultPropertiesPresenter() {
    }

    public DefaultPropertiesPresenter(DesignEventFilterResolver designEventFilterResolver) {
        this();
        this.designEventFilterResolver = designEventFilterResolver;
    }

    public DefaultPropertiesPresenter addProperty(String displayName, String toolTip, DesignPropertyEditor propertyEditor, String ... propertyNames) {
        if (propertyNames.length < 1) {
            throw new IllegalArgumentException();
        }
        if (propertyEditor == null) {
            throw new IllegalArgumentException(NULL_DEFAULT);
        }
        this.descriptors.add(DesignPropertyDescriptor.create(displayName, toolTip, this.category, propertyEditor, propertyEditor.getClass(), propertyNames));
        return this;
    }

    public DefaultPropertiesPresenter addProperty(String displayName, DesignPropertyEditor propertyEditor, String ... propertyNames) {
        if (propertyNames.length < 1) {
            throw new IllegalArgumentException();
        }
        if (propertyEditor == null) {
            throw new IllegalArgumentException(NULL_DEFAULT);
        }
        this.descriptors.add(DesignPropertyDescriptor.create(displayName, displayName, this.category, propertyEditor, propertyEditor.getClass(), propertyNames));
        return this;
    }

    public DefaultPropertiesPresenter addPropertiesCategory(String propertyCategory) {
        assert (propertyCategory != null) : " Group category cant be null";
        this.category = propertyCategory;
        if (!this.categories.contains(propertyCategory)) {
            this.categories.add(propertyCategory);
        }
        return this;
    }

    @Override
    public List<DesignPropertyDescriptor> getDesignPropertyDescriptors() {
        return this.descriptors;
    }

    @Override
    public List<String> getPropertiesCategories() {
        return this.categories;
    }

    protected void notifyAttached(DesignComponent component) {
        for (DesignPropertyDescriptor designerPropertyDescriptor : this.getDesignPropertyDescriptors()) {
            if (designerPropertyDescriptor.getPropertyEditor() != null) {
                designerPropertyDescriptor.getPropertyEditor().init(component);
            }
            designerPropertyDescriptor.init(component);
        }
    }

    protected void notifyDetached(final DesignComponent component) {
        for (final DesignPropertyDescriptor descriptor : this.descriptors) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    descriptor.getPropertyEditor().cleanUp(component);
                }
            });
        }
        this.descriptors = null;
        this.categories = null;
        this.category = null;
        this.designEventFilterResolver = null;
    }

    protected DesignEventFilter getEventFilter() {
        if (this.designEventFilterResolver != null) {
            return this.designEventFilterResolver.getEventFilter(this.getComponent());
        }
        return null;
    }

    protected void designChanged(DesignEvent event) {
        for (DesignPropertyDescriptor designerPropertyDescriptor : this.getDesignPropertyDescriptors()) {
            DesignPropertyEditor propertyEditor = designerPropertyDescriptor.getPropertyEditor();
            if (designerPropertyDescriptor.getPropertyEditor() == null) continue;
            propertyEditor.notifyDesignChanged(event);
        }
    }

    protected void presenterChanged(PresenterEvent event) {
    }
}

