/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts.editor;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.struts.StrutsConfigDataObject;
import org.netbeans.modules.web.struts.StrutsConfigUtilities;
import org.netbeans.modules.web.struts.editor.StrutsEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class StrutsConfigHyperlinkProvider
implements HyperlinkProvider {
    private static boolean debug = false;
    private static Hashtable hyperlinkTable;
    private final int JAVA_CLASS = 0;
    private final int FORM_NAME = 1;
    private final int RESOURCE_PATH = 2;
    private int valueOffset;
    private String[] eav;

    public StrutsConfigHyperlinkProvider() {
        hyperlinkTable = new Hashtable();
        hyperlinkTable.put("data-source#className", new Integer(0));
        hyperlinkTable.put("data-source#type", new Integer(0));
        hyperlinkTable.put("form-beans#type", new Integer(0));
        hyperlinkTable.put("form-bean#className", new Integer(0));
        hyperlinkTable.put("form-bean#type", new Integer(0));
        hyperlinkTable.put("form-property#className", new Integer(0));
        hyperlinkTable.put("form-property#type", new Integer(0));
        hyperlinkTable.put("exception#className", new Integer(0));
        hyperlinkTable.put("exception#type", new Integer(0));
        hyperlinkTable.put("exception#handler", new Integer(0));
        hyperlinkTable.put("exception#path", new Integer(2));
        hyperlinkTable.put("global-forwards#type", new Integer(0));
        hyperlinkTable.put("forward#className", new Integer(0));
        hyperlinkTable.put("forward#type", new Integer(0));
        hyperlinkTable.put("forward#path", new Integer(2));
        hyperlinkTable.put("action-mappings#type", new Integer(0));
        hyperlinkTable.put("action#name", new Integer(1));
        hyperlinkTable.put("action#className", new Integer(0));
        hyperlinkTable.put("action#type", new Integer(0));
        hyperlinkTable.put("action#forward", new Integer(2));
        hyperlinkTable.put("action#include", new Integer(2));
        hyperlinkTable.put("action#input", new Integer(2));
        hyperlinkTable.put("action#path", new Integer(2));
        hyperlinkTable.put("controller#className", new Integer(0));
        hyperlinkTable.put("controller#processorClass", new Integer(0));
        hyperlinkTable.put("controller#multipartClass", new Integer(0));
        hyperlinkTable.put("message-resources#className", new Integer(0));
        hyperlinkTable.put("message-resources#factory", new Integer(0));
        hyperlinkTable.put("plug-in#className", new Integer(0));
        this.eav = null;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (debug) {
            StrutsConfigHyperlinkProvider.debug(":: getHyperlinkSpan");
        }
        if (this.eav != null) {
            return new int[]{this.valueOffset, this.valueOffset + this.eav[2].length() - 1};
        }
        return null;
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        DataObject dataObject;
        if (debug) {
            StrutsConfigHyperlinkProvider.debug(":: isHyperlinkSpan - offset: " + n);
        }
        if (!((dataObject = NbEditorUtilities.getDataObject((Document)document)) instanceof StrutsConfigDataObject)) {
            return false;
        }
        this.eav = this.getElementAttrValue(document, n);
        return this.eav != null && hyperlinkTable.get(this.eav[0] + "#" + this.eav[1]) != null;
    }

    public void performClickAction(Document document, int n) {
        if (debug) {
            StrutsConfigHyperlinkProvider.debug(":: performClickAction");
        }
        if (hyperlinkTable.get(this.eav[0] + "#" + this.eav[1]) != null) {
            int n2 = (Integer)hyperlinkTable.get(this.eav[0] + "#" + this.eav[1]);
            switch (n2) {
                case 0: {
                    this.findJavaClass(this.eav[2], document);
                    break;
                }
                case 1: {
                    this.findForm(this.eav[2], (BaseDocument)document);
                    break;
                }
                case 2: {
                    this.findResourcePath(this.eav[2], (BaseDocument)document);
                }
            }
        }
    }

    static void debug(String string) {
        System.out.println("StrutsHyperlinkProvider: " + string);
    }

    private String[] getElementAttrValue(Document document, int n) {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            BaseDocument baseDocument = (BaseDocument)document;
            JTextComponent jTextComponent = Utilities.getFocusedComponent();
            if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
                return null;
            }
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
            if (tokenItem == null || tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ATTRIBUTE_VALUE) {
                return null;
            }
            string3 = tokenItem.getImage();
            if (string3 != null) {
                string3 = string3.trim();
                this.valueOffset = tokenItem.getOffset();
                if (string3.charAt(0) == '\"') {
                    string3 = string3.substring(1);
                    ++this.valueOffset;
                }
                if (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\"') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string3 = string3.trim();
            }
            while (tokenItem != null && tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ATTRIBUTE && tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT) {
                tokenItem = tokenItem.getPrevious();
            }
            if (tokenItem != null && tokenItem.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ATTRIBUTE) {
                string = tokenItem.getImage();
                while (tokenItem != null && tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT) {
                    tokenItem = tokenItem.getPrevious();
                }
                if (tokenItem != null && tokenItem.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ELEMENT) {
                    string2 = tokenItem.getImage();
                }
            }
            if (string == null || string2 == null) {
                return null;
            }
            string2 = string2.substring(1);
            if (debug) {
                StrutsConfigHyperlinkProvider.debug("element: " + string2);
            }
            if (debug) {
                StrutsConfigHyperlinkProvider.debug("attribute: " + string);
            }
            if (debug) {
                StrutsConfigHyperlinkProvider.debug("value: " + string3);
            }
            return new String[]{string2, string, string3};
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private void findJavaClass(final String string, Document document) {
        WebModule webModule;
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null && (webModule = WebModule.getWebModule((FileObject)fileObject)) != null) {
            try {
                final ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)webModule.getDocumentBase());
                JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (Collection)Collections.EMPTY_LIST);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        Elements elements = compilationController.getElements();
                        TypeElement typeElement = elements.getTypeElement(string.trim());
                        if (typeElement != null && !UiUtils.open((ClasspathInfo)classpathInfo, (Element)typeElement)) {
                            String string3 = "goto_source_not_found";
                            String string2 = NbBundle.getBundle(StrutsConfigHyperlinkProvider.class).getString(string3);
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(string2, string));
                        }
                    }
                }, false);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    private void findForm(String string, BaseDocument baseDocument) {
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        int n = this.findDefinitionInSection(extSyntaxSupport, "form-beans", "form-bean", "name", string);
        if (n > 0) {
            JTextComponent jTextComponent = Utilities.getFocusedComponent();
            jTextComponent.setCaretPosition(n);
        } else {
            String string2 = "goto_formbean_not_found";
            String string3 = NbBundle.getBundle(StrutsConfigHyperlinkProvider.class).getString(string2);
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(string3, string));
        }
    }

    private void findResourcePath(String string, BaseDocument baseDocument) {
        WebModule webModule;
        string = string.trim();
        if (debug) {
            StrutsConfigHyperlinkProvider.debug("path: " + string);
        }
        if (string.indexOf(63) > 0) {
            string = string.substring(0, string.indexOf(63));
        }
        if ((webModule = WebModule.getWebModule((FileObject)NbEditorUtilities.getFileObject((Document)baseDocument))) != null) {
            FileObject fileObject = webModule.getDocumentBase();
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) {
                String string2 = StrutsConfigUtilities.getActionServletMapping(webModule.getDeploymentDescriptor());
                if (string2 != null) {
                    int n;
                    String string3;
                    String string4 = null;
                    string4 = string2 != null && string2.lastIndexOf(46) > 0 ? (string.endsWith(string3 = string2.substring(string2.lastIndexOf(46))) ? string.substring(0, string.length() - string3.length()) : string) : (string.startsWith(string3 = (string2 = string2.trim()).substring(0, string2.length() - 2)) ? string.substring(string3.length(), string.length()) : string);
                    if (debug) {
                        StrutsConfigHyperlinkProvider.debug(" actionPath: " + string4);
                    }
                    if (string4 != null && (n = this.findDefinitionInSection((ExtSyntaxSupport)(string3 = (ExtSyntaxSupport)baseDocument.getSyntaxSupport()), "action-mappings", "action", "path", string4)) > 0) {
                        JTextComponent jTextComponent = Utilities.getFocusedComponent();
                        jTextComponent.setCaretPosition(n);
                    }
                }
            } else {
                this.openInEditor(fileObject2);
            }
        }
    }

    private int findDefinitionInSection(ExtSyntaxSupport extSyntaxSupport, String string, String string2, String string3, String string4) {
        String string5 = "<" + string;
        String string6 = "</" + string;
        String string7 = "<" + string2;
        String string8 = "\"" + string4 + "\"";
        int n = 0;
        try {
            TokenItem tokenItem;
            for (tokenItem = extSyntaxSupport.getTokenChain(0, 1); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ELEMENT && tokenItem.getImage().equals(string5)); tokenItem = tokenItem.getNext()) {
            }
            if (tokenItem.getImage().equals(string5)) {
                for (tokenItem = tokenItem.getNext(); tokenItem != null && (tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT || tokenItem.getImage().equals(">")); tokenItem = tokenItem.getNext()) {
                }
                if (tokenItem.getImage().equals("/>") || tokenItem.getImage().equals(string6)) {
                    return -1;
                }
                while (!(tokenItem == null || tokenItem.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ELEMENT && tokenItem.getImage().equals(string6))) {
                    while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT || !tokenItem.getImage().equals(string6) && !tokenItem.getImage().equals(string7))) {
                        tokenItem = tokenItem.getNext();
                    }
                    if (tokenItem == null) {
                        return -1;
                    }
                    n = tokenItem.getOffset();
                    if (tokenItem.getImage().equals(string7)) {
                        for (tokenItem = tokenItem.getNext(); !(tokenItem == null || tokenItem.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ELEMENT || tokenItem.getTokenID().getNumericID() == StrutsEditorUtilities.XML_ATTRIBUTE && tokenItem.getImage().equals(string3)); tokenItem = tokenItem.getNext()) {
                        }
                        if (tokenItem == null) {
                            return -1;
                        }
                        if (!tokenItem.getImage().equals(string3)) continue;
                        for (tokenItem = tokenItem.getNext(); tokenItem != null && tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ATTRIBUTE_VALUE && tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ELEMENT && tokenItem.getTokenID().getNumericID() != StrutsEditorUtilities.XML_ATTRIBUTE; tokenItem = tokenItem.getNext()) {
                        }
                        if (!tokenItem.getImage().equals(string8)) continue;
                        return n;
                    }
                    tokenItem = tokenItem.getNext();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace(System.out);
        }
        return -1;
    }

    private void openInEditor(FileObject fileObject) {
        if (fileObject != null) {
            Node.Cookie cookie;
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return;
            }
            if (dataObject != null && (cookie = dataObject.getCookie(OpenCookie.class)) != null) {
                ((OpenCookie)cookie).open();
            }
        }
    }
}

