/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.clientproject.AppClientActionProvider;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class AppClientProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final AppClientProject project;
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;

    public AppClientProjectOperations(AppClientProject appClientProject) {
        this.project = appClientProject;
    }

    private static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        AppClientProjectOperations.addFile(fileObject, "nbproject", arrayList);
        AppClientProjectOperations.addFile(fileObject, "build.xml", arrayList);
        AppClientProjectOperations.addFile(fileObject, "catalog.xml", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        File file;
        FileObject fileObject;
        FileObject fileObject2;
        FileObject fileObject3;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        FileObject fileObject4 = this.project.getCarModule().getMetaInf();
        if (fileObject4 != null) {
            arrayList.add(fileObject4);
        }
        SourceRoots sourceRoots = this.project.getSourceRoots();
        FileObject[] fileObjectArray = sourceRoots.getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            arrayList.add(fileObjectArray[i]);
        }
        PropertyEvaluator propertyEvaluator = this.project.evaluator();
        String string = propertyEvaluator.getProperty("source.root");
        if (string != null && (fileObject3 = this.project.getProjectDirectory()) != (fileObject2 = this.project.getAntProjectHelper().resolveFileObject(string)) && !arrayList.contains(fileObject2)) {
            arrayList.add(fileObject2);
        }
        fileObject3 = this.project.getTestSourceRoots();
        fileObject2 = fileObject3.getRoots();
        for (int i = 0; i < ((FileObject)fileObject2).length; ++i) {
            arrayList.add(fileObject2[i]);
        }
        File file2 = this.project.getCarModule().getResourceDirectory();
        if (file2 != null && (fileObject = FileUtil.toFileObject((File)file2)) != null) {
            arrayList.add(fileObject);
        }
        if ((fileObject = this.project.getAntProjectHelper()).getLibrariesLocation() != null && (file = fileObject.resolveFile(fileObject.getLibrariesLocation())) != null && file.exists()) {
            FileObject fileObject5 = FileUtil.toFileObject((File)file).getParent();
            if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject5)) {
                arrayList.add(fileObject5);
            }
        }
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
        AppClientActionProvider appClientActionProvider = (AppClientActionProvider)this.project.getLookup().lookup(AppClientActionProvider.class);
        assert (appClientActionProvider != null);
        Lookup lookup = Lookups.fixed((Object[])new Object[0]);
        Properties properties = new Properties();
        String[] stringArray = appClientActionProvider.getTargetNames("clean", lookup, properties);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (stringArray != null);
        assert (stringArray.length > 0);
        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
    }

    public void notifyCopied(Project project, File file, String string) {
        if (project == null) {
            return;
        }
        AppClientProjectOperations appClientProjectOperations = (AppClientProjectOperations)project.getLookup().lookup(AppClientProjectOperations.class);
        this.fixLibraryLocation(appClientProjectOperations);
        this.project.getReferenceHelper().fixReferences(file);
        this.fixOtherReferences(file);
        this.project.setName(string);
    }

    public void notifyMoving() throws IOException {
        if (!this.project.getUpdateHelper().requestUpdate()) {
            throw new IOException(NbBundle.getMessage(AppClientProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.rememberLibraryLocation();
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, final String string) {
        if (project == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        AppClientProjectOperations appClientProjectOperations = (AppClientProjectOperations)project.getLookup().lookup(AppClientProjectOperations.class);
        this.fixLibraryLocation(appClientProjectOperations);
        final String string2 = this.project.getName();
        this.project.setName(string);
        this.project.getReferenceHelper().fixReferences(file);
        this.fixOtherReferences(file);
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                AntProjectHelper antProjectHelper = AppClientProjectOperations.this.project.getAntProjectHelper();
                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                String string3 = editableProperties.get((Object)"jar.name");
                String string22 = string3.substring(0, string3.length() - 4);
                if (string3.endsWith(".jar") && string22.equals(string2)) {
                    editableProperties.put("jar.name", string + ".jar");
                }
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                FileObject fileObject = AppClientProjectOperations.this.project.getCarModule().getDeploymentDescriptor();
                if (fileObject != null) {
                    try {
                        AppClient appClient = DDProvider.getDefault().getDDRoot(fileObject);
                        appClient.setDisplayName(string);
                        appClient.write(fileObject);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("global").log(Level.WARNING, null, iOException);
                    }
                }
            }
        });
    }

    private void fixOtherReferences(final File file) {
        final File file2 = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                EditableProperties editableProperties = AppClientProjectOperations.this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
                String string = editableProperties.getProperty("meta.inf");
                if (string == null) {
                    return;
                }
                if (string.startsWith(file.getAbsolutePath())) {
                    String string2 = PropertyUtils.relativizeFile((File)file, (File)new File(string));
                    String string3 = new File(file2, string2).getAbsolutePath();
                    editableProperties.setProperty("meta.inf", string3);
                    AppClientProjectOperations.this.project.getAntProjectHelper().putProperties("nbproject/project.properties", editableProperties);
                }
            }
        });
    }

    private void fixLibraryLocation(AppClientProjectOperations appClientProjectOperations) throws IllegalArgumentException {
        String string = appClientProjectOperations.libraryPath;
        if (string != null) {
            if (!new File(string).isAbsolute()) {
                if (!appClientProjectOperations.libraryWithinProject) {
                    File file = appClientProjectOperations.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String string2 = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (string2 != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(string2);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (appClientProjectOperations.libraryWithinProject && appClientProjectOperations.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)appClientProjectOperations.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)file, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)this.libraryFile.toURI()) == this.project && this.libraryFile.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fileObject = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fileObject != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject);
                }
            }
        }
    }
}

