/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class PlatformComponentFactory {
    private static final String DETECTING_VALUE = NbBundle.getMessage(PlatformComponentFactory.class, (String)"PlatformComponentFactory.detetctingPlatforms");
    private static final Logger LOGGER = Logger.getLogger(PlatformComponentFactory.class.getName());
    public static final Color INVALID_PLAF_COLOR = UIManager.getColor("nb.errorForeground");

    private PlatformComponentFactory() {
    }

    public static JComboBox getRubyPlatformsComboxBox() {
        final JComboBox plafComboBox = new JComboBox();
        plafComboBox.setRenderer(new RubyPlatformListRenderer());
        if (RubyPreferences.isFirstPlatformTouch()) {
            plafComboBox.setModel(PlatformComponentFactory.createComboWaitModel());
            plafComboBox.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    RubyPlatformManager.performPlatformDetection();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            plafComboBox.setModel(new RubyPlatformListModel());
                            plafComboBox.setEnabled(true);
                        }
                    });
                }
            });
        } else {
            plafComboBox.setModel(new RubyPlatformListModel());
        }
        return plafComboBox;
    }

    public static RubyPlatform getPlatform(JComboBox platforms) {
        Object value = platforms.getModel().getSelectedItem();
        return value == DETECTING_VALUE ? null : (RubyPlatform)value;
    }

    public static boolean isLoadingPlatforms(JComboBox platforms) {
        Object value = platforms.getModel().getSelectedItem();
        return value == DETECTING_VALUE;
    }

    public static JList getRubyPlatformsList() {
        final JList plafList = new JList(PlatformComponentFactory.createComboWaitModel());
        plafList.setSelectionMode(0);
        plafList.setCellRenderer(new RubyPlatformListRenderer());
        if (RubyPreferences.isFirstPlatformTouch()) {
            plafList.setModel(PlatformComponentFactory.createListWaitModel());
            plafList.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    RubyPlatformManager.performPlatformDetection();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            plafList.setModel(new RubyPlatformListModel());
                            plafList.setEnabled(true);
                        }
                    });
                }
            });
        } else {
            plafList.setModel(new RubyPlatformListModel());
        }
        return plafList;
    }

    public static ComboBoxModel createComboWaitModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{DETECTING_VALUE});
    }

    public static ListModel createListWaitModel() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        listModel.addElement(DETECTING_VALUE);
        return listModel;
    }

    public static void addPlatformChangeListener(JComboBox platforms, PlatformChangeListener pcl) {
        platforms.addItemListener(pcl);
        platforms.addPropertyChangeListener(pcl);
    }

    public static void removePlatformChangeListener(JComboBox platforms, PlatformChangeListener pcl) {
        platforms.removeItemListener(pcl);
        platforms.removePropertyChangeListener(pcl);
    }

    private static class RubyPlatformListRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public RubyPlatformListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.setName("ComboBox.listRenderer");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof String) {
                label = (String)value;
            } else {
                RubyPlatform plaf = (RubyPlatform)value;
                if (plaf == null || !plaf.isValid()) {
                    label = plaf != null ? plaf.getLabel() : NbBundle.getMessage(PlatformComponentFactory.class, (String)"PlatformComponentFactory.invalid.platform");
                    this.setForeground(INVALID_PLAF_COLOR);
                } else {
                    label = plaf.getLabel();
                }
            }
            this.setText(label);
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    public static class RubyPlatformListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private RubyPlatform[] nbPlafs = RubyPlatformListModel.getSortedPlatforms();
        private Object selectedPlaf;

        private static RubyPlatform[] getSortedPlatforms() {
            SortedSet<? extends RubyPlatform> platforms = RubyPlatformManager.getSortedPlatforms();
            return platforms.toArray(new RubyPlatform[platforms.size()]);
        }

        public RubyPlatformListModel() {
            if (this.nbPlafs.length > 0) {
                this.selectedPlaf = this.nbPlafs[0];
            }
        }

        @Override
        public int getSize() {
            return this.nbPlafs.length;
        }

        @Override
        public Object getElementAt(int index) {
            return index < this.nbPlafs.length ? this.nbPlafs[index] : null;
        }

        @Override
        public void setSelectedItem(Object plaf) {
            assert (plaf == null || plaf instanceof RubyPlatform);
            if (this.selectedPlaf != plaf) {
                this.selectedPlaf = plaf;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedPlaf;
        }

        void removePlatform(RubyPlatform plaf) {
            try {
                RubyPlatformManager.removePlatform(plaf);
                this.nbPlafs = RubyPlatformListModel.getSortedPlatforms();
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        RubyPlatform addPlatform(File interpreter) {
            try {
                RubyPlatform platform = RubyPlatformManager.addPlatform(interpreter);
                if (platform != null) {
                    this.nbPlafs = RubyPlatformListModel.getSortedPlatforms();
                    this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
                }
                return platform;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                return null;
            }
        }
    }

    public static abstract class PlatformChangeListener
    implements ItemListener,
    PropertyChangeListener {
        public abstract void platformChanged();

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.platformChanged();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("model")) {
                this.platformChanged();
            }
        }
    }
}

