/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.Dependency;
import org.netbeans.modules.javacard.project.deps.DependencyKind;
import org.netbeans.modules.javacard.project.deps.DeploymentStrategy;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Updater
implements UpdateImplementation {
    private final JCProject project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration config;
    public static final String NAMESPACE_V1 = "http://www.netbeans.org/ns/javacard-project/1";
    public static final String NAMESPACE_V2 = "http://www.netbeans.org/ns/javacard-project/2";
    public static final String NAMESPACE_V3 = "http://www.netbeans.org/ns/javacard-project/3";
    private volatile int namespaceVersion;
    private static int CURRENT_VERSION = 3;

    public Updater(JCProject p, AntProjectHelper helper, AuxiliaryConfiguration config) {
        this.project = p;
        this.helper = helper;
        this.config = config;
    }

    public boolean isCurrent() {
        boolean result = this.namespaceVersion > 0 ? this.namespaceVersion >= CURRENT_VERSION : (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                if (Updater.this.config.getConfigurationFragment("data", Updater.NAMESPACE_V3, true) != null) {
                    Updater.this.namespaceVersion = 3;
                } else if (Updater.this.config.getConfigurationFragment("data", Updater.NAMESPACE_V2, true) != null) {
                    Updater.this.namespaceVersion = 2;
                } else if (Updater.this.config.getConfigurationFragment("data", Updater.NAMESPACE_V1, true) != null) {
                    Updater.this.namespaceVersion = 1;
                }
                return Updater.this.namespaceVersion < CURRENT_VERSION;
            }
        });
        return result;
    }

    public boolean canUpdate() {
        return !this.isCurrent();
    }

    public void save() throws IOException {
        this.saveUpdate(null);
    }

    public void saveUpdate(EditableProperties props) throws IOException {
        if (!this.isCurrent()) {
            FileObject oldBuildImpl = this.project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            if (oldBuildImpl != null) {
                oldBuildImpl.delete();
            }
            EditableProperties privateProps = this.helper.getProperties("nbproject/private/private.properties");
            File userBuildProperties = Updater.userBuildProperties();
            if (userBuildProperties != null) {
                String userBuildPropertiesPath = userBuildProperties.getPath();
                if (Utilities.isWindows()) {
                    userBuildPropertiesPath = userBuildPropertiesPath.replace('\\', '/');
                }
                privateProps.put("user.properties.file", userBuildPropertiesPath);
                privateProps.put("sign.passkey", "password");
                privateProps.put("sign.storepass", "password");
            }
            this.helper.putProperties("nbproject/private/private.properties", privateProps);
            this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
            this.config.removeConfigurationFragment("data", NAMESPACE_V1, true);
            this.config.removeConfigurationFragment("data", NAMESPACE_V2, true);
            EditableProperties updatedProperties = this.getUpdatedProjectProperties();
            this.helper.putProperties("nbproject/project.properties", updatedProperties);
            this.namespaceVersion = CURRENT_VERSION;
            if (this.project != null) {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
        }
    }

    private static File userBuildProperties() {
        String nbuser = System.getProperty("netbeans.user");
        if (nbuser != null) {
            return FileUtil.normalizeFile((File)new File(nbuser, "build.properties"));
        }
        return null;
    }

    public synchronized Element getUpdatedSharedConfigurationData() {
        Element result = null;
        if (this.namespaceVersion == 0 || this.namespaceVersion == 1) {
            result = this.updateToV2();
        }
        if (this.namespaceVersion == 2) {
            result = result == null ? this.config.getConfigurationFragment("data", NAMESPACE_V2, true) : result;
            result = this.updateToV3(result);
        }
        return result;
    }

    Element updateToV2() {
        Element oldRoot = this.config.getConfigurationFragment("data", NAMESPACE_V1, true);
        if (oldRoot != null) {
            Document doc = oldRoot.getOwnerDocument();
            Element newRoot = doc.createElementNS(NAMESPACE_V3, "data");
            Element minAntVersion = doc.createElement("minimum-ant-version");
            minAntVersion.setTextContent("1.6");
            Updater.copyDocument(doc, oldRoot, newRoot);
            Element sourceRoots = doc.createElementNS(NAMESPACE_V3, "source-roots");
            Element root = doc.createElementNS(NAMESPACE_V3, "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            newRoot.appendChild(sourceRoots);
            this.namespaceVersion = 2;
            return newRoot;
        }
        return null;
    }

    private ResolvedDependencies getResolvedDependencies() throws Exception {
        if (this.project != null) {
            return this.project.createResolvedDependencies();
        }
        return null;
    }

    Element updateToV3(Element element) {
        if (element == null) {
            element = this.config.getConfigurationFragment("data", NAMESPACE_V2, true);
        }
        Document doc = element.getOwnerDocument();
        Element newRoot = doc.createElementNS(NAMESPACE_V3, "data");
        Updater.copyDocument(doc, element, newRoot);
        Element dependencies = doc.createElementNS(NAMESPACE_V3, "dependencies");
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        String cp = props.getProperty("class.path");
        try {
            if (cp != null && !"".equals(cp.trim())) {
                ResolvedDependencies deps = this.project.createResolvedDependencies();
                String[] paths = cp.split(File.pathSeparator);
                for (int i = 0; i < paths.length; ++i) {
                    String path = paths[i];
                    File f = FileUtil.normalizeFile((File)new File(path));
                    if (f == null || !f.exists()) continue;
                    HashMap<ArtifactKind, String> m = new HashMap<ArtifactKind, String>();
                    m.put(ArtifactKind.ORIGIN, f.getAbsolutePath());
                    Dependency d = new Dependency("lib" + (i + 1), DependencyKind.RAW_JAR, DeploymentStrategy.ALREADY_ON_CARD);
                    deps.add(d, m);
                }
                if (!deps.all().isEmpty()) {
                    deps.save();
                }
                props.remove((Object)"class.path");
            }
            newRoot.appendChild(dependencies);
        }
        catch (Exception e) {
            throw new IllegalStateException("Project metadata corrupted", e);
        }
        element = newRoot;
        return element;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void copyDocument(Document doc, Element from, Element to) {
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        int i = 0;
        while (true) {
            block10: {
                void var7_7;
                if (i >= length) {
                    return;
                }
                Node node = nl.item(i);
                Object var7_8 = null;
                switch (node.getNodeType()) {
                    case 1: {
                        String name;
                        Element oldElement = (Element)node;
                        if (!("folders".equals(oldElement.getNodeName()) || "view".equals(oldElement.getNodeName()) || "property".equals(oldElement.getNodeName()) && "ant.script".equals(name = oldElement.getAttribute("name")))) {
                            Element element = doc.createElementNS(NAMESPACE_V3, oldElement.getTagName());
                            NamedNodeMap m = oldElement.getAttributes();
                            Element newElement = element;
                            for (int index = 0; index < m.getLength(); ++index) {
                                Node attr = m.item(index);
                                newElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
                            }
                            Updater.copyDocument(doc, oldElement, newElement);
                            break;
                        }
                        break block10;
                    }
                    case 3: {
                        Text oldText = (Text)node;
                        Text text = doc.createTextNode(oldText.getData());
                        break;
                    }
                    case 8: {
                        Comment oldComment = (Comment)node;
                        Comment comment = doc.createComment(oldComment.getData());
                    }
                }
                if (var7_7 != null) {
                    to.appendChild((Node)var7_7);
                }
            }
            ++i;
        }
    }

    private ProjectKind getProjectKind() {
        if (this.project != null) {
            return this.project.kind();
        }
        return ProjectKind.kindForProject((AntProjectHelper)this.helper);
    }

    public EditableProperties getUpdatedProjectProperties() {
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        ProjectKind kind = this.getProjectKind();
        EditableProperties result = new EditableProperties(true);
        Replacement[] changes = Updater.replacements();
        String displayName = this.project == null ? props.getProperty("display.name") : ((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            for (Replacement r : changes) {
                key = r.replaceKey(key);
                val = r.filterValue(val);
            }
            if (!"display.name".equals(key)) {
                val = val.replace(displayName, "${display.name}");
            }
            if (!"dist.jar".equals(key) && val.startsWith("${basedir}/")) {
                val = val.substring("${basedir}/".length());
            }
            if ("dist.jar.name".equals(key) || "dest.eeprom".equals(key) || "dest.sig".equals(key) || "dest.sig.name".equals(key)) continue;
            result.setProperty(key, val);
        }
        result.setProperty("dist.bundle.name", "${display.name}." + this.getProjectKind().getBundleFileExtension());
        result.setProperty("dist.bundle.sig.name", "${display.name}.signature");
        result.setProperty("dist.bundle.sig", "${dist.dir}/${dist.bundle.sig.name}");
        result.setProperty("dist.bundle", "${dist.dir}/${dist.bundle.name}");
        result.setProperty("meta.inf.dir", "META-INF");
        result.setProperty("includes", "**/*");
        result.setProperty("excludes", "**/*.java");
        if (kind.isApplet()) {
            result.setProperty("applet.inf.dir", "APPLET-INF");
            result.setProperty("scripts.dir", "scripts");
        }
        result.remove((Object)"runtime.descriptor");
        result.remove((Object)"jcap.descriptor");
        result.remove((Object)"appletdescriptor");
        result.remove((Object)"web.inf.dir");
        result.remove((Object)"main.script");
        result.remove((Object)"mainscript");
        result.remove((Object)"dest.eeprom.name");
        result.remove((Object)"application.free.form.name");
        if (kind != ProjectKind.WEB) {
            result.remove((Object)"launch.external.browser");
        }
        result.setProperty("active.device", "Default Device");
        result.setProperty("platform.active", "javacard_default");
        result.setProperty("src.dir", "src");
        result.setProperty("javac.source", "1.6");
        result.setProperty("javac.target", "1.6");
        result.setProperty("source.encoding", "UTF-8");
        result.setProperty("build.dir", "build");
        result.setProperty("buildfile", "build.xml");
        result.setProperty("javac.deprecation", "true");
        result.setProperty("javac.args", "");
        result.setProperty("compile.on.save", "false");
        result.setProperty("javac.debug", "false");
        result.setProperty("compile.on.save", "false");
        result.setProperty("javac.args", "");
        result.setProperty("javac.debug", "true");
        result.setProperty("sign.keystore", "${javacard.home}/samples/keystore/a.keystore");
        result.setProperty("sign.bundle", "true");
        return result;
    }

    private static Replacement[] replacements() {
        Replacement[] result = new Replacement[]{new Replacement("dest.jar", "dist.jar"), new Replacement("main.script", "mainscript"), new Replacement("dest.war", "dist.jar"), new Replacement("dest.eap", "dist.jar"), new Replacement("dest.dir", "dist.dir"), new Replacement("dest.war.name", "dist.jar.name"), new Replacement("dest.cap", "dist.jar"), new Replacement("dest.cap.name", "dist.jar.name"), new Replacement("dest.eap.name", "dist.jar.name")};
        return result;
    }

    private static final class Replacement {
        public final String oldKey;
        public final String newKey;

        public Replacement(String oldKey, String newKey) {
            this.oldKey = oldKey;
            this.newKey = newKey;
        }

        public String replaceKey(String val) {
            return this.oldKey.equals(val) ? this.newKey : val;
        }

        public String filterValue(String value) {
            String lookFor = "${" + this.oldKey + "}";
            return value.replace(lookFor, "${" + this.newKey + "}");
        }
    }
}

