/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.refactoring;

import com.sun.javacard.filemodels.DeploymentXmlModel;
import com.sun.source.tree.Tree;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.refactoring.AppletXMLRefactoringSupport;
import org.netbeans.modules.javacard.project.refactoring.JCRenameRefactoringPlugin;
import org.netbeans.modules.javacard.project.refactoring.JavaCardXMLRefactoringSupport;
import org.netbeans.modules.javacard.project.refactoring.WebXMLRefactoringSupport;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportantFilesRenameRefactoring
implements RefactoringPlugin {
    private final Transformer transformer;
    private final TransformerFactory tFactory = TransformerFactory.newInstance();
    private RefactoringPlugin refactoringPlugin;
    private final AbstractRefactoring renameRefactoring;
    private JCProject project;

    public ImportantFilesRenameRefactoring(AbstractRefactoring abstractRefactoring) {
        FileObject fileObject;
        TreePathHandle treePathHandle;
        try {
            this.transformer = this.tFactory.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("standalone", "no");
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IllegalStateException("Internal error: failed to create transformer", transformerConfigurationException);
        }
        this.renameRefactoring = abstractRefactoring;
        Lookup lookup = abstractRefactoring.getRefactoringSource();
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
        if (nonRecursiveFolder != null) {
            this.project = JCProject.getOwnerProjectOf(nonRecursiveFolder.getFolder());
            if (this.project != null) {
                this.refactoringPlugin = new RenamePackageRefactoring(nonRecursiveFolder.getFolder());
            }
        }
        if ((treePathHandle = (TreePathHandle)lookup.lookup(TreePathHandle.class)) != null && treePathHandle.getKind() == Tree.Kind.CLASS && (fileObject = treePathHandle.getFileObject()) != null) {
            this.project = JCProject.getOwnerProjectOf(fileObject);
            if (this.project != null) {
                this.refactoringPlugin = new RenameClassRefactoring(fileObject);
            }
        }
        if ((fileObject = (FileObject)lookup.lookup(FileObject.class)) != null && fileObject.isData() && "text/x-java".equals(fileObject.getMIMEType())) {
            this.project = JCProject.getOwnerProjectOf(fileObject);
            if (this.project != null) {
                this.refactoringPlugin = new RenameClassRefactoring(fileObject);
            }
        }
    }

    public Problem preCheck() {
        return this.refactoringPlugin != null ? this.refactoringPlugin.preCheck() : null;
    }

    public Problem checkParameters() {
        return this.refactoringPlugin != null ? this.refactoringPlugin.checkParameters() : null;
    }

    public Problem fastCheckParameters() {
        return this.refactoringPlugin != null ? this.refactoringPlugin.fastCheckParameters() : null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem = null;
        if (this.refactoringPlugin != null) {
            problem = this.refactoringPlugin.prepare(refactoringElementsBag);
        }
        return problem;
    }

    private String getResourceName(FileObject fileObject) {
        ClassPathProvider classPathProvider = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        ClassPath classPath = classPathProvider.findClassPath(fileObject, "classpath/source");
        if (classPath.contains(fileObject)) {
            return classPath.getResourceName(fileObject, '.', false);
        }
        return null;
    }

    private Problem prepareClassRenaming(RefactoringElementsBag refactoringElementsBag, String string, String string2) {
        Problem problem = this.prepareClassRenamingForJavaCardXML(refactoringElementsBag, string, string2);
        Problem problem2 = null;
        ProjectKind projectKind = this.project.kind();
        switch (projectKind) {
            case WEB: {
                problem2 = this.prepareClassRenamingForWebXML(refactoringElementsBag, string, string2);
                break;
            }
            case EXTENDED_APPLET: 
            case CLASSIC_APPLET: {
                problem2 = this.prepareClassRenamingForAppletXML(refactoringElementsBag, string, string2);
                break;
            }
            case CLASSIC_LIBRARY: 
            case EXTENSION_LIBRARY: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (problem != null && problem2 != null) {
            problem.setNext(problem2);
        }
        return problem == null ? problem2 : problem;
    }

    private Problem prepareClassRenamingForAppletXML(RefactoringElementsBag refactoringElementsBag, String string, String string2) {
        FileObject fileObject;
        FileObject fileObject2 = this.project.getProjectDirectory().getFileObject("APPLET-INF/applet.xml");
        if (fileObject2 == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        AppletXMLRefactoringSupport appletXMLRefactoringSupport = AppletXMLRefactoringSupport.fromFile(file);
        if (appletXMLRefactoringSupport != null) {
            fileObject = new ArrayList();
            for (NodeList nodeList : new NodeList[]{appletXMLRefactoringSupport.getAppletClassElements()}) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    String string3 = node.getTextContent();
                    if (!string3.startsWith(string)) continue;
                    fileObject.add(node);
                }
            }
            if (fileObject.size() > 0) {
                String iOException = NbBundle.getMessage(JCRenameRefactoringPlugin.class, (String)"Update_applet_xml", (Object)string);
                refactoringElementsBag.add(this.renameRefactoring, (RefactoringElementImplementation)new UpdateXmlRefactoringElement(fileObject2, string, string2, appletXMLRefactoringSupport.getDocument(), (List<Node>)fileObject, iOException));
            }
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("nbproject/deployment.xml")) != null) {
            try {
                DeploymentXmlModel deploymentXmlModel = new DeploymentXmlModel((InputStream)new BufferedInputStream(fileObject.getInputStream()));
                int n = 0;
                for (NodeList nodeList : deploymentXmlModel.getData()) {
                    String string4 = nodeList.getClazzHint();
                    if (!string.equals(string4)) continue;
                    nodeList.setClazzHint(string2);
                    n = 1;
                }
                if (n != 0) {
                    String string5 = NbBundle.getMessage(JCRenameRefactoringPlugin.class, (String)"UPDATE_DEPLOYMENT_XML", (Object)string);
                    refactoringElementsBag.add(this.renameRefactoring, (RefactoringElementImplementation)new UpdateDeploymentXmlRefactoringElement(deploymentXmlModel, string5, fileObject));
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private Problem prepareClassRenamingForWebXML(RefactoringElementsBag refactoringElementsBag, String string, String string2) {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("WEB-INF/web.xml");
        if (fileObject == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        WebXMLRefactoringSupport webXMLRefactoringSupport = WebXMLRefactoringSupport.fromFile(file);
        if (webXMLRefactoringSupport != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (NodeList nodeList : new NodeList[]{webXMLRefactoringSupport.getServletClassElements(), webXMLRefactoringSupport.getListenerClassElements(), webXMLRefactoringSupport.getFilterClassElements()}) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    String string3 = node.getTextContent();
                    if (!string3.startsWith(string)) continue;
                    arrayList.add(node);
                }
            }
            if (arrayList.size() > 0) {
                String string4 = NbBundle.getMessage(JCRenameRefactoringPlugin.class, (String)"Update_web_xml", (Object)string);
                refactoringElementsBag.add(this.renameRefactoring, (RefactoringElementImplementation)new UpdateXmlRefactoringElement(fileObject, string, string2, webXMLRefactoringSupport.getDocument(), arrayList, string4));
            }
        }
        return null;
    }

    private Problem prepareClassRenamingForJavaCardXML(RefactoringElementsBag refactoringElementsBag, String string, String string2) {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("META-INF/javacard.xml");
        if (fileObject == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        JavaCardXMLRefactoringSupport javaCardXMLRefactoringSupport = JavaCardXMLRefactoringSupport.fromFile(file);
        if (javaCardXMLRefactoringSupport != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (NodeList nodeList : new NodeList[]{javaCardXMLRefactoringSupport.getDynamicallyLoadedClassElements(), javaCardXMLRefactoringSupport.getShareableInterfaceClassElements()}) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    String string3 = node.getTextContent();
                    if (!string3.startsWith(string)) continue;
                    arrayList.add(node);
                }
            }
            if (arrayList.size() > 0) {
                String string4 = NbBundle.getMessage(JCRenameRefactoringPlugin.class, (String)"Update_jc_specific_descriptor", (Object)string);
                refactoringElementsBag.add(this.renameRefactoring, (RefactoringElementImplementation)new UpdateXmlRefactoringElement(fileObject, string, string2, javaCardXMLRefactoringSupport.getDocument(), arrayList, string4));
            }
        }
        return null;
    }

    private final class UpdateXmlRefactoringElement
    extends SimpleRefactoringElementImplementation {
        private String oldPrefix;
        private String newPrefix;
        private FileObject targetFile;
        private Document doc;
        private List<Node> nodesToUpdate;
        private String message;

        UpdateXmlRefactoringElement(FileObject fileObject, String string, String string2, Document document, List<Node> list, String string3) {
            this.oldPrefix = string;
            this.newPrefix = string2;
            this.targetFile = fileObject;
            this.doc = document;
            this.nodesToUpdate = list;
            this.message = string3;
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            for (Node node : this.nodesToUpdate) {
                String string = node.getTextContent();
                string = this.newPrefix + string.substring(this.oldPrefix.length());
                node.setTextContent(string);
            }
            try {
                ImportantFilesRenameRefactoring.this.transformer.transform(new DOMSource(this.doc), new StreamResult(FileUtil.toFile((FileObject)this.targetFile)));
            }
            catch (TransformerException transformerException) {
                Exceptions.printStackTrace((Throwable)transformerException);
            }
        }

        public String getText() {
            return this.message;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.targetFile;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static final class UpdateDeploymentXmlRefactoringElement
    extends SimpleRefactoringElementImplementation {
        private FileObject target;
        private DeploymentXmlModel mdl;
        private String msg;

        UpdateDeploymentXmlRefactoringElement(DeploymentXmlModel deploymentXmlModel, String string, FileObject fileObject) {
            this.mdl = deploymentXmlModel;
            this.msg = string;
            this.target = fileObject;
        }

        public String getText() {
            return this.msg;
        }

        public String getDisplayText() {
            return this.getText();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            try {
                OutputStream outputStream = this.target.getOutputStream();
                String string = this.mdl.toXml();
                PrintWriter printWriter = new PrintWriter(outputStream);
                try {
                    printWriter.println(string);
                }
                finally {
                    printWriter.close();
                    outputStream.close();
                }
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                Exceptions.printStackTrace((Throwable)fileAlreadyLockedException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public Lookup getLookup() {
            return Lookups.fixed((Object[])new Object[]{this, this.target});
        }

        public FileObject getParentFile() {
            return this.target;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private final class RenameClassRefactoring
    implements RefactoringPlugin {
        FileObject sourceFile;

        public RenameClassRefactoring(FileObject fileObject) {
            this.sourceFile = fileObject;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
            if (ImportantFilesRenameRefactoring.this.renameRefactoring instanceof RenameRefactoring) {
                String string = ImportantFilesRenameRefactoring.this.getResourceName(this.sourceFile);
                String string2 = ((RenameRefactoring)ImportantFilesRenameRefactoring.this.renameRefactoring).getNewName();
                String string3 = string.substring(0, string.lastIndexOf(46) + 1) + string2;
                return ImportantFilesRenameRefactoring.this.prepareClassRenaming(refactoringElementsBag, string, string3);
            }
            Problem problem = null;
            MoveRefactoring moveRefactoring = (MoveRefactoring)ImportantFilesRenameRefactoring.this.renameRefactoring;
            URL uRL = (URL)moveRefactoring.getTarget().lookup(URL.class);
            for (FileObject fileObject : moveRefactoring.getRefactoringSource().lookupAll(FileObject.class)) {
                String string = ImportantFilesRenameRefactoring.this.getResourceName(fileObject);
                String string4 = this.getRelativePath(fileObject, uRL);
                Problem problem2 = ImportantFilesRenameRefactoring.this.prepareClassRenaming(refactoringElementsBag, string, string4);
                if (problem != null) {
                    problem.setNext(problem2);
                }
                problem = problem2;
            }
            return problem;
        }

        private String getRelativePath(FileObject fileObject, URL uRL) {
            if (uRL == null) {
                return null;
            }
            if (fileObject != null) {
                File file = FileUtil.toFile((FileObject)fileObject);
                try {
                    File file2 = new File(uRL.toURI());
                    Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                    JCProject jCProject = (JCProject)project.getLookup().lookup(JCProject.class);
                    if (jCProject != null) {
                        ClassPath classPath = jCProject.getSourceClassPath();
                        for (FileObject fileObject2 : classPath.getRoots()) {
                            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                            String string = classPath.getResourceName(fileObject.getParent(), File.separatorChar, false);
                            int n = file.getAbsolutePath().indexOf(string);
                            if (n > 0 && n < file2.getAbsolutePath().length()) {
                                String string2 = file2.getAbsolutePath().substring(n).replace(File.separatorChar, '.');
                                return string2 + '.' + fileObject.getName();
                            }
                            if (n >= file2.getAbsolutePath().length()) {
                                return fileObject.getName();
                            }
                            if (n != 0) continue;
                            return file2.getAbsolutePath().substring(file.getParentFile().getAbsolutePath().length() + 1).replace(File.separatorChar, '.') + '.' + fileObject.getName();
                        }
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
            }
            return null;
        }
    }

    private class RenamePackageRefactoring
    implements RefactoringPlugin {
        private FileObject packageFolder;

        public RenamePackageRefactoring(FileObject fileObject) {
            this.packageFolder = fileObject;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
            String string = ImportantFilesRenameRefactoring.this.getResourceName(this.packageFolder);
            if (ImportantFilesRenameRefactoring.this.renameRefactoring instanceof RenameRefactoring) {
                String string2 = ((RenameRefactoring)ImportantFilesRenameRefactoring.this.renameRefactoring).getNewName();
                return ImportantFilesRenameRefactoring.this.prepareClassRenaming(refactoringElementsBag, string, string2);
            }
            return null;
        }
    }
}

