/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UnsupportedEncodingDialog
extends JPanel
implements Runnable {
    private final DefaultComboBoxModel mdl = new DefaultComboBoxModel();
    private DialogDescriptor descriptor;
    private JComboBox charsetComboBox;
    private JLabel instructions;

    public UnsupportedEncodingDialog() {
        this.initComponents();
        Cursor cursor = Cursor.getPredefinedCursor(3);
        this.setCursor(cursor);
        this.instructions.setCursor(cursor);
        this.charsetComboBox.setCursor(cursor);
    }

    void setDialogDescriptor(DialogDescriptor d) {
        this.descriptor = d;
    }

    public static Charset showDialog(String projectName, String requestedCharset) {
        UnsupportedEncodingDialog pnl = new UnsupportedEncodingDialog();
        String s = pnl.instructions.getText();
        MessageFormat.format(s, requestedCharset);
        String title = NbBundle.getMessage(UnsupportedEncodingDialog.class, (String)"UNSUPPORTED_ENCODING", (Object)requestedCharset, (Object)projectName);
        String close = NbBundle.getMessage(UnsupportedEncodingDialog.class, (String)"CLOSE");
        DialogDescriptor des = new DialogDescriptor((Object)pnl, title, true, new Object[]{close}, (Object)close, 0, HelpCtx.DEFAULT_HELP, null);
        pnl.setDialogDescriptor(des);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)des);
        return pnl.getSelectedCharset();
    }

    private Charset getSelectedCharset() {
        Object o = this.charsetComboBox.getSelectedItem();
        if (o instanceof Entry) {
            return ((Entry)o).charset;
        }
        return Charset.forName("UTF-8");
    }

    private void initComponents() {
        this.instructions = new JLabel();
        this.charsetComboBox = new JComboBox();
        this.instructions.setLabelFor(this.charsetComboBox);
        this.instructions.setText(NbBundle.getMessage(UnsupportedEncodingDialog.class, (String)"UnsupportedEncodingDialog.instructions.text", (Object[])new Object[0]));
        this.charsetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"[Loading all character sets]"}));
        this.charsetComboBox.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.charsetComboBox, 0, 359, Short.MAX_VALUE).add(1, (Component)this.instructions, -1, 359, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.instructions).addPreferredGap(1).add((Component)this.charsetComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            try {
                Entry utf8 = null;
                if (!EventQueue.isDispatchThread()) {
                    SortedMap<String, Charset> m = Charset.availableCharsets();
                    for (Map.Entry<String, Charset> e : m.entrySet()) {
                        Entry entry = new Entry(e.getKey(), e.getValue());
                        if ("UTF-8".equals(e.getKey().toUpperCase())) {
                            utf8 = entry;
                        }
                        this.mdl.addElement(entry);
                    }
                }
                if (utf8 == null) return;
                this.mdl.setSelectedItem(utf8);
                return;
            }
            finally {
                EventQueue.invokeLater(this);
            }
        } else {
            this.charsetComboBox.setModel(this.mdl);
            this.charsetComboBox.setEnabled(true);
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            this.instructions.setCursor(cursor);
            this.charsetComboBox.setCursor(cursor);
            if (this.descriptor == null) return;
            this.descriptor.setValid(false);
        }
    }

    private static final class Entry {
        String nm;
        Charset charset;

        public Entry(String nm, Charset charset) {
            this.nm = nm;
            this.charset = charset;
        }

        public String toString() {
            return this.charset.displayName();
        }
    }
}

