/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class DiffViewAction
extends AbstractAction {
    private final Trouble.ComparisonFailure comparisonFailure;

    public DiffViewAction(Trouble.ComparisonFailure comparisonFailure) {
        this.comparisonFailure = comparisonFailure;
        if (this.comparisonFailure == null) {
            this.setEnabled(false);
        }
    }

    public DiffViewAction(Testcase testcase) {
        this(testcase.getTrouble() != null ? testcase.getTrouble().getComparisonFailure() : null);
    }

    @Override
    public Object getValue(String key) {
        if ("Name".equals(key)) {
            return NbBundle.getMessage(DiffViewAction.class, (String)"LBL_ViewDiff");
        }
        return super.getValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        StringComparisonSource expected = new StringComparisonSource(NbBundle.getMessage(DiffViewAction.class, (String)"LBL_Expected"), this.comparisonFailure.getExpected(), this.comparisonFailure.getMimeType());
        StringComparisonSource actual = new StringComparisonSource(NbBundle.getMessage(DiffViewAction.class, (String)"LBL_Actual"), this.comparisonFailure.getActual(), this.comparisonFailure.getMimeType());
        try {
            JComponent diffComponent = DiffController.create((StreamSource)expected, (StreamSource)actual).getJComponent();
            diffComponent.setPreferredSize(new Dimension(500, 250));
            JButton ok = new JButton(NbBundle.getMessage(DiffViewAction.class, (String)"LBL_OK"));
            DialogDescriptor descriptor = new DialogDescriptor((Object)diffComponent, NbBundle.getMessage(DiffViewAction.class, (String)"LBL_Diff"), true, new Object[]{ok}, (Object)ok, 0, null, null);
            Dialog dialog = null;
            try {
                dialog = DialogDisplayer.getDefault().createDialog(descriptor);
                dialog.setVisible(true);
            }
            finally {
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class StringComparisonSource
    extends StreamSource {
        private final String name;
        private final String source;
        private final String mimeType;

        public StringComparisonSource(String name, String source, String mimeType) {
            this.name = name;
            this.source = source;
            this.mimeType = mimeType;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.getName();
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            return new StringReader(this.source);
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }
    }
}

