/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.util.Exceptions;

final class CopyHandler
implements OperationListener {
    private static final CopyHandler INSTANCE = new CopyHandler();

    public static CopyHandler getInstance() {
        return INSTANCE;
    }

    public void register() {
        DataLoaderPool.getDefault().addOperationListener((OperationListener)this);
    }

    private static void renameFO(JavaSource javaSource, final String string, final String string2, final String string3) throws IOException {
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                CompilationUnitTree compilationUnitTree2 = treeMaker.CompilationUnit((ExpressionTree)("".equals(string) ? null : treeMaker.Identifier((CharSequence)string)), compilationUnitTree.getImports(), compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
                workingCopy.rewrite((Tree)compilationUnitTree, (Tree)compilationUnitTree2);
                if (string3 != null && !string3.equals(string2)) {
                    for (Tree tree : compilationUnitTree.getTypeDecls()) {
                        ClassTree classTree;
                        if (Tree.Kind.CLASS != tree.getKind() || !string3.contentEquals((classTree = (ClassTree)tree).getSimpleName())) continue;
                        Tree tree2 = treeMaker.setLabel(tree, (CharSequence)string2);
                        workingCopy.rewrite(tree, tree2);
                    }
                }
            }
        };
        javaSource.runModificationTask((Task)task).commit();
    }

    private CopyHandler() {
    }

    public void operationCopy(OperationEvent.Copy copy) {
        FileObject fileObject = copy.getObject().getPrimaryFile();
        FileObject fileObject2 = copy.getOriginalDataObject().getPrimaryFile();
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return;
        }
        if (!"text/x-java".equals(FileUtil.getMIMEType((FileObject)fileObject)) && !"java".equals(fileObject.getExt())) {
            return;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return;
        }
        String string = classPath.getResourceName(fileObject.getParent(), '.', false);
        try {
            CopyHandler.renameFO(javaSource, string, fileObject.getName(), fileObject2.getName());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void operationPostCreate(OperationEvent operationEvent) {
    }

    public void operationMove(OperationEvent.Move move) {
    }

    public void operationDelete(OperationEvent operationEvent) {
    }

    public void operationRename(OperationEvent.Rename rename) {
    }

    public void operationCreateShadow(OperationEvent.Copy copy) {
    }

    public void operationCreateFromTemplate(OperationEvent.Copy copy) {
    }
}

