/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CommandRunnable;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.ui.UIUtils;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RootWizard;
import org.netbeans.modules.versioning.system.cvss.util.CommandDuplicator;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.CommandReport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.xml.XMLUtil;

public abstract class ExecutorSupport
implements CVSListener,
ExecutorGroup.Groupable {
    private static final String[] ignoredMessagePrefixes = new String[]{"cvs server: Updating", "cvs server: New directory"};
    protected final FileStatusCache cache;
    protected List toRefresh = new ArrayList(10);
    protected final CvsVersioningSystem cvs;
    protected final Command cmd;
    private final GlobalOptions options;
    private RequestProcessor.Task task;
    private List taskListeners = new ArrayList(2);
    private Throwable internalError;
    private boolean terminated;
    private boolean commandFailed;
    private boolean finishedExecution;
    private boolean executed;
    private CommandRunnable commandRunnable;
    private StringBuffer message = new StringBuffer();
    private ClientRuntime clientRuntime;
    private List errorMessages = new ArrayList();
    private List warningMessages = new ArrayList();
    private ExecutorGroup group;
    boolean t9yRetryFlag;
    private boolean nonInteractive;

    protected ExecutorSupport(CvsVersioningSystem cvs, Command cmd, GlobalOptions options) {
        this.cvs = cvs;
        this.cmd = cmd;
        this.options = options;
        this.cache = cvs.getStatusCache();
    }

    protected void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    @Override
    public void execute() {
        assert (!this.executed);
        this.executed = true;
        if (this.group == null) {
            this.group = new ExecutorGroup(this.getDisplayName());
            this.group.setNonInteractive(this.nonInteractive);
        }
        this.setup();
        this.executeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeImpl() {
        try {
            this.task = this.cvs.post(this.cmd, this.options, this);
        }
        catch (Throwable e) {
            this.internalError = e;
            this.group.fail();
            String msg = NbBundle.getMessage(ExecutorSupport.class, (String)"BK1003", (Object)new Date(), (Object)this.getDisplayName());
            if (this.clientRuntime != null) {
                this.clientRuntime.log(msg + "\n");
                this.clientRuntime.logError(e);
            }
            ErrorManager.getDefault().notify(1, e);
            ExecutorSupport executorSupport = this;
            synchronized (executorSupport) {
                this.finishedExecution = true;
                this.notifyAll();
            }
            this.cleanup();
        }
    }

    protected void setup() {
    }

    protected void cleanup() {
    }

    protected String getDisplayName() {
        String commandName;
        if (this.group != null) {
            commandName = this.group.getDisplayName();
        } else {
            commandName = this.cmd.getDisplayName();
            if (commandName == null) {
                commandName = this.cmd.getCVSCommand();
            }
        }
        return commandName;
    }

    protected boolean logCommandOutput() {
        return true;
    }

    @Override
    public void joinGroup(ExecutorGroup group) {
        assert (!this.executed);
        this.group = group;
    }

    public ExecutorGroup getGroup() {
        return this.group;
    }

    public Throwable getFailure() {
        return this.internalError;
    }

    public boolean isCancelled() {
        return this.group.isCancelled();
    }

    public boolean isSuccessful() {
        return this.internalError == null && !this.group.isCancelled() && !this.commandFailed;
    }

    public RequestProcessor.Task getTask() {
        return this.task;
    }

    public void messageSent(MessageEvent e) {
        if (e.isError()) {
            String msg = e.getMessage();
            if (msg == null) {
                RuntimeException rex = new RuntimeException("Received null MessageEvent from:");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                rex.printStackTrace(pw);
                pw.close();
                msg = sw.getBuffer().toString();
            }
            this.errorMessages.add(msg);
        } else if (e.getMessage().startsWith("W ")) {
            this.warningMessages.add(e.getMessage().substring(2));
        }
        if (e.isTagged()) {
            String s = MessageEvent.parseTaggedMessage((StringBuffer)this.message, (String)e.getMessage());
            if (s != null) {
                this.clientRuntime.log(s + "\n");
                this.message.setLength(0);
            }
        } else {
            boolean locked = e.getMessage().indexOf("waiting for") != -1;
            if (((locked &= e.getMessage().indexOf("lock in") != -1) || this.logCommandOutput()) && e.getMessage().length() > 0 && this.shouldBeDisplayed(e.getMessage())) {
                this.clientRuntime.log(e.getMessage() + "\n");
            }
        }
    }

    private boolean shouldBeDisplayed(String message) {
        for (int i = 0; i < ignoredMessagePrefixes.length; ++i) {
            if (!message.startsWith(ignoredMessagePrefixes[i])) continue;
            return false;
        }
        return true;
    }

    public void messageSent(BinaryMessageEvent e) {
    }

    public void fileAdded(FileAddedEvent e) {
    }

    public void fileRemoved(FileRemovedEvent e) {
    }

    public void fileUpdated(FileUpdatedEvent e) {
    }

    public void fileToRemove(FileToRemoveEvent e) {
    }

    public void fileInfoGenerated(FileInfoEvent e) {
        assert (!this.terminated);
        FileInfoContainer fic = e.getInfoContainer();
        if (fic.getFile() == null) {
            ErrorManager.getDefault().log(16, org.netbeans.modules.versioning.util.Utils.getStackTrace());
            return;
        }
        if (fic instanceof DefaultFileInfoContainer) {
            DefaultFileInfoContainer dfic = (DefaultFileInfoContainer)fic;
            dfic.setFile(FileUtil.normalizeFile((File)dfic.getFile()));
            Iterator i = this.toRefresh.iterator();
            while (i.hasNext()) {
                FileInfoContainer existing = (FileInfoContainer)i.next();
                if (!existing.getFile().equals(fic.getFile())) continue;
                String existingType = ((DefaultFileInfoContainer)existing).getType();
                String newType = dfic.getType();
                if (this.importance(newType) <= this.importance(existingType)) {
                    return;
                }
                i.remove();
                break;
            }
        }
        this.toRefresh.add(fic);
    }

    private int importance(String type) {
        return "UC".indexOf(type);
    }

    public void commandEnqueued(CommandRunnable commandRunnable) {
        this.commandRunnable = commandRunnable;
        this.group.enqueued(this.cvs.getClientRuntime(this.cmd, this.options), this);
        this.group.addCancellable(commandRunnable);
    }

    public void commandStarted(CommandRunnable commandRunnable) {
        this.clientRuntime = this.cvs.getClientRuntime(this.cmd, this.options);
        this.group.started(this.clientRuntime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandTerminated(TerminationEvent e) {
        try {
            if (e.getSource() instanceof ClientRuntime.Result) {
                assert (!this.terminated);
                this.terminated = true;
                ClientRuntime.Result result = (ClientRuntime.Result)e.getSource();
                Throwable error = result.getError();
                if (result.isAborted() || Thread.currentThread().isInterrupted()) {
                    this.toRefresh.clear();
                    return;
                }
                if (error != null) {
                    String msg;
                    this.toRefresh.clear();
                    if (error instanceof CommandException) {
                        this.internalError = error;
                        ErrorManager.getDefault().notify(1, error);
                        this.report(NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandFailed_Title"), NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandFailed_Prompt"), Arrays.asList(error.getMessage()), 0);
                    } else if (!this.nonInteractive && this.retryConnection(error)) {
                        this.terminated = false;
                        msg = NbBundle.getMessage(ExecutorSupport.class, (String)"BK1004", (Object)new Date(), (Object)this.getDisplayName());
                        this.clientRuntime = this.cvs.getClientRuntime(this.cmd, this.options);
                        this.clientRuntime.log(msg + "\n");
                        this.executeImpl();
                    } else {
                        if (!this.nonInteractive) {
                            msg = NbBundle.getMessage(ExecutorSupport.class, (String)"BK1005", (Object)new Date(), (Object)this.getDisplayName());
                            this.clientRuntime.log(msg + "\n");
                        }
                        this.internalError = result.getError();
                        this.group.fail();
                        ErrorManager.getDefault().notify(1, this.internalError);
                    }
                } else {
                    this.commandFinished((ClientRuntime.Result)e.getSource());
                    if (this.cmd.hasFailed()) {
                        this.commandFailed = true;
                        this.group.fail();
                        this.report(NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandFailed_Title"), NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandFailed_Prompt"), this.errorMessages, 0);
                    }
                    if (this.warningMessages.size() > 0) {
                        this.report(NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandWarning_Title"), NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandWarning_Prompt"), this.warningMessages, 2);
                    }
                }
            }
        }
        finally {
            if (this.terminated) {
                Iterator it;
                this.cleanup();
                ExecutorSupport executorSupport = this;
                synchronized (executorSupport) {
                    this.finishedExecution = true;
                    this.notifyAll();
                }
                List list = this.taskListeners;
                synchronized (list) {
                    it = new ArrayList(this.taskListeners).iterator();
                }
                while (it.hasNext()) {
                    try {
                        TaskListener listener = (TaskListener)it.next();
                        listener.taskFinished((Task)this.task);
                    }
                    catch (RuntimeException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
                this.group.finished(this.clientRuntime, this);
            }
        }
    }

    protected void report(String title, String prompt, List<String> messages, int type) {
        if (this.nonInteractive) {
            return;
        }
        boolean emptyReport = true;
        for (String message : messages) {
            if (message == null || message.length() <= 0) continue;
            emptyReport = false;
            break;
        }
        if (emptyReport) {
            return;
        }
        CommandReport report = new CommandReport(prompt, messages);
        JButton ok = new JButton(NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_CommandReport_OK"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)report, title, -1, type, new Object[]{ok}, (Object)ok);
        DialogDisplayer.getDefault().notify(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener l) {
        List list = this.taskListeners;
        synchronized (list) {
            this.taskListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener l) {
        List list = this.taskListeners;
        synchronized (list) {
            this.taskListeners.remove(l);
        }
    }

    private boolean retryConnection(Throwable cause) {
        String msg;
        CVSRoot root;
        Throwable initialCause = cause;
        String cvsRoot = this.getCvsRoot();
        if (cvsRoot == null) {
            return false;
        }
        try {
            root = CVSRoot.parse((String)cvsRoot);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        final RootWizard rootWizard = RootWizard.configureRoot(root.toString());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        StringBuffer reason = new StringBuffer("<ul>");
        while (cause != null) {
            try {
                msg = cause.getLocalizedMessage();
                msg = msg == null ? cause.getClass().getName() : XMLUtil.toElementContent((String)msg);
                reason.append("<li>" + msg + "</li>");
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            cause = cause.getCause();
        }
        reason.append("</ul>");
        msg = NbBundle.getMessage(ExecutorSupport.class, (String)"BK0001", (Object)reason.toString(), (Object)cvsRoot);
        JLabel label = new JLabel(msg);
        int ex = Math.max((int)((double)cvsRoot.length() * 1.1), 50);
        UIUtils.computePreferredSize(label, ex);
        panel.add((Component)label, "North");
        panel.add((Component)rootWizard.getPanel(), "Center");
        String okMsg = NbBundle.getMessage(ExecutorSupport.class, (String)"CTL_Password_Action_Ok");
        final JButton ok = new JButton(okMsg);
        ok.setEnabled(rootWizard.isValid());
        ok.getAccessibleContext().setAccessibleDescription(okMsg);
        String cancelMsg = NbBundle.getMessage(ExecutorSupport.class, (String)"CTL_Password_Action_Cancel");
        JButton cancel = new JButton(cancelMsg);
        cancel.getAccessibleContext().setAccessibleDescription(cancelMsg);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(ExecutorSupport.class, (String)"BK0004", (Object)this.getDisplayName()), true, new Object[]{ok, cancel}, (Object)ok, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        descriptor.setMessageType(2);
        descriptor.setClosingOptions(null);
        rootWizard.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ok.setEnabled(rootWizard.isValid());
            }
        });
        ErrorManager.getDefault().notify(1, initialCause);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExecutorSupport.class, (String)"BK0005"));
        dialog.setVisible(true);
        boolean retry = false;
        if (descriptor.getValue() == ok) {
            rootWizard.commit(false);
            retry = true;
        }
        return retry;
    }

    private String getCvsRoot() {
        if (this.cmd.getGlobalOptions() != null && this.cmd.getGlobalOptions().getCVSRoot() != null) {
            return this.cmd.getGlobalOptions().getCVSRoot();
        }
        if (this.options != null && this.options.getCVSRoot() != null) {
            return this.options.getCVSRoot();
        }
        try {
            return this.cvs.detectCvsRoot(this.cmd);
        }
        catch (NotVersionedException notVersionedException) {
            return null;
        }
    }

    protected abstract void commandFinished(ClientRuntime.Result var1);

    public void moduleExpanded(ModuleExpansionEvent e) {
    }

    protected static BasicCommand[] prepareBasicCommand(BasicCommand cmd) throws IOException {
        String format = cmd.getDisplayName();
        File[] files = cmd.getFiles();
        if (files == null || files.length < 2) {
            if (format != null) {
                cmd.setDisplayName(MessageFormat.format(format, files == null ? "" : files[0].getName()));
            }
            return new BasicCommand[]{cmd};
        }
        File[][] fileSets = ExecutorSupport.splitFiles(files);
        if (fileSets.length == 1) {
            String nfiles = NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_ExecutorSupport_CommandFiles", (Object)Integer.toString(fileSets[0].length));
            if (format != null) {
                cmd.setDisplayName(MessageFormat.format(format, nfiles));
            }
            return new BasicCommand[]{cmd};
        }
        BasicCommand[] commands = new BasicCommand[fileSets.length];
        CommandDuplicator cloner = CommandDuplicator.getDuplicator((Command)cmd);
        for (int i = 0; i < fileSets.length; ++i) {
            BasicCommand bc = (BasicCommand)cloner.duplicate();
            bc.setFiles(fileSets[i]);
            commands[i] = bc;
            String nfiles = NbBundle.getMessage(ExecutorSupport.class, (String)"MSG_ExecutorSupport_CommandFiles", (Object)Integer.toString(fileSets[i].length));
            if (format == null) continue;
            commands[i].setDisplayName(MessageFormat.format(format, nfiles));
        }
        return commands;
    }

    protected static File[][] splitFiles(File[] files) throws IOException {
        ArrayList<File[]> ret = new ArrayList<File[]>();
        File[][] aset = ExecutorSupport.splitByCvsRoot(files);
        for (int i = 0; i < aset.length; ++i) {
            File[] fileSet = aset[i];
            File[][] splitSet = ExecutorSupport.splitByCommonParent(fileSet);
            for (int j = 0; j < splitSet.length; ++j) {
                ret.add(splitSet[j]);
            }
        }
        return (File[][])ret.toArray((T[])new File[ret.size()][]);
    }

    protected static File[][] splitByCvsRoot(File[] files) throws IOException {
        HashMap<String, HashSet<File>> fileBuckets = new HashMap<String, HashSet<File>>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String root = Utils.getCVSRootFor(file);
            HashSet<File> bucket = (HashSet<File>)fileBuckets.get(root);
            if (bucket == null) {
                bucket = new HashSet<File>();
                fileBuckets.put(root, bucket);
            }
            bucket.add(file);
        }
        File[][] sets = new File[fileBuckets.size()][];
        int idx = 0;
        for (HashSet<File> bucket : fileBuckets.values()) {
            sets[idx++] = bucket.toArray(new File[bucket.size()]);
        }
        return sets;
    }

    private static File[][] splitByCommonParent(File[] files) {
        HashMap fileBuckets = new HashMap();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            File parent = file.isDirectory() ? file : file.getParentFile();
            Set<File> fileset = null;
            File commonParent = null;
            Iterator j = fileBuckets.keySet().iterator();
            while (j.hasNext()) {
                File key = (File)j.next();
                commonParent = org.netbeans.modules.versioning.util.Utils.getCommonParent((File)parent, (File)key);
                if (commonParent == null) continue;
                fileset = (Set)fileBuckets.get(key);
                j.remove();
                break;
            }
            if (commonParent == null) {
                fileset = new HashSet<File>(1);
                commonParent = parent;
            }
            fileset.add(file);
            fileBuckets.put(commonParent, fileset);
        }
        File[][] sets = new File[fileBuckets.size()][];
        int idx = 0;
        for (Set bucket : fileBuckets.values()) {
            sets[idx++] = bucket.toArray(new File[bucket.size()]);
        }
        return sets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(ExecutorSupport[] executors) {
        boolean success = true;
        for (int i = 0; i < executors.length; ++i) {
            ExecutorSupport executor;
            ExecutorSupport executorSupport = executor = executors[i];
            synchronized (executorSupport) {
                while (!executor.finishedExecution) {
                    try {
                        executor.wait();
                    }
                    catch (InterruptedException e) {
                        executor.getGroup().cancel();
                    }
                }
            }
            if (executor.isSuccessful()) continue;
            success = false;
        }
        return success;
    }

    public void increaseDataCounter(long bytes) {
        this.group.increaseDataCounter(bytes);
    }
}

