/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.RtagCommand;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.util.CommandDuplicator;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class RTagExecutor
extends ExecutorSupport {
    public static RTagExecutor[] splitCommand(RtagCommand cmd, File[] roots, GlobalOptions options) {
        File[][] splitRoots;
        if (cmd.getDisplayName() == null) {
            cmd.setDisplayName(NbBundle.getMessage(RTagExecutor.class, (String)"MSG_RTagExecutor_CmdDisplayName"));
        }
        try {
            splitRoots = RTagExecutor.splitByCvsRoot(roots);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        if (options == null) {
            options = CvsVersioningSystem.createGlobalOptions();
        }
        CvsVersioningSystem cvs = CvsVersioningSystem.getInstance();
        AdminHandler ah = cvs.getAdminHandler();
        RTagExecutor[] executors = new RTagExecutor[splitRoots.length];
        CommandDuplicator cloner = CommandDuplicator.getDuplicator((Command)cmd);
        HashSet<String> remoteRepositories = new HashSet<String>(roots.length);
        for (int i = 0; i < splitRoots.length; ++i) {
            File[] files = splitRoots[i];
            for (int j = 0; j < files.length; ++j) {
                File file = files[j];
                File directory = file.isDirectory() ? file : file.getParentFile();
                try {
                    String repository = ah.getRepositoryForDirectory(directory.getAbsolutePath(), "").substring(1);
                    remoteRepositories.add(repository);
                    continue;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return null;
                }
            }
            GlobalOptions currentOptions = (GlobalOptions)options.clone();
            try {
                currentOptions.setCVSRoot(Utils.getCVSRootFor(files[0]));
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
            RtagCommand command = (RtagCommand)cloner.duplicate();
            command.setModules(remoteRepositories.toArray(new String[remoteRepositories.size()]));
            String commandContext = NbBundle.getMessage(RTagExecutor.class, (String)"MSG_RTagExecutor_CmdContext", (Object)Integer.toString(files.length));
            command.setDisplayName(MessageFormat.format(cmd.getDisplayName(), commandContext));
            executors[i] = new RTagExecutor(cvs, command, currentOptions);
        }
        return executors;
    }

    private RTagExecutor(CvsVersioningSystem cvs, RtagCommand cmd, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
    }

    @Override
    protected void commandFinished(ClientRuntime.Result result) {
    }
}

