/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateResultNode;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.OpenInEditorAction;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class UpdateResultsTable
implements MouseListener,
ListSelectionListener,
AncestorListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private UpdateResultNode[] nodes = new UpdateResultNode[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Node.Property p1 = (Node.Property)o1;
            Node.Property p2 = (Node.Property)o2;
            String sk1 = (String)p1.getValue("sortkey");
            if (sk1 != null) {
                String sk2 = (String)p2.getValue("sortkey");
                return sk1.compareToIgnoreCase(sk2);
            }
            try {
                String s1 = (String)p1.getValue();
                String s2 = (String)p2.getValue();
                return s1.compareToIgnoreCase(s2);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return 0;
            }
        }
    };

    public UpdateResultsTable() {
        ResourceBundle loc = NbBundle.getBundle(UpdateResultsTable.class);
        this.columnLabels.put("name", new String[]{loc.getString("CTL_UpdateResults_Column_File_Title"), loc.getString("CTL_UpdateResults_Column_File_Desc")});
        this.columnLabels.put("status", new String[]{loc.getString("CTL_UpdateResults_Column_Status_Title"), loc.getString("CTL_UpdateResults_Column_Status_Desc")});
        this.columnLabels.put("path", new String[]{loc.getString("CTL_UpdateResults_Column_Path_Title"), loc.getString("CTL_UpdateResults_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new SortedTable(this.sorter);
        int height = new JLabel((String)"FONTSIZE").getPreferredSize().height * 6 / 5;
        this.table.setRowHeight(height);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UpdateResultsTable.class, (String)"ACSN_UpdateResults"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateResultsTable.class, (String)"ACSD_UpdateResults"));
        this.setColumns(new String[]{"name", "status", "path"});
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateResultsTable.this.showPopup(Utils.getPositionForPopup((JTable)UpdateResultsTable.this.table));
            }
        });
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = UpdateResultsTable.this.table.getWidth();
                for (int i = 0; i < UpdateResultsTable.this.tableColumns.length; ++i) {
                    if ("path".equals(UpdateResultsTable.this.tableColumns[i])) {
                        UpdateResultsTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 60 / 100);
                        continue;
                    }
                    UpdateResultsTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 20 / 100);
                }
            }
        });
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    public UpdateResultNode[] getDisplayedNodes() {
        int n = this.sorter.getRowCount();
        UpdateResultNode[] ret = new UpdateResultNode[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.nodes[this.sorter.modelIndex(i)];
        }
        return ret;
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] columns) {
        if (Arrays.equals(columns, this.tableColumns)) {
            return;
        }
        this.setDefaultColumnSizes();
        this.setModelProperties(columns);
        this.tableColumns = columns;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
    }

    private void setModelProperties(String[] columns) {
        Node.Property[] properties = new Node.Property[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String[] labels = this.columnLabels.get(column);
            properties[i] = new ColumnDescriptor(column, String.class, labels[0], labels[1]);
        }
        this.tableModel.setProperties(properties);
    }

    void setTableModel(UpdateResultNode[] nodes) {
        this.nodes = nodes;
        this.tableModel.setNodes((Node[])nodes);
    }

    void focus() {
        this.table.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            Action action = this.nodes[row = this.sorter.modelIndex(row)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    private void showPopup(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        this.showPopup(e.getPoint());
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.getPopup();
        menu.show(this.table, p.x, p.y);
    }

    private JPopupMenu getPopup() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add(new OpenInEditorAction());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(ResolveConflictsAction.class), this.actionString("CTL_PopupMenuItem_ResolveConflicts")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        return menu;
    }

    private String actionString(String key) {
        ResourceBundle actionsLoc = NbBundle.getBundle(Annotator.class);
        return actionsLoc.getString(key);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ArrayList<UpdateResultNode> selectedNodes = new ArrayList<UpdateResultNode>();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (tc == null) {
            return;
        }
        int min = selectionModel.getMinSelectionIndex();
        if (min == -1) {
            tc.setActivatedNodes(new Node[0]);
        }
        int max = selectionModel.getMaxSelectionIndex();
        for (int i = min; i <= max; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            int idx = this.sorter.modelIndex(i);
            selectedNodes.add(this.nodes[idx]);
        }
        tc.setActivatedNodes(selectedNodes.toArray(new Node[selectedNodes.size()]));
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            if (modelColumnIndex == 0) {
                UpdateResultNode node = UpdateResultsTable.this.nodes[UpdateResultsTable.this.sorter.modelIndex(row)];
                if (!isSelected) {
                    value = "<html>" + node.getHtmlDisplayName();
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                String path = UpdateResultsTable.this.nodes[UpdateResultsTable.this.sorter.modelIndex(row)].getInfo().getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

