/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.project.Project;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.CenteredZoomAnimator;
import org.netbeans.modules.maven.graph.DependencyGraphTopComponent;
import org.netbeans.modules.maven.graph.EdgeWidget;
import org.netbeans.modules.maven.graph.FixVersionConflictPanel;
import org.netbeans.modules.maven.graph.FruchtermanReingoldLayout;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DependencyGraphScene
extends GraphScene<ArtifactGraphNode, ArtifactGraphEdge> {
    private LayerWidget mainLayer;
    private LayerWidget connectionLayer;
    private ArtifactGraphNode rootNode;
    private final AllActionsProvider allActionsP = new AllActionsProvider();
    private WidgetAction moveAction = ActionFactory.createMoveAction(null, (MoveProvider)this.allActionsP);
    private WidgetAction popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)this.allActionsP);
    private WidgetAction zoomAction = ActionFactory.createMouseCenteredZoomAction((double)1.1);
    private WidgetAction panAction = ActionFactory.createPanAction();
    private WidgetAction editAction = ActionFactory.createEditAction((EditProvider)this.allActionsP);
    WidgetAction hoverAction = ActionFactory.createHoverAction((TwoStateHoverProvider)new HoverController());
    Action sceneZoomToFitAction = new SceneZoomToFitAction();
    Action highlitedZoomToFitAction = new HighlitedZoomToFitAction();
    private FruchtermanReingoldLayout layout;
    private int maxDepth = 0;
    private final MavenProject project;
    private final Project nbProject;
    private final DependencyGraphTopComponent tc;
    private FitToViewLayout fitViewL;
    private static Set<ArtifactGraphNode> EMPTY_SELECTION = new HashSet<ArtifactGraphNode>();
    private POMModel model;

    DependencyGraphScene(MavenProject mavenProject, Project project, DependencyGraphTopComponent dependencyGraphTopComponent, POMModel pOMModel) {
        this.project = mavenProject;
        this.nbProject = project;
        this.tc = dependencyGraphTopComponent;
        this.model = pOMModel;
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        this.getActions().addAction(this.hoverAction);
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)this.allActionsP));
        this.getActions().addAction(this.zoomAction);
        this.getActions().addAction(this.panAction);
        this.getActions().addAction(this.editAction);
        this.getActions().addAction(this.popupMenuAction);
    }

    void cleanLayout(JScrollPane jScrollPane) {
        this.layout = new FruchtermanReingoldLayout(this, jScrollPane);
        this.layout.invokeLayout();
    }

    ArtifactGraphNode getRootGraphNode() {
        return this.rootNode;
    }

    int getMaxNodeDepth() {
        return this.maxDepth;
    }

    Project getNbProject() {
        return this.nbProject;
    }

    MavenProject getMavenProject() {
        return this.project;
    }

    boolean isAnimated() {
        return true;
    }

    ArtifactGraphNode getGraphNodeRepresentant(DependencyNode dependencyNode) {
        for (ArtifactGraphNode artifactGraphNode : this.getNodes()) {
            if (!artifactGraphNode.represents(dependencyNode)) continue;
            return artifactGraphNode;
        }
        throw new IllegalStateException();
    }

    protected Widget attachNodeWidget(ArtifactGraphNode artifactGraphNode) {
        if (artifactGraphNode.getPrimaryLevel() > this.maxDepth) {
            this.maxDepth = artifactGraphNode.getPrimaryLevel();
        }
        ArtifactWidget artifactWidget = new ArtifactWidget(this, artifactGraphNode);
        this.mainLayer.addChild((Widget)artifactWidget);
        artifactGraphNode.setWidget(artifactWidget);
        if (this.rootNode == null) {
            this.rootNode = artifactGraphNode;
        }
        artifactWidget.setOpaque(true);
        artifactWidget.getActions().addAction(this.createObjectHoverAction());
        artifactWidget.getActions().addAction(this.createSelectAction());
        artifactWidget.getActions().addAction(this.moveAction);
        artifactWidget.getActions().addAction(this.editAction);
        artifactWidget.getActions().addAction(this.popupMenuAction);
        return artifactWidget;
    }

    protected Widget attachEdgeWidget(ArtifactGraphEdge artifactGraphEdge) {
        EdgeWidget edgeWidget = new EdgeWidget(this, artifactGraphEdge);
        this.connectionLayer.addChild((Widget)edgeWidget);
        return edgeWidget;
    }

    protected void attachEdgeSourceAnchor(ArtifactGraphEdge artifactGraphEdge, ArtifactGraphNode artifactGraphNode, ArtifactGraphNode artifactGraphNode2) {
        ((ConnectionWidget)this.findWidget(artifactGraphEdge)).setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)this.findWidget(artifactGraphNode2)));
    }

    protected void attachEdgeTargetAnchor(ArtifactGraphEdge artifactGraphEdge, ArtifactGraphNode artifactGraphNode, ArtifactGraphNode artifactGraphNode2) {
        ArtifactWidget artifactWidget = (ArtifactWidget)this.findWidget(artifactGraphNode2);
        ((ConnectionWidget)this.findWidget(artifactGraphEdge)).setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)artifactWidget));
    }

    void highlightRelated(ArtifactGraphNode artifactGraphNode) {
        Object object;
        Object object22;
        ArrayList<ArtifactGraphNode> arrayList = new ArrayList<ArtifactGraphNode>();
        ArrayList<ArtifactGraphEdge> arrayList2 = new ArrayList<ArtifactGraphEdge>();
        ArrayList<ArtifactGraphEdge> arrayList3 = new ArrayList<ArtifactGraphEdge>();
        ArrayList<ArtifactGraphNode> arrayList4 = new ArrayList<ArtifactGraphNode>();
        ArrayList arrayList5 = new ArrayList();
        arrayList.add(artifactGraphNode);
        List list = artifactGraphNode.getArtifact().getChildren();
        for (Object object22 : list) {
            arrayList4.add(this.getGraphNodeRepresentant((DependencyNode)object22));
        }
        arrayList5.addAll(this.findNodeEdges(artifactGraphNode, true, false));
        this.addPathToRoot(artifactGraphNode, arrayList3, arrayList);
        ArrayList<DependencyNode> arrayList6 = new ArrayList<DependencyNode>(artifactGraphNode.getDuplicatesOrConflicts());
        object22 = arrayList6.iterator();
        while (object22.hasNext()) {
            object = (DependencyNode)object22.next();
            this.addPathToRoot((DependencyNode)object, object.getParent(), arrayList2, arrayList);
        }
        for (Object object3 : this.getEdges()) {
            object22 = (EdgeWidget)this.findWidget(object3);
            if (arrayList3.contains(object3)) {
                ((EdgeWidget)((Object)object22)).setState(4);
                continue;
            }
            if (arrayList2.contains(object3)) {
                ((EdgeWidget)((Object)object22)).setState(3);
                continue;
            }
            if (arrayList5.contains(object3)) {
                ((EdgeWidget)((Object)object22)).setState(1);
                continue;
            }
            ((EdgeWidget)((Object)object22)).setState(0);
        }
        for (ArtifactGraphNode artifactGraphNode2 : this.getNodes()) {
            object = (ArtifactWidget)this.findWidget(artifactGraphNode2);
            if (arrayList.contains(artifactGraphNode2)) {
                ((ArtifactWidget)object).setPaintState(2);
                ((ArtifactWidget)object).setReadable(true);
                continue;
            }
            if (arrayList4.contains(artifactGraphNode2)) {
                ((ArtifactWidget)object).setPaintState(2);
                ((ArtifactWidget)object).setReadable(true);
                continue;
            }
            ((ArtifactWidget)object).setPaintState(0);
            ((ArtifactWidget)object).setReadable(false);
        }
    }

    private void addPathToRoot(ArtifactGraphNode artifactGraphNode, List<ArtifactGraphEdge> list, List<ArtifactGraphNode> list2) {
        DependencyNode dependencyNode = artifactGraphNode.getArtifactParent();
        this.addPathToRoot(artifactGraphNode.getArtifact(), dependencyNode, list, list2);
    }

    private void addPathToRoot(DependencyNode dependencyNode, DependencyNode dependencyNode2, List<ArtifactGraphEdge> list, List<ArtifactGraphNode> list2) {
        while (dependencyNode2 != null) {
            ArtifactGraphNode artifactGraphNode = this.getGraphNodeRepresentant(dependencyNode2);
            list.addAll(this.findEdgesBetween(artifactGraphNode, this.getGraphNodeRepresentant(dependencyNode)));
            list2.add(artifactGraphNode);
            dependencyNode = dependencyNode2;
            dependencyNode2 = artifactGraphNode.getArtifactParent();
        }
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        super.notifyStateChanged(objectState, objectState2);
        if (!objectState.isSelected() && objectState2.isSelected()) {
            this.tc.depthHighlight();
        }
    }

    private FitToViewLayout getFitToViewLayout() {
        if (this.fitViewL == null) {
            this.fitViewL = new FitToViewLayout(this);
        }
        return this.fitViewL;
    }

    boolean isEditable() {
        return this.model != null;
    }

    static boolean isFixCandidate(ArtifactGraphNode artifactGraphNode) {
        Set<DependencyNode> set = artifactGraphNode.getDuplicatesOrConflicts();
        DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(artifactGraphNode.getArtifact().getArtifact().getVersion());
        for (DependencyNode dependencyNode : set) {
            if (dependencyNode.getState() != 2 || defaultArtifactVersion.compareTo((Object)new DefaultArtifactVersion(dependencyNode.getArtifact().getVersion())) >= 0) continue;
            return true;
        }
        return false;
    }

    static ArtifactVersion findNewest(ArtifactGraphNode artifactGraphNode, boolean bl) {
        Set<DependencyNode> set = artifactGraphNode.getDuplicatesOrConflicts();
        DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(artifactGraphNode.getArtifact().getArtifact().getVersion());
        DefaultArtifactVersion defaultArtifactVersion2 = null;
        for (DependencyNode dependencyNode : set) {
            if (!bl && dependencyNode.getState() != 2 || defaultArtifactVersion.compareTo((Object)(defaultArtifactVersion2 = new DefaultArtifactVersion(dependencyNode.getArtifact().getVersion()))) >= 0) continue;
            defaultArtifactVersion = defaultArtifactVersion2;
        }
        return defaultArtifactVersion;
    }

    void invokeFixConflict(ArtifactGraphNode artifactGraphNode) {
        new FixVersionConflictAction(artifactGraphNode).actionPerformed(null);
    }

    private void excludeDepFromModel(ArtifactGraphNode artifactGraphNode, Set<Artifact> set) {
        assert (this.model.isIntransaction()) : "Must be called inside transaction";
        Artifact artifact = artifactGraphNode.getArtifact().getArtifact();
        for (Artifact artifact2 : set) {
            Exclusion exclusion;
            Dependency dependency = this.model.getProject().findDependencyById(artifact2.getGroupId(), artifact2.getArtifactId(), null);
            if (dependency == null) {
                org.apache.maven.model.Profile profile2;
                exclusion = new ArrayList();
                NbMavenProject nbMavenProject = (NbMavenProject)this.nbProject.getLookup().lookup(NbMavenProject.class);
                for (org.apache.maven.model.Profile profile2 : nbMavenProject.getMavenProject().getActiveProfiles()) {
                    exclusion.add(profile2.getId());
                }
                profile2 = exclusion.iterator();
                while (profile2.hasNext()) {
                    String string = (String)profile2.next();
                    Profile profile3 = this.model.getProject().findProfileById(string);
                    if (profile3 == null || (dependency = profile3.findDependencyById(artifact2.getGroupId(), artifact2.getArtifactId(), null)) == null) continue;
                    break;
                }
            }
            if (dependency == null) {
                dependency = this.model.getFactory().createDependency();
                dependency.setArtifactId(artifact2.getArtifactId());
                dependency.setGroupId(artifact2.getGroupId());
                dependency.setType(artifact2.getType());
                dependency.setVersion(artifact2.getVersion());
                this.model.getProject().addDependency(dependency);
            }
            if ((exclusion = dependency.findExclusionById(artifact.getGroupId(), artifact.getArtifactId())) != null) continue;
            exclusion = this.model.getFactory().createExclusion();
            exclusion.setArtifactId(artifact.getArtifactId());
            exclusion.setGroupId(artifact.getGroupId());
            dependency.addExclusion(exclusion);
        }
    }

    private void updateGraphAfterExclusion(ArtifactGraphNode artifactGraphNode, Set<Artifact> set, Set<DependencyNode> set2) {
        boolean bl = false;
        HashSet<DependencyNode> hashSet = new HashSet<DependencyNode>();
        block0: for (DependencyNode object22 : artifactGraphNode.getDuplicatesOrConflicts()) {
            if (object22.getState() != 2) continue;
            for (DependencyNode dependencyNode = object22.getParent(); dependencyNode != null; dependencyNode = dependencyNode.getParent()) {
                if (!set.contains(dependencyNode.getArtifact())) continue;
                hashSet.add(object22);
                continue block0;
            }
        }
        ArrayList arrayList = new ArrayList();
        Collection collection = this.findNodeEdges(artifactGraphNode, false, true);
        ArtifactGraphNode artifactGraphNode2 = null;
        boolean bl2 = false;
        block2: for (Object object : collection) {
            artifactGraphNode2 = (ArtifactGraphNode)this.getEdgeSource(object);
            if (artifactGraphNode2 == null) continue;
            for (Object object2 : set2) {
                if (artifactGraphNode2.getArtifact().equals(object2)) {
                    bl2 = true;
                }
                if (!artifactGraphNode2.represents((DependencyNode)object2)) continue;
                arrayList.add(object);
                continue block2;
            }
        }
        artifactGraphNode.getDuplicatesOrConflicts().removeAll(hashSet);
        ArtifactVersion artifactVersion = arrayList.iterator();
        while (artifactVersion.hasNext()) {
            Object object;
            object = (ArtifactGraphEdge)artifactVersion.next();
            this.removeEdge(object);
            ((ArtifactGraphEdge)object).getSource().removeChild(((ArtifactGraphEdge)object).getTarget());
            bl = true;
        }
        Collection collection2 = this.findNodeEdges(artifactGraphNode, false, true);
        if (bl2) {
            artifactVersion = DependencyGraphScene.findNewest(artifactGraphNode, true);
            artifactGraphNode.getArtifact().getArtifact().setVersion(artifactVersion.toString());
            for (Object object : collection2) {
                Object object2;
                object2 = (EdgeWidget)this.findWidget(object);
                if (object2 == null) continue;
                object2.modelChanged();
            }
        }
        if (collection2.isEmpty()) {
            this.removeSubGraph(artifactGraphNode);
            bl = true;
        } else {
            artifactGraphNode.getWidget().modelChanged();
        }
        if (bl) {
            this.validate();
        }
    }

    private void removeSubGraph(ArtifactGraphNode artifactGraphNode) {
        if (!this.isNode(artifactGraphNode)) {
            return;
        }
        Collection collection = this.findNodeEdges(artifactGraphNode, false, true);
        if (!collection.isEmpty()) {
            return;
        }
        Collection collection2 = this.findNodeEdges(artifactGraphNode, true, false);
        ArrayList<ArtifactGraphNode> arrayList = new ArrayList<ArtifactGraphNode>();
        DependencyNode dependencyNode = null;
        ArtifactGraphNode artifactGraphNode2 = null;
        for (ArtifactGraphEdge object : collection2) {
            dependencyNode = object.getTarget();
            artifactGraphNode2 = this.getGraphNodeRepresentant(dependencyNode);
            arrayList.add(artifactGraphNode2);
            this.removeEdge(object);
            object.getSource().removeChild(dependencyNode);
            artifactGraphNode2.getDuplicatesOrConflicts().remove(dependencyNode);
        }
        for (ArtifactGraphNode artifactGraphNode3 : arrayList) {
            this.removeSubGraph(artifactGraphNode3);
        }
        this.removeNode(artifactGraphNode);
    }

    private class HoverController
    implements TwoStateHoverProvider {
        private HoverController() {
        }

        public void unsetHovering(Widget widget) {
            ArtifactWidget artifactWidget = this.findArtifactW(widget);
            if (widget != null) {
                artifactWidget.bulbUnhovered();
            }
        }

        public void setHovering(Widget widget) {
            ArtifactWidget artifactWidget = this.findArtifactW(widget);
            if (artifactWidget != null) {
                artifactWidget.bulbHovered();
            }
        }

        private ArtifactWidget findArtifactW(Widget widget) {
            while (widget != null && !(widget instanceof ArtifactWidget)) {
                widget = widget.getParentWidget();
            }
            return (ArtifactWidget)widget;
        }
    }

    private class FixVersionConflictAction
    extends AbstractAction
    implements Runnable {
        private ArtifactGraphNode node;
        private Artifact nodeArtif;

        public FixVersionConflictAction(ArtifactGraphNode artifactGraphNode) {
            this.node = artifactGraphNode;
            this.nodeArtif = artifactGraphNode.getArtifact().getArtifact();
            this.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_FixVersionConflict"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FixVersionConflictPanel fixVersionConflictPanel = new FixVersionConflictPanel(DependencyGraphScene.this, this.node);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)fixVersionConflictPanel, NbBundle.getMessage(DependencyGraphScene.class, (String)"TIT_FixConflict"));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == DialogDescriptor.OK_OPTION) {
                FixVersionConflictPanel.FixDescription fixDescription = fixVersionConflictPanel.getResult();
                this.fixDependency(fixDescription);
                this.updateGraph(fixDescription);
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }

        @Override
        public void run() {
            try {
                Utilities.saveChanges((AbstractDocumentModel)DependencyGraphScene.this.model);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fixDependency(FixVersionConflictPanel.FixDescription fixDescription) {
            try {
                DependencyGraphScene.this.model.startTransaction();
                if (fixDescription.isSet && fixDescription.version2Set != null) {
                    Dependency dependency = ModelUtils.checkModelDependency((POMModel)DependencyGraphScene.this.model, (String)this.nodeArtif.getGroupId(), (String)this.nodeArtif.getArtifactId(), (boolean)true);
                    dependency.setVersion(fixDescription.version2Set.toString());
                }
                if (fixDescription.isExclude) {
                    DependencyGraphScene.this.excludeDepFromModel(this.node, fixDescription.exclusionTargets);
                }
            }
            finally {
                DependencyGraphScene.this.model.endTransaction();
            }
        }

        private void updateGraph(FixVersionConflictPanel.FixDescription fixDescription) {
            if (fixDescription.isSet) {
                this.node.getArtifact().getArtifact().setVersion(fixDescription.version2Set.toString());
                Collection collection = DependencyGraphScene.this.findNodeEdges(this.node, false, true);
                for (ArtifactGraphEdge artifactGraphEdge : collection) {
                    EdgeWidget edgeWidget = (EdgeWidget)DependencyGraphScene.this.findWidget(artifactGraphEdge);
                    if (edgeWidget == null) continue;
                    edgeWidget.modelChanged();
                }
                this.node.getWidget().modelChanged();
                if (DependencyGraphScene.this.findEdgesBetween(DependencyGraphScene.this.rootNode, this.node).isEmpty()) {
                    ArtifactGraphEdge artifactGraphEdge = new ArtifactGraphEdge(DependencyGraphScene.this.rootNode.getArtifact(), this.node.getArtifact());
                    artifactGraphEdge.setLevel(1);
                    artifactGraphEdge.setPrimaryPath(true);
                    DependencyGraphScene.this.addEdge(artifactGraphEdge);
                    DependencyGraphScene.this.setEdgeTarget(artifactGraphEdge, this.node);
                    DependencyGraphScene.this.setEdgeSource(artifactGraphEdge, DependencyGraphScene.this.rootNode);
                    this.node.setPrimaryLevel(1);
                    this.node.setArtifactParent(DependencyGraphScene.this.rootNode.getArtifact());
                    DependencyGraphScene.this.rootNode.getArtifact().addChild(this.node.getArtifact());
                    DependencyGraphScene.this.validate();
                }
            }
            if (fixDescription.isExclude) {
                DependencyGraphScene.this.updateGraphAfterExclusion(this.node, fixDescription.exclusionTargets, fixDescription.conflictParents);
            }
        }
    }

    private class ExcludeDepAction
    extends AbstractAction
    implements Runnable {
        private ArtifactGraphNode node;

        public ExcludeDepAction(ArtifactGraphNode artifactGraphNode) {
            this.node = artifactGraphNode;
            this.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_ExcludeDep"));
            this.putValue("ShortDescription", NbBundle.getMessage(DependencyGraphScene.class, (String)"TIP_ExcludeDep"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FixVersionConflictPanel.ExclusionTargets exclusionTargets = new FixVersionConflictPanel.ExclusionTargets(this.node, DependencyGraphScene.findNewest(this.node, true));
            Set<Artifact> set = exclusionTargets.getAll();
            try {
                DependencyGraphScene.this.model.startTransaction();
                DependencyGraphScene.this.excludeDepFromModel(this.node, set);
            }
            finally {
                DependencyGraphScene.this.model.endTransaction();
            }
            HashSet<DependencyNode> hashSet = new HashSet<DependencyNode>();
            for (Artifact artifact : set) {
                hashSet.addAll(exclusionTargets.getConflictParents(artifact));
            }
            DependencyGraphScene.this.updateGraphAfterExclusion(this.node, set, hashSet);
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            try {
                Utilities.saveChanges((AbstractDocumentModel)DependencyGraphScene.this.model);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private class HighlitedZoomToFitAction
    extends AbstractAction {
        public HighlitedZoomToFitAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_ZoomToFit"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collection collection = DependencyGraphScene.this.getNodes();
            ArrayList<ArtifactWidget> arrayList = new ArrayList<ArtifactWidget>();
            ArtifactWidget artifactWidget = null;
            for (ArtifactGraphNode artifactGraphNode : collection) {
                artifactWidget = artifactGraphNode.getWidget();
                int n = artifactWidget.getPaintState();
                if (n == 0 || n == 1) continue;
                arrayList.add(artifactWidget);
            }
            FitToViewLayout fitToViewLayout = DependencyGraphScene.this.getFitToViewLayout();
            fitToViewLayout.setWidgetsToFit(arrayList);
            fitToViewLayout.invokeLayout();
        }
    }

    private class SceneZoomToFitAction
    extends AbstractAction {
        public SceneZoomToFitAction() {
            this.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_ZoomToFit"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FitToViewLayout fitToViewLayout = DependencyGraphScene.this.getFitToViewLayout();
            fitToViewLayout.setWidgetsToFit(null);
            fitToViewLayout.invokeLayout();
        }
    }

    private static class FitToViewLayout
    extends SceneLayout {
        private List<? extends Widget> widgets = null;
        private DependencyGraphScene depScene;

        public FitToViewLayout(DependencyGraphScene dependencyGraphScene) {
            super((Scene)dependencyGraphScene);
            this.depScene = dependencyGraphScene;
        }

        public void setWidgetsToFit(List<? extends Widget> list) {
            this.widgets = list;
        }

        protected void performLayout() {
            Object object2;
            List list;
            Rectangle rectangle = null;
            List list2 = list = this.widgets != null ? this.widgets : this.depScene.getChildren();
            if (list == null) {
                return;
            }
            for (Object object2 : list) {
                if (rectangle == null) {
                    rectangle = object2.convertLocalToScene(object2.getBounds());
                    continue;
                }
                rectangle = rectangle.union(object2.convertLocalToScene(object2.getBounds()));
            }
            if (this.widgets == null) {
                rectangle.grow(5, 5);
            } else {
                rectangle.grow(25, 25);
            }
            Dimension dimension = rectangle.getSize();
            object2 = this.depScene.tc.getScrollPane().getViewportBorderBounds().getSize();
            double d = Math.min((double)object2.width / (double)dimension.width, (double)object2.height / (double)dimension.height);
            if (this.depScene.isAnimated()) {
                if (this.widgets == null) {
                    this.depScene.getSceneAnimator().animateZoomFactor(d);
                } else {
                    CenteredZoomAnimator centeredZoomAnimator = new CenteredZoomAnimator(this.depScene.getSceneAnimator());
                    centeredZoomAnimator.setZoomFactor(d, new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY()));
                }
            } else {
                this.depScene.setZoomFactor(d);
            }
        }
    }

    private class AllActionsProvider
    implements PopupMenuProvider,
    MoveProvider,
    EditProvider,
    SelectProvider {
        private Point moveStart;

        private AllActionsProvider() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point point) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (widget == DependencyGraphScene.this) {
                jPopupMenu.add(DependencyGraphScene.this.sceneZoomToFitAction);
            } else {
                ArtifactGraphNode artifactGraphNode = (ArtifactGraphNode)DependencyGraphScene.this.findObject(widget);
                if (DependencyGraphScene.this.isEditable()) {
                    boolean bl = false;
                    if (DependencyGraphScene.isFixCandidate(artifactGraphNode)) {
                        jPopupMenu.add(new FixVersionConflictAction(artifactGraphNode));
                        bl = true;
                    }
                    if (artifactGraphNode.getPrimaryLevel() > 1) {
                        jPopupMenu.add(new ExcludeDepAction(artifactGraphNode));
                        bl = true;
                    }
                    if (bl) {
                        jPopupMenu.add(new JSeparator());
                    }
                }
                jPopupMenu.add(DependencyGraphScene.this.highlitedZoomToFitAction);
                if (!artifactGraphNode.isRoot()) {
                    Action action = CommonArtifactActions.createViewArtifactDetails((Artifact)artifactGraphNode.getArtifact().getArtifact(), (List)DependencyGraphScene.this.project.getRemoteArtifactRepositories());
                    action.putValue("PANEL_HINT", "grf");
                    action.putValue("Name", NbBundle.getMessage(DependencyGraphScene.class, (String)"ACT_Show_Graph"));
                    jPopupMenu.add(action);
                }
            }
            return jPopupMenu;
        }

        public void movementStarted(Widget widget) {
            widget.bringToFront();
            this.moveStart = widget.getLocation();
        }

        public void movementFinished(Widget widget) {
            Object object;
            Point point = widget.getLocation();
            if (this.moveStart.distance(point) < 5.0 && (object = DependencyGraphScene.this.findObject(widget)) instanceof ArtifactGraphNode) {
                DependencyGraphScene.this.highlightRelated((ArtifactGraphNode)object);
            }
        }

        public Point getOriginalLocation(Widget widget) {
            return widget.getPreferredLocation();
        }

        public void setNewLocation(Widget widget, Point point) {
            widget.setPreferredLocation(point);
        }

        public void edit(Widget widget) {
            if (DependencyGraphScene.this == widget) {
                DependencyGraphScene.this.sceneZoomToFitAction.actionPerformed(null);
            } else {
                DependencyGraphScene.this.highlitedZoomToFitAction.actionPerformed(null);
            }
        }

        public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
            return true;
        }

        public void select(Widget widget, Point point, boolean bl) {
            DependencyGraphScene.this.setSelectedObjects(EMPTY_SELECTION);
            DependencyGraphScene.this.tc.depthHighlight();
        }
    }
}

