/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;

public final class DBForeignKey
extends DBObject<DBTable> {
    private static final String RS_PK_NAME = "PK_NAME";
    private static final String RS_PKCATALOG_NAME = "PKTABLE_CAT";
    private static final String RS_PKSCHEMA_NAME = "PKTABLE_SCHEM";
    private static final String RS_PKTABLE_NAME = "PKTABLE_NAME";
    private static final String RS_PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String RS_FK_NAME = "FK_NAME";
    private static final String RS_FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String RS_UPDATE_RULE = "UPDATE_RULE";
    private static final String RS_DELETE_RULE = "DELETE_RULE";
    private static final String RS_DEFERRABILITY = "DEFERRABILITY";
    private int deferrability;
    private int deleteRule;
    private String fkName;
    private String pkCatalog;
    private String pkName;
    private String pkSchema;
    private String pkTable;
    private int updateRule;
    private List<String> fkColumnNames = new ArrayList<String>();
    private List<String> pkColumnNames = new ArrayList<String>();

    public static Map<String, DBForeignKey> createForeignKeyColumnMap(DBTable table, ResultSet rs) throws SQLException {
        assert (rs != null);
        HashMap<String, DBForeignKey> fkColumns = new HashMap<String, DBForeignKey>();
        while (rs.next()) {
            String fk_name = rs.getString(RS_FK_NAME);
            DBForeignKey fk = (DBForeignKey)fkColumns.get(fk_name);
            if (fk != null) {
                fk.addColumnNames(rs);
                continue;
            }
            fk = new DBForeignKey(rs, fk_name);
            fk.setParentObject(table);
            fkColumns.put(fk.getName(), fk);
        }
        return fkColumns;
    }

    private DBForeignKey(ResultSet rs, String fkName) throws SQLException {
        assert (rs != null);
        this.fkName = fkName;
        this.pkName = rs.getString(RS_PK_NAME);
        this.pkTable = rs.getString(RS_PKTABLE_NAME);
        this.pkSchema = rs.getString(RS_PKSCHEMA_NAME);
        this.pkCatalog = rs.getString(RS_PKCATALOG_NAME);
        this.addColumnNames(rs);
        this.updateRule = rs.getShort(RS_UPDATE_RULE);
        this.deleteRule = rs.getShort(RS_DELETE_RULE);
        this.deferrability = rs.getShort(RS_DEFERRABILITY);
    }

    private void addColumnNames(ResultSet rs) throws SQLException {
        String pkColName = rs.getString(RS_PKCOLUMN_NAME);
        if (!DBForeignKey.isNullString(pkColName)) {
            this.pkColumnNames.add(pkColName);
        }
        String fkColName = rs.getString(RS_FKCOLUMN_NAME);
        if (!DBForeignKey.isNullString(pkColName)) {
            this.fkColumnNames.add(fkColName);
        }
    }

    public boolean contains(DBColumn fkCol) {
        return this.contains(fkCol.getName());
    }

    public boolean contains(String fkColumnName) {
        return this.fkColumnNames.contains(fkColumnName);
    }

    public boolean equals(Object refObj) {
        boolean result;
        if (this == refObj) {
            return true;
        }
        if (!(refObj instanceof DBForeignKey)) {
            return false;
        }
        DBForeignKey ref = (DBForeignKey)refObj;
        boolean bl = this.fkName != null ? this.fkName.equals(ref.fkName) : (result = ref.fkName == null);
        result &= this.pkName != null ? this.pkName.equals(ref.pkName) : ref.pkName == null;
        result &= this.pkTable != null ? this.pkTable.equals(ref.pkTable) : ref.pkTable == null;
        result &= this.pkSchema != null ? this.pkSchema.equals(ref.pkSchema) : ref.pkSchema == null;
        result &= this.pkCatalog != null ? this.pkCatalog.equals(ref.pkCatalog) : ref.pkCatalog == null;
        result &= this.updateRule == ref.updateRule && this.deleteRule == ref.deleteRule && this.deferrability == ref.deferrability;
        result &= this.pkColumnNames != null ? ((Object)this.pkColumnNames).equals(ref.pkColumnNames) : ref.pkColumnNames != null;
        return result &= this.fkColumnNames != null ? ((Object)this.fkColumnNames).equals(ref.fkColumnNames) : ref.fkColumnNames != null;
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.fkColumnNames);
    }

    public String getName() {
        return this.fkName;
    }

    public String getPKCatalog() {
        return this.pkCatalog;
    }

    public List<String> getPKColumnNames() {
        return Collections.unmodifiableList(this.pkColumnNames);
    }

    public String getPKName() {
        return this.pkName;
    }

    public String getPKSchema() {
        return this.pkSchema;
    }

    public String getPKTable() {
        return this.pkTable;
    }

    public int hashCode() {
        int myHash = this.fkName != null ? this.fkName.hashCode() : 0;
        myHash += this.pkName != null ? this.pkName.hashCode() : 0;
        myHash += this.pkTable != null ? this.pkTable.hashCode() : 0;
        myHash += this.pkSchema != null ? this.pkSchema.hashCode() : 0;
        myHash += this.pkCatalog != null ? this.pkCatalog.hashCode() : 0;
        myHash += this.updateRule + this.deleteRule + this.deferrability;
        myHash += this.fkColumnNames != null ? ((Object)this.fkColumnNames).hashCode() : 0;
        return myHash += this.pkColumnNames != null ? ((Object)this.pkColumnNames).hashCode() : 0;
    }

    public boolean references(DBPrimaryKey pk) {
        if (pk == null) {
            return false;
        }
        List<String> targetColNames = pk.getColumnNames();
        DBTable targetTable = (DBTable)pk.getParentObject();
        return this.references(targetTable) && targetColNames.containsAll(this.pkColumnNames) && this.pkColumnNames.containsAll(targetColNames);
    }

    private boolean references(DBTable aTable) {
        return aTable != null ? this.references(aTable.getName(), aTable.getSchema(), aTable.getCatalog()) : false;
    }

    private boolean references(String pkTableName, String pkSchemaName, String pkCatalogName) {
        boolean schemaMatches;
        boolean tableMatches;
        if (pkCatalogName.equals("")) {
            pkCatalogName = null;
        }
        if (pkSchemaName.equals("")) {
            pkSchemaName = null;
        }
        if (pkTableName.equals("")) {
            pkTableName = null;
        }
        boolean bl = pkTableName != null ? pkTableName.equals(this.pkTable) : (tableMatches = this.pkTable == null);
        boolean bl2 = pkSchemaName != null ? pkSchemaName.equals(this.pkSchema) : (schemaMatches = this.pkSchema == null);
        boolean catalogMatches = pkCatalogName != null ? pkCatalogName.equals(this.pkCatalog) : this.pkCatalog == null;
        return tableMatches && schemaMatches && catalogMatches;
    }
}

