/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBMetaDataFactory;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.SQLStatementExecutor;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SQLExecutionHelper {
    private final DataView dataView;
    private final RequestProcessor rp = new RequestProcessor("SQLStatementExecution", 20, true);
    private static final String LIMIT_CLAUSE = " LIMIT ";
    public static final String OFFSET_CLAUSE = " OFFSET ";
    private static final Logger LOGGER = Logger.getLogger(SQLExecutionHelper.class.getName());

    SQLExecutionHelper(DataView dataView) {
        this.dataView = dataView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void initialDataLoad(DataView dv, DatabaseConnection dbConn, SQLExecutionHelper execHelper) throws SQLException {
        boolean isSelect;
        String sql;
        Statement stmt;
        block13: {
            ResultSet resultSet;
            DBMetaDataFactory dbMeta;
            block11: {
                block12: {
                    Connection conn;
                    block9: {
                        block10: {
                            stmt = null;
                            try {
                                conn = DBConnectionFactory.getInstance().getConnection(dbConn);
                                String msg = "";
                                if (conn == null) {
                                    Throwable ex = DBConnectionFactory.getInstance().getLastException();
                                    msg = ex != null ? ex.getMessage() : NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_connection_failure", (Object)dv.getDatabaseConnection());
                                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                                    throw new IllegalStateException(msg);
                                }
                                dbMeta = new DBMetaDataFactory(conn);
                                dv.setLimitSupported(dbMeta.supportsLimit());
                                sql = dv.getSQLString();
                                isSelect = execHelper.isSelectStatement(sql);
                                stmt = execHelper.prepareSQLStatement(conn, sql);
                                execHelper.executeSQLStatement(stmt, sql);
                                if (dv.getUpdateCount() == -1) break block9;
                                if (conn.getAutoCommit()) break block10;
                                conn.commit();
                            }
                            catch (Throwable throwable) {
                                DataViewUtils.closeResources(stmt);
                                throw throwable;
                            }
                        }
                        DataViewUtils.closeResources(stmt);
                        return;
                    }
                    resultSet = null;
                    resultSet = stmt.getResultSet();
                    if (resultSet != null) break block11;
                    if (conn.getAutoCommit()) break block12;
                    conn.commit();
                }
                DataViewUtils.closeResources(resultSet);
                DataViewUtils.closeResources(stmt);
                return;
            }
            Collection<DBTable> tables = dbMeta.generateDBTables(resultSet, sql, isSelect);
            DataViewDBTable dvTable = new DataViewDBTable(tables);
            dv.setDataViewDBTable(dvTable);
            execHelper.loadDataFrom(resultSet);
            break block13;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                DataViewUtils.closeResources(resultSet);
            }
        }
        execHelper.getTotalCount(isSelect, sql, stmt);
        DataViewUtils.closeResources(stmt);
    }

    RequestProcessor.Task executeInsertRow(final String insertSQL, final Object[] insertedRow) {
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_insert");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, ""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                PreparedStatement pstmt = this.conn.prepareStatement(insertSQL);
                try {
                    int pos = 1;
                    for (int i = 0; i < insertedRow.length; ++i) {
                        Object val = insertedRow[i];
                        if (DataViewUtils.isSQLConstantString(val)) continue;
                        int colType = this.dataView.getDataViewDBTable().getColumnType(i);
                        DBReadWriteHelper.setAttributeValue(pstmt, pos++, colType, val);
                    }
                    SQLExecutionHelper.this.executePreparedStatement(pstmt);
                    int rows = this.dataView.getUpdateCount();
                    if (rows != 1) {
                        this.error = true;
                        this.errorMsg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_failure_insert_rows");
                    }
                }
                finally {
                    DataViewUtils.closeResources(pstmt);
                }
            }

            @Override
            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_insert_command"));
            }

            @Override
            protected void executeOnSucess() {
                if (this.dataView.getDataViewPageContext().getTotalRows() < 0) {
                    this.dataView.getDataViewPageContext().setTotalRows(0);
                    this.dataView.getDataViewPageContext().first();
                }
                this.dataView.incrementRowSize(1);
                if (this.dataView.getDataViewPageContext().refreshRequiredOnInsert()) {
                    SQLExecutionHelper.this.executeQuery();
                } else {
                    this.reinstateToolbar();
                }
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
        return task;
    }

    void executeDeleteRow(final DataViewTableUI rsTable) {
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_delete");
        final int[] rows = rsTable.getSelectedRows();
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, ""){

            @Override
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                for (int j = 0; j < rows.length && !this.error && !Thread.currentThread().isInterrupted(); ++j) {
                    this.deleteARow(rsTable.convertRowIndexToModel(rows[j]), rsTable.getModel());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void deleteARow(int rowNum, TableModel tblModel) throws SQLException, DBException {
                ArrayList<Object> values = new ArrayList<Object>();
                ArrayList<Integer> types = new ArrayList<Integer>();
                SQLStatementGenerator generator = this.dataView.getSQLStatementGenerator();
                String deleteStmt = generator.generateDeleteStatement(types, values, rowNum, tblModel);
                PreparedStatement pstmt = this.conn.prepareStatement(deleteStmt);
                try {
                    int pos = 1;
                    for (Object e : values) {
                        DBReadWriteHelper.setAttributeValue(pstmt, pos, (Integer)types.get(pos - 1), e);
                        ++pos;
                    }
                    SQLExecutionHelper.this.executePreparedStatement(pstmt);
                    int rows2 = this.dataView.getUpdateCount();
                    if (rows2 == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_delete");
                    } else if (rows2 > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(pstmt);
                }
            }

            @Override
            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_delete_command"));
            }

            @Override
            protected void executeOnSucess() {
                this.dataView.decrementRowSize(rows.length);
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeUpdateRow(final DataViewTableUI rsTable, final boolean selectedOnly) {
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_update");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, ""){
            private PreparedStatement pstmt;
            Set<Integer> keysToRemove;
            {
                super(x0, x1, x2);
                this.keysToRemove = new HashSet<Integer>();
            }

            @Override
            public void execute() throws SQLException, DBException {
                this.dataView.setEditable(false);
                if (selectedOnly) {
                    this.updateSelected();
                } else {
                    for (Integer key : this.dataView.getUpdatedRowContext().getUpdateKeys()) {
                        if (Thread.currentThread().isInterrupted()) break;
                        this.updateARow(key);
                        this.keysToRemove.add(key);
                    }
                }
            }

            private void updateSelected() throws SQLException, DBException {
                int[] rows = rsTable.getSelectedRows();
                UpdatedRowContext tblContext = this.dataView.getUpdatedRowContext();
                block0: for (int j = 0; j < rows.length && !this.error; ++j) {
                    Set<Integer> keys = tblContext.getUpdateKeys();
                    for (Integer key : keys) {
                        if (Thread.currentThread().isInterrupted()) continue block0;
                        if (key != rows[j]) continue;
                        this.updateARow(key);
                        this.keysToRemove.add(key);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateARow(Integer key) throws SQLException, DBException {
                UpdatedRowContext updatedRowCtx = this.dataView.getUpdatedRowContext();
                SQLStatementGenerator generator = this.dataView.getSQLStatementGenerator();
                ArrayList<Object> values = new ArrayList<Object>();
                ArrayList<Integer> types = new ArrayList<Integer>();
                String updateStmt = generator.generateUpdateStatement(key, updatedRowCtx.getChangedData(key), values, types, rsTable.getModel());
                this.pstmt = this.conn.prepareStatement(updateStmt);
                int pos = 1;
                for (Object e : values) {
                    if (DataViewUtils.isSQLConstantString(e)) continue;
                    DBReadWriteHelper.setAttributeValue(this.pstmt, pos, (Integer)types.get(pos - 1), e);
                    ++pos;
                }
                try {
                    SQLExecutionHelper.this.executePreparedStatement(this.pstmt);
                    int rows = this.dataView.getUpdateCount();
                    if (rows == 0) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_match_to_update");
                    } else if (rows > 1) {
                        this.error = true;
                        this.errorMsg = this.errorMsg + NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_no_unique_row_for_match");
                    }
                }
                finally {
                    DataViewUtils.closeResources(this.pstmt);
                }
            }

            @Override
            public void finished() {
                this.dataView.setEditable(true);
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_update_command"));
            }

            @Override
            protected void executeOnSucess() {
                UpdatedRowContext tblContext = this.dataView.getUpdatedRowContext();
                for (Integer key : this.keysToRemove) {
                    tblContext.removeUpdateForSelectedRow(key);
                }
                this.dataView.syncPageWithTableModel();
                this.reinstateToolbar();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeTruncate() {
        String msg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_truncate_table_progress");
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_truncate");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, msg){
            private PreparedStatement stmt;
            {
                this.stmt = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws SQLException, DBException {
                DBTable dbTable = this.dataView.getDataViewDBTable().geTable(0);
                String truncateSql = "TRUNCATE TABLE " + dbTable.getFullyQualifiedName(true);
                try {
                    this.stmt = this.conn.prepareStatement(truncateSql);
                    SQLExecutionHelper.this.executePreparedStatement(this.stmt);
                }
                catch (SQLException sqe) {
                    LOGGER.log(Level.FINE, "TRUNCATE Not supported...will try DELETE * \n");
                    truncateSql = "DELETE FROM " + dbTable.getFullyQualifiedName(true);
                    this.stmt = this.conn.prepareStatement(truncateSql);
                    SQLExecutionHelper.this.executePreparedStatement(this.stmt);
                }
                finally {
                    DataViewUtils.closeResources(this.stmt);
                }
            }

            @Override
            public void finished() {
                this.commitOrRollback(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_truncate_command"));
            }

            @Override
            protected void executeOnSucess() {
                this.dataView.getDataViewPageContext().setTotalRows(0);
                this.dataView.getDataViewPageContext().first();
                SQLExecutionHelper.this.executeQuery();
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void executeQuery() {
        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executequery");
        SQLStatementExecutor executor = new SQLStatementExecutor(this.dataView, title, this.dataView.getSQLString()){
            private ResultSet rs;
            private Statement stmt;
            boolean lastEditState;
            {
                this.rs = null;
                this.stmt = null;
                this.lastEditState = this.dataView.isEditable();
            }

            @Override
            public void execute() throws SQLException, DBException {
                String sql;
                block8: {
                    this.dataView.setEditable(false);
                    sql = this.dataView.getSQLString();
                    this.stmt = SQLExecutionHelper.this.prepareSQLStatement(this.conn, sql);
                    try {
                        SQLExecutionHelper.this.executeSQLStatement(this.stmt, sql);
                        if (this.dataView.hasResultSet()) {
                            this.rs = this.stmt.getResultSet();
                            SQLExecutionHelper.this.loadDataFrom(this.rs);
                            break block8;
                        }
                        return;
                    }
                    catch (SQLException sqlEx) {
                        String title = NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_error");
                        String msg = NbBundle.getMessage(SQLExecutionHelper.class, (String)"Confirm_Close");
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(sqlEx.getMessage() + "\n" + msg), title, 2, 3);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        if (nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                            this.dataView.removeComponents();
                        }
                        throw sqlEx;
                    }
                    finally {
                        DataViewUtils.closeResources(this.rs);
                    }
                }
                if (this.dataView.getDataViewPageContext().getTotalRows() == -1) {
                    SQLExecutionHelper.this.getTotalCount(SQLExecutionHelper.this.isSelectStatement(sql), sql, this.stmt);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished() {
                DataViewUtils.closeResources(this.stmt);
                this.dataView.setEditable(this.lastEditState);
                DataView dataView = this.dataView;
                synchronized (dataView) {
                    if (this.error) {
                        this.dataView.setErrorStatusText(this.ex);
                    }
                    this.dataView.getUpdatedRowContext().removeAllUpdates();
                    this.dataView.resetToolbar(this.error);
                    this.dataView.setRowsInTableModel();
                }
            }
        };
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    void loadDataFrom(ResultSet rs) throws SQLException {
        if (rs == null) {
            return;
        }
        int pageSize = this.dataView.getDataViewPageContext().getPageSize();
        int startFrom = 0;
        if (!this.dataView.isLimitSupported() || this.isLimitUsedInSelect(this.dataView.getSQLString())) {
            startFrom = this.dataView.getDataViewPageContext().getCurrentPos() - 1;
        }
        DataViewDBTable tblMeta = this.dataView.getDataViewDBTable();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int colCnt = tblMeta.getColumnCount();
        try {
            boolean lastRowPicked = rs.next();
            for (int curRowPos = 1; lastRowPicked && curRowPos < startFrom + 1; ++curRowPos) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                lastRowPicked = rs.next();
            }
            int rowCnt = 0;
            boolean hasNext = false;
            if (!lastRowPicked) {
                hasNext = rs.next();
            }
            while ((pageSize == -1 || pageSize > rowCnt) && (lastRowPicked || hasNext)) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Object[] row = new Object[colCnt];
                for (int i = 0; i < colCnt; ++i) {
                    row[i] = DBReadWriteHelper.readResultSet(rs, tblMeta.getColumn(i), i + 1);
                }
                rows.add(row);
                ++rowCnt;
                if (lastRowPicked) {
                    lastRowPicked = false;
                }
                try {
                    hasNext = rs.next();
                }
                catch (SQLException x) {
                    LOGGER.log(Level.INFO, "Failed to forward to next record, cause: " + x.getLocalizedMessage(), x);
                    hasNext = false;
                }
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Failed to set up table model.", e);
            throw e;
        }
        finally {
            this.dataView.getDataViewPageContext().setCurrentRows(rows);
        }
    }

    void setTotalCount(ResultSet countresultSet) {
        try {
            if (countresultSet == null) {
                this.dataView.getDataViewPageContext().setTotalRows(-1);
            } else if (countresultSet.next()) {
                int count = countresultSet.getInt(1);
                this.dataView.getDataViewPageContext().setTotalRows(count);
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, "Could not get total row count " + ex);
        }
    }

    private String appendLimitIfRequired(String sql) {
        if (this.dataView.isLimitSupported() && this.isSelectStatement(sql) && !this.isLimitUsedInSelect(sql)) {
            sql = sql + LIMIT_CLAUSE + this.dataView.getDataViewPageContext().getPageSize();
            sql = sql + OFFSET_CLAUSE + (this.dataView.getDataViewPageContext().getCurrentPos() - 1);
        }
        return sql;
    }

    private Statement prepareSQLStatement(Connection conn, String sql) throws SQLException {
        Statement stmt;
        block9: {
            stmt = null;
            if (sql.startsWith("{")) {
                stmt = conn.prepareCall(sql);
            } else if (this.isSelectStatement(sql)) {
                stmt = conn.createStatement(1003, 1007);
                int pageSize = this.dataView.getDataViewPageContext().getPageSize();
                try {
                    stmt.setFetchSize(pageSize);
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "Unable to set Fetch size" + e);
                }
                try {
                    if (this.dataView.isLimitSupported() && sql.toUpperCase().indexOf(LIMIT_CLAUSE) == -1) {
                        stmt.setMaxRows(pageSize);
                        break block9;
                    }
                    stmt.setMaxRows(this.dataView.getDataViewPageContext().getCurrentPos() + pageSize);
                }
                catch (SQLException exc) {
                    LOGGER.log(Level.WARNING, "Unable to set Max row size" + exc);
                }
            } else {
                stmt = conn.createStatement();
            }
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQLStatement(Statement stmt, String sql) throws SQLException {
        LOGGER.log(Level.FINE, "Statement: " + sql);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"LBL_sql_executestmt") + sql);
        long startTime = System.currentTimeMillis();
        boolean isResultSet = false;
        if (stmt instanceof PreparedStatement) {
            isResultSet = ((PreparedStatement)stmt).execute();
        } else {
            try {
                isResultSet = stmt.execute(this.appendLimitIfRequired(sql));
            }
            catch (SQLException sqlExc) {
                if (sqlExc.getErrorCode() == 1064 && sqlExc.getSQLState().equals("37000")) {
                    isResultSet = stmt.execute(sql);
                }
                LOGGER.log(Level.SEVERE, "Failed to execute SQL Statement" + sqlExc);
                throw sqlExc;
            }
        }
        long executionTime = System.currentTimeMillis() - startTime;
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.setHasResultSet(isResultSet);
            this.dataView.setUpdateCount(stmt.getUpdateCount());
            this.dataView.setExecutionTime(executionTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePreparedStatement(PreparedStatement stmt) throws SQLException {
        long startTime = System.currentTimeMillis();
        boolean isResultSet = stmt.execute();
        long executionTime = System.currentTimeMillis() - startTime;
        String execTimeStr = SQLExecutionHelper.millisecondsToSeconds(executionTime);
        this.dataView.setInfoStatusText(NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_execution_success", (Object)execTimeStr));
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.setHasResultSet(isResultSet);
            this.dataView.setUpdateCount(stmt.getUpdateCount());
            this.dataView.setExecutionTime(executionTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getTotalCount(boolean isSelect, String sql, Statement stmt) {
        if (isSelect && this.isLimitUsedInSelect(sql)) {
            try {
                String lmtStr = sql.toUpperCase().split(LIMIT_CLAUSE)[1].trim();
                int rCnt = Integer.parseInt(lmtStr.split(" ")[0]);
                this.dataView.getDataViewPageContext().setTotalRows(rCnt);
                return;
            }
            catch (NumberFormatException nex) {
                // empty catch block
            }
        }
        ResultSet cntResultSet = null;
        if (isSelect) {
            try {
                cntResultSet = stmt.executeQuery(SQLStatementGenerator.getCountAsSubQuery(sql));
                this.setTotalCount(cntResultSet);
            }
            catch (SQLException e) {
                DataViewUtils.closeResources(cntResultSet);
                catch (Throwable throwable) {
                    DataViewUtils.closeResources(cntResultSet);
                    throw throwable;
                }
            }
            DataViewUtils.closeResources(cntResultSet);
            return;
        }
        if (isSelect && !this.isGroupByUsedInSelect(sql)) {
            cntResultSet = null;
            try {
                cntResultSet = stmt.executeQuery(SQLStatementGenerator.getCountSQLQuery(sql));
                this.setTotalCount(cntResultSet);
                return;
            }
            catch (SQLException e) {
            }
            finally {
                DataViewUtils.closeResources(cntResultSet);
            }
        }
        cntResultSet = null;
        int totalRows = 0;
        try {
            int fetchSize = this.dataView.getDataViewPageContext().getPageSize();
            try {
                fetchSize = stmt.getFetchSize();
                stmt.setFetchSize(20000);
            }
            catch (SQLException sqe) {
                // empty catch block
            }
            cntResultSet = stmt.executeQuery(sql);
            while (cntResultSet.next()) {
                ++totalRows;
            }
            this.dataView.getDataViewPageContext().setTotalRows(totalRows);
            try {
                stmt.setFetchSize(fetchSize);
            }
            catch (SQLException sqe) {
                // empty catch block
            }
            return;
        }
        catch (SQLException e) {
        }
        finally {
            DataViewUtils.closeResources(cntResultSet);
        }
        this.setTotalCount(null);
    }

    private boolean isSelectStatement(String queryString) {
        return queryString.trim().toUpperCase().startsWith("SELECT") && queryString.trim().toUpperCase().indexOf("INTO") == -1;
    }

    private boolean isLimitUsedInSelect(String sql) {
        return sql.toUpperCase().indexOf(LIMIT_CLAUSE) != -1;
    }

    private boolean isGroupByUsedInSelect(String sql) {
        return sql.toUpperCase().indexOf(" GROUP BY ") != -1 || sql.toUpperCase().indexOf(" COUNT(*) ") != -1;
    }

    static String millisecondsToSeconds(long ms) {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(3);
        return fmt.format((double)ms / 1000.0);
    }
}

