/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wls;

import java.lang.reflect.Method;
import java.security.AccessController;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.server.wls.WebLogic_9_Platform;
import org.eclipse.persistence.services.mbean.MBeanDevelopmentServices;
import org.eclipse.persistence.services.weblogic.MBeanWebLogicRuntimeServices;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;

public class WebLogic_10_Platform
extends WebLogic_9_Platform {
    private static final String JMX_JNDI_RUNTIME_REGISTER = "java:comp/env/jmx/runtime";
    private static final String JMX_JNDI_RUNTIME_UNREGISTER = "java:comp/jmx/runtime";
    private static final String JMX_REGISTRATION_PREFIX = "TopLink:Name=";
    public static final String JMX_REGISTER_DEV_MBEAN_PROPERTY = "eclipselink.register.dev.mbean";
    public static final String JMX_REGISTER_RUN_MBEAN_PROPERTY = "eclipselink.register.run.mbean";
    public static final String WEBLOGIC_MODULENAME_PROPERTY = "eclipselink.weblogic.moduleName";
    public static final String WEBLOGIC_APPLICATIONNAME_PROPERTY = "eclipselink.weblogic.applicationName";
    protected boolean shouldRegisterDevelopmentBean = System.getProperty("eclipselink.register.dev.mbean") != null;
    protected boolean shouldRegisterRuntimeBean = System.getProperty("eclipselink.register.run.mbean") != null;
    private MBeanServer wlsMBeanServer = null;
    private ObjectName wlsThreadPoolRuntime = null;
    private static final String WLS_MODULE_ENV_CONTEXT_LOOKUP = "java:comp/env/jmx/runtime";
    private static final String WLS_NON_MODULE_CONTEXT_LOOKUP = "java:comp/jmx/runtime";
    private static final String WLS_SERVICE_KEY = "com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String WLS_SERVER_RUNTIME = "ServerRuntime";
    private static final String WLS_THREADPOOL_RUNTIME = "ThreadPoolRuntime";
    private static final String WLS_EXECUTE_THREAD_GET_METHOD_NAME = "getExecuteThread";
    private static final String WLS_APPLICATION_NAME_GET_METHOD_NAME = "getApplicationName";
    private static final String WLS_MODULE_NAME_GET_METHOD_NAME = "getModuleName";
    private static final String WLS_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX = "annotation: ";
    private String moduleName = null;
    private String applicationName = null;
    private MBeanWebLogicRuntimeServices runtimeServicesMBean = null;

    public WebLogic_10_Platform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void serverSpecificRegisterMBean() {
        block31: {
            this.initializeApplicationNameAndModuleName();
            MBeanServer mBeanServerRuntime = null;
            ObjectName name = null;
            String sessionName = this.getMBeanSessionName();
            InitialContext initialContext = null;
            if (null != sessionName && (this.shouldRegisterDevelopmentBean || this.shouldRegisterRuntimeBean)) {
                block30: {
                    initialContext = new InitialContext();
                    mBeanServerRuntime = (MBeanServer)initialContext.lookup("java:comp/env/jmx/runtime");
                    if (this.shouldRegisterDevelopmentBean) {
                        try {
                            name = new ObjectName("TopLink:Name=Development-" + sessionName + ",Type=Configuration");
                        }
                        catch (MalformedObjectNameException mne) {
                            AbstractSessionLog.getLog().log(6, "problem_registering_mbean", mne);
                        }
                        catch (Exception exception) {
                            AbstractSessionLog.getLog().log(6, "problem_registering_mbean", exception);
                        }
                        MBeanDevelopmentServices mbean = new MBeanDevelopmentServices(this.getDatabaseSession());
                        ObjectInstance info = null;
                        try {
                            info = mBeanServerRuntime.registerMBean(mbean, name);
                        }
                        catch (InstanceAlreadyExistsException iaee) {
                            AbstractSessionLog.getLog().log(6, "problem_registering_mbean", iaee);
                        }
                        catch (MBeanRegistrationException registrationProblem) {
                            AbstractSessionLog.getLog().log(6, "problem_registering_mbean", registrationProblem);
                        }
                        catch (Exception e) {
                            AbstractSessionLog.getLog().log(6, "problem_registering_mbean", e);
                        }
                        AbstractSessionLog.getLog().log(1, "registered_mbean", info);
                    }
                    if (!this.shouldRegisterRuntimeBean) break block30;
                    try {
                        name = new ObjectName("TopLink:Name=Session(" + sessionName + ")");
                    }
                    catch (MalformedObjectNameException mne) {
                        AbstractSessionLog.getLog().log(6, "problem_registering_mbean", mne);
                    }
                    catch (Exception exception) {
                        AbstractSessionLog.getLog().log(6, "problem_registering_mbean", exception);
                    }
                    MBeanWebLogicRuntimeServices runtimeServices = new MBeanWebLogicRuntimeServices((Session)((AbstractSession)((Object)this.getDatabaseSession())));
                    ObjectInstance runtimeInstance = null;
                    try {
                        runtimeInstance = mBeanServerRuntime.registerMBean(runtimeServices, name);
                        this.runtimeServicesMBean = runtimeServices;
                    }
                    catch (InstanceAlreadyExistsException iaee) {
                        AbstractSessionLog.getLog().log(6, "problem_registering_mbean", iaee);
                    }
                    catch (MBeanRegistrationException registrationProblem) {
                        AbstractSessionLog.getLog().log(6, "problem_registering_mbean", registrationProblem);
                    }
                    catch (Exception e) {
                        AbstractSessionLog.getLog().log(6, "problem_registering_mbean", e);
                    }
                    AbstractSessionLog.getLog().log(1, "registered_mbean", runtimeInstance);
                }
                Object var9_20 = null;
                try {
                    mBeanServerRuntime = null;
                    if (null != initialContext) {
                        initialContext.close();
                    }
                    break block31;
                }
                catch (NamingException ne2) {}
                break block31;
                {
                    catch (NamingException ne) {
                        AbstractSessionLog.getLog().log(6, "failed_to_find_mbean_server", ne);
                        Object var9_21 = null;
                        try {
                            mBeanServerRuntime = null;
                            if (null != initialContext) {
                                initialContext.close();
                            }
                            break block31;
                        }
                        catch (NamingException ne2) {}
                        break block31;
                    }
                    catch (Exception exception) {
                        AbstractSessionLog.getLog().log(6, "problem_registering_mbean", exception);
                        Object var9_22 = null;
                        try {
                            mBeanServerRuntime = null;
                            if (null != initialContext) {
                                initialContext.close();
                            }
                            break block31;
                        }
                        catch (NamingException ne2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_23 = null;
                    try {
                        mBeanServerRuntime = null;
                        if (null != initialContext) {
                            initialContext.close();
                        }
                    }
                    catch (NamingException ne2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void serverSpecificUnregisterMBean() {
        block29: {
            MBeanServer mBeanServerRuntime = null;
            ObjectName name = null;
            String sessionName = this.getMBeanSessionName();
            InitialContext initialContext = null;
            if (null != sessionName && (this.shouldRegisterDevelopmentBean || this.shouldRegisterRuntimeBean)) {
                initialContext = new InitialContext();
                mBeanServerRuntime = (MBeanServer)initialContext.lookup("java:comp/jmx/runtime");
                if (this.shouldRegisterDevelopmentBean) {
                    try {
                        name = new ObjectName("TopLink:Name=Development_" + sessionName + ",Type=Configuration");
                    }
                    catch (MalformedObjectNameException mne) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", mne);
                    }
                    catch (Exception exception) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", exception);
                    }
                    AbstractSessionLog.getLog().log(1, "unregistering_mbean", name);
                    try {
                        mBeanServerRuntime.unregisterMBean(name);
                    }
                    catch (InstanceNotFoundException inf) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", inf);
                    }
                    catch (MBeanRegistrationException mbre) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", mbre);
                    }
                }
                if (this.shouldRegisterRuntimeBean) {
                    try {
                        name = new ObjectName("TopLink:Name=Session(" + sessionName + ")");
                    }
                    catch (MalformedObjectNameException mne) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", mne);
                    }
                    catch (Exception exception) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", exception);
                    }
                    AbstractSessionLog.getLog().log(1, "unregistering_mbean", name);
                    try {
                        mBeanServerRuntime.unregisterMBean(name);
                    }
                    catch (InstanceNotFoundException inf) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", inf);
                    }
                    catch (MBeanRegistrationException registrationProblem) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", registrationProblem);
                    }
                }
                Object var7_16 = null;
                this.runtimeServicesMBean = null;
                try {
                    mBeanServerRuntime = null;
                    if (null != initialContext) {
                        initialContext.close();
                    }
                    break block29;
                }
                catch (NamingException ne2) {}
                break block29;
                {
                    catch (NamingException ne) {
                        AbstractSessionLog.getLog().log(6, "failed_to_find_mbean_server", ne);
                        Object var7_17 = null;
                        this.runtimeServicesMBean = null;
                        try {
                            mBeanServerRuntime = null;
                            if (null != initialContext) {
                                initialContext.close();
                            }
                            break block29;
                        }
                        catch (NamingException ne2) {}
                        break block29;
                    }
                    catch (Exception exception) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", exception);
                        Object var7_18 = null;
                        this.runtimeServicesMBean = null;
                        try {
                            mBeanServerRuntime = null;
                            if (null != initialContext) {
                                initialContext.close();
                            }
                            break block29;
                        }
                        catch (NamingException ne2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_19 = null;
                    this.runtimeServicesMBean = null;
                    try {
                        mBeanServerRuntime = null;
                        if (null != initialContext) {
                            initialContext.close();
                        }
                    }
                    catch (NamingException ne2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private void initializeApplicationNameAndModuleName() {
        String jpaModuleName = (String)this.getDatabaseSession().getProperty(WEBLOGIC_MODULENAME_PROPERTY);
        String jpaApplicationName = (String)this.getDatabaseSession().getProperty(WEBLOGIC_APPLICATIONNAME_PROPERTY);
        this.moduleName = jpaModuleName != null ? jpaModuleName : (null != (jpaModuleName = this.getNameFromWeblogic(WLS_MODULE_NAME_GET_METHOD_NAME)) && jpaModuleName.indexOf("@") != -1 ? jpaModuleName.substring(jpaModuleName.indexOf("@") + 1) : jpaModuleName);
        if (jpaApplicationName != null) {
            this.applicationName = jpaApplicationName;
        } else {
            jpaApplicationName = this.getNameFromWeblogic(WLS_APPLICATION_NAME_GET_METHOD_NAME);
            if (null == jpaApplicationName) {
                jpaApplicationName = super.getApplicationName();
            }
            this.applicationName = null != jpaApplicationName && jpaApplicationName.indexOf("@") > -1 ? jpaApplicationName.substring(jpaApplicationName.indexOf("@") + 1) : jpaApplicationName;
        }
        if (null == this.applicationName) {
            this.applicationName = DEFAULT_SERVER_NAME_AND_VERSION;
        }
        if (null == this.moduleName) {
            this.moduleName = DEFAULT_SERVER_NAME_AND_VERSION;
        }
        AbstractSessionLog.getLog().log(1, "mbean_get_application_name", this.getDatabaseSession().getName(), this.applicationName);
        AbstractSessionLog.getLog().log(1, "mbean_get_module_name", this.getDatabaseSession().getName(), this.moduleName);
    }

    private String getNameFromWeblogic(String getMethodName) {
        Object classLoaderOrString = null;
        Object executeThread = this.getExecuteThreadFromMBean();
        if (executeThread != null) {
            try {
                Method getMethod = PrivilegedAccessHelper.getPublicMethod(executeThread.getClass(), getMethodName, new Class[0], false);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    AccessController.doPrivileged(new PrivilegedMethodInvoker(getMethod, executeThread, null));
                } else {
                    classLoaderOrString = PrivilegedAccessHelper.invokeMethod(getMethod, executeThread);
                }
                if (classLoaderOrString instanceof ClassLoader) {
                    String jpaModuleNameRoot = ((ClassLoader)classLoaderOrString).toString();
                    classLoaderOrString = jpaModuleNameRoot.substring(jpaModuleNameRoot.indexOf(WLS_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX) + WLS_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX.length());
                }
            }
            catch (Exception ex) {
                AbstractSessionLog.getLog().log(6, "problem_with_reflective_weblogic_call_mbean", ex, getMethodName);
            }
        }
        return (String)classLoaderOrString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object getExecuteThreadFromMBean() {
        block23: {
            if (this.wlsMBeanServer == null) {
                InitialContext initialContext = null;
                initialContext = new InitialContext();
                try {
                    this.wlsMBeanServer = (MBeanServer)initialContext.lookup("java:comp/env/jmx/runtime");
                }
                catch (NamingException e) {
                    try {
                        this.wlsMBeanServer = (MBeanServer)initialContext.lookup("java:comp/jmx/runtime");
                    }
                    catch (NamingException ne) {
                        AbstractSessionLog.getLog().log(6, "jmx_mbean_runtime_services_mbeanserver_lookup_failed", ne);
                    }
                }
                Object var5_8 = null;
                try {
                    if (null != initialContext) {
                        initialContext.close();
                    }
                    break block23;
                }
                catch (NamingException ne) {}
                break block23;
                {
                    catch (NamingException nex) {
                        AbstractSessionLog.getLog().log(6, "problem_unregistering_mbean", nex);
                        Object var5_9 = null;
                        try {
                            if (null != initialContext) {
                                initialContext.close();
                            }
                            break block23;
                        }
                        catch (NamingException ne) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    try {
                        if (null != initialContext) {
                            initialContext.close();
                        }
                    }
                    catch (NamingException ne) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (this.wlsMBeanServer != null) {
            if (this.wlsThreadPoolRuntime == null) {
                try {
                    ObjectName service = new ObjectName(WLS_SERVICE_KEY);
                    ObjectName serverRuntime = (ObjectName)this.wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                    this.wlsThreadPoolRuntime = (ObjectName)this.wlsMBeanServer.getAttribute(serverRuntime, WLS_THREADPOOL_RUNTIME);
                }
                catch (Exception ex) {
                    AbstractSessionLog.getLog().log(6, "jmx_mbean_runtime_services_threadpool_initialize_failed", ex);
                }
            }
            if (this.wlsThreadPoolRuntime != null) {
                try {
                    return this.wlsMBeanServer.invoke(this.wlsThreadPoolRuntime, WLS_EXECUTE_THREAD_GET_METHOD_NAME, new Object[]{Thread.currentThread().getName()}, new String[]{String.class.getName()});
                }
                catch (Exception ex) {
                    AbstractSessionLog.getLog().log(6, "jmx_mbean_runtime_services_get_executethreadruntime_object_failed", ex);
                }
            }
        }
        return null;
    }

    private String getMBeanSessionName() {
        if (null != this.getDatabaseSession() && null != this.getDatabaseSession().getName()) {
            return this.getDatabaseSession().getName().replaceAll("[=,:]", "_");
        }
        AbstractSessionLog.getLog().log(6, "session_key_for_mbean_name_is_null");
        return null;
    }
}

