/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import com.kenai.jffi.ClosureManager;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyClass;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.InvalidMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.BoundedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.Factory;
import org.jruby.ext.ffi.jffi.Function;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CallbackManager
extends org.jruby.ext.ffi.CallbackManager {
    private static final int LONG_SIZE = Platform.getPlatform().longSize();
    private static final String CALLBACK_ID = "ffi_callback";

    public static final CallbackManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static RubyClass createCallbackClass(Ruby runtime2, RubyModule module) {
        RubyClass cbClass = module.defineClassUnder("Callback", module.fastGetClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cbClass.defineAnnotatedMethods(Callback.class);
        cbClass.defineAnnotatedConstants(Callback.class);
        return cbClass;
    }

    public final Pointer getCallback(Ruby runtime2, CallbackInfo cbInfo, Object proc2) {
        return proc2 instanceof RubyObject ? this.getCallback(runtime2, cbInfo, (RubyObject)proc2) : this.newCallback(runtime2, cbInfo, proc2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Pointer getCallback(Ruby runtime2, CallbackInfo cbInfo, RubyObject proc2) {
        if (proc2 instanceof Function) {
            return (Function)proc2;
        }
        RubyObject rubyObject = proc2;
        synchronized (rubyObject) {
            Map m;
            Callback cb;
            Object existing = proc2.fastGetInternalVariable(CALLBACK_ID);
            if (existing instanceof Callback && ((Callback)existing).cbInfo == cbInfo) {
                return (Callback)existing;
            }
            if (existing instanceof Map && (cb = (Callback)(m = (Map)existing).get(proc2)) != null) {
                return cb;
            }
            Callback cb2 = this.newCallback(runtime2, cbInfo, proc2);
            if (existing == null) {
                proc2.fastSetInternalVariable(CALLBACK_ID, cb2);
            } else {
                Map<CallbackInfo, Callback> m2 = existing instanceof Map ? (Map<CallbackInfo, Callback>)existing : Collections.synchronizedMap(new WeakHashMap());
                m2.put(cbInfo, cb2);
                m2.put(((Callback)existing).cbInfo, (Callback)existing);
                proc2.fastSetInternalVariable(CALLBACK_ID, m2);
            }
            return cb2;
        }
    }

    final Callback getCallback(Ruby runtime2, CallbackInfo cbInfo, Block proc2) {
        return this.newCallback(runtime2, cbInfo, proc2);
    }

    private final Callback newCallback(Ruby runtime2, CallbackInfo cbInfo, Object proc2) {
        ClosureInfo info = this.getClosureInfo(runtime2, cbInfo);
        WeakRefCallbackProxy cbProxy = new WeakRefCallbackProxy(runtime2, info, proc2);
        Closure.Handle handle = ClosureManager.getInstance().newClosure(cbProxy, info.callContext);
        return new Callback(runtime2, handle, cbInfo);
    }

    private final ClosureInfo getClosureInfo(Ruby runtime2, CallbackInfo cbInfo) {
        Object info = cbInfo.getProviderCallbackInfo();
        if (info != null && info instanceof ClosureInfo) {
            return (ClosureInfo)info;
        }
        info = this.newClosureInfo(runtime2, cbInfo);
        cbInfo.setProviderCallbackInfo(info);
        return (ClosureInfo)info;
    }

    private final ClosureInfo newClosureInfo(Ruby runtime2, CallbackInfo cbInfo) {
        return new ClosureInfo(runtime2, cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT);
    }

    final CallbackMemoryIO newClosure(Ruby runtime2, Type returnType, Type[] parameterTypes, Object proc2, CallingConvention convention) {
        ClosureInfo info = new ClosureInfo(runtime2, returnType, parameterTypes, convention);
        CallbackProxy cbProxy = new CallbackProxy(runtime2, info, proc2);
        Closure.Handle handle = ClosureManager.getInstance().newClosure(cbProxy, info.callContext);
        return new CallbackMemoryIO(runtime2, handle);
    }

    private static final long longValue(IRubyObject value2) {
        if (value2 instanceof RubyNumeric) {
            return ((RubyNumeric)value2).getLongValue();
        }
        if (value2.isNil()) {
            return 0L;
        }
        return 0L;
    }

    private static final long addressValue(IRubyObject value2) {
        if (value2 instanceof RubyNumeric) {
            return ((RubyNumeric)value2).getLongValue();
        }
        if (value2 instanceof Pointer) {
            return ((Pointer)value2).getAddress();
        }
        if (value2.isNil()) {
            return 0L;
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void setReturnValue(Ruby runtime2, Type type2, Closure.Buffer buffer, IRubyObject value2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: {
                    return;
                }
                case CHAR: {
                    buffer.setByteReturn((byte)CallbackManager.longValue(value2));
                    return;
                }
                case UCHAR: {
                    buffer.setByteReturn((byte)CallbackManager.longValue(value2));
                    return;
                }
                case SHORT: {
                    buffer.setShortReturn((short)CallbackManager.longValue(value2));
                    return;
                }
                case USHORT: {
                    buffer.setShortReturn((short)CallbackManager.longValue(value2));
                    return;
                }
                case INT: {
                    buffer.setIntReturn((int)CallbackManager.longValue(value2));
                    return;
                }
                case UINT: {
                    buffer.setIntReturn((int)CallbackManager.longValue(value2));
                    return;
                }
                case LONG_LONG: {
                    buffer.setLongReturn(Util.int64Value(value2));
                    return;
                }
                case ULONG_LONG: {
                    buffer.setLongReturn(Util.uint64Value(value2));
                    return;
                }
                case LONG: {
                    if (LONG_SIZE == 32) {
                        buffer.setIntReturn((int)CallbackManager.longValue(value2));
                        return;
                    }
                    buffer.setLongReturn(Util.int64Value(value2));
                    return;
                }
                case ULONG: {
                    if (LONG_SIZE == 32) {
                        buffer.setIntReturn((int)CallbackManager.longValue(value2));
                        return;
                    }
                    buffer.setLongReturn(Util.uint64Value(value2));
                    return;
                }
                case FLOAT: {
                    buffer.setFloatReturn((float)RubyNumeric.num2dbl(value2));
                    return;
                }
                case DOUBLE: {
                    buffer.setDoubleReturn(RubyNumeric.num2dbl(value2));
                    return;
                }
                case POINTER: {
                    buffer.setAddressReturn(CallbackManager.addressValue(value2));
                    return;
                }
                case BOOL: {
                    buffer.setIntReturn(value2.isTrue() ? 1 : 0);
                    return;
                }
            }
            return;
        }
        if (type2 instanceof CallbackInfo) {
            if (!(value2 instanceof RubyProc) && !value2.respondsTo("call")) {
                buffer.setAddressReturn(0L);
                throw runtime2.newTypeError("invalid callback return value, expected Proc or callable object");
            }
            Pointer cb = Factory.getInstance().getCallbackManager().getCallback(runtime2, (CallbackInfo)type2, value2);
            buffer.setAddressReturn(CallbackManager.addressValue(cb));
            return;
        }
        if (!(type2 instanceof StructByValue)) {
            buffer.setLongReturn(0L);
            throw runtime2.newRuntimeError("unsupported return type from struct: " + type2);
        }
        if (!(value2 instanceof Struct)) {
            if (!value2.isNil()) throw runtime2.newTypeError(value2, runtime2.fastGetModule("FFI").fastGetClass("Struct"));
            buffer.setStructReturn(new byte[type2.getNativeSize()], 0);
            return;
        }
        Struct s = (Struct)value2;
        MemoryIO memory = s.getMemory().getMemoryIO();
        if (memory instanceof DirectMemoryIO) {
            long address2 = ((DirectMemoryIO)memory).getAddress();
            if (address2 != 0L) {
                buffer.setStructReturn(address2);
                return;
            }
            buffer.setStructReturn(new byte[type2.getNativeSize()], 0);
            return;
        }
        if (!(memory instanceof ArrayMemoryIO)) throw runtime2.newRuntimeError("struct return value has illegal backing memory");
        ArrayMemoryIO arrayMemory = (ArrayMemoryIO)memory;
        if (arrayMemory.arrayLength() < type2.getNativeSize()) {
            throw runtime2.newRuntimeError("size of struct returned from callback too small");
        }
        buffer.setStructReturn(arrayMemory.array(), arrayMemory.arrayOffset());
    }

    private static final IRubyObject fromNative(Ruby runtime2, Type type2, Closure.Buffer buffer, int index2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: {
                    return runtime2.getNil();
                }
                case CHAR: {
                    return Util.newSigned8(runtime2, buffer.getByte(index2));
                }
                case UCHAR: {
                    return Util.newUnsigned8(runtime2, buffer.getByte(index2));
                }
                case SHORT: {
                    return Util.newSigned16(runtime2, buffer.getShort(index2));
                }
                case USHORT: {
                    return Util.newUnsigned16(runtime2, buffer.getShort(index2));
                }
                case INT: {
                    return Util.newSigned32(runtime2, buffer.getInt(index2));
                }
                case UINT: {
                    return Util.newUnsigned32(runtime2, buffer.getInt(index2));
                }
                case LONG_LONG: {
                    return Util.newSigned64(runtime2, buffer.getLong(index2));
                }
                case ULONG_LONG: {
                    return Util.newUnsigned64(runtime2, buffer.getLong(index2));
                }
                case LONG: {
                    return LONG_SIZE == 32 ? Util.newSigned32(runtime2, buffer.getInt(index2)) : Util.newSigned64(runtime2, buffer.getLong(index2));
                }
                case ULONG: {
                    return LONG_SIZE == 32 ? Util.newUnsigned32(runtime2, buffer.getInt(index2)) : Util.newUnsigned64(runtime2, buffer.getLong(index2));
                }
                case FLOAT: {
                    return runtime2.newFloat(buffer.getFloat(index2));
                }
                case DOUBLE: {
                    return runtime2.newFloat(buffer.getDouble(index2));
                }
                case POINTER: {
                    return new Pointer(runtime2, NativeMemoryIO.wrap(runtime2, buffer.getAddress(index2)));
                }
                case STRING: {
                    return CallbackManager.getStringParameter(runtime2, buffer, index2);
                }
                case BOOL: {
                    return runtime2.newBoolean(buffer.getByte(index2) != 0);
                }
            }
            throw runtime2.newTypeError("invalid callback parameter type " + type2);
        }
        if (type2 instanceof CallbackInfo) {
            CallbackInfo cbInfo = (CallbackInfo)type2;
            long address2 = buffer.getAddress(index2);
            return address2 != 0L ? new Function(runtime2, cbInfo.getMetaClass(), new CodeMemoryIO(runtime2, address2), cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT, runtime2.getNil()) : runtime2.getNil();
        }
        if (type2 instanceof StructByValue) {
            StructByValue sbv = (StructByValue)type2;
            long address3 = buffer.getStruct(index2);
            DirectMemoryIO memory = address3 != 0L ? new BoundedNativeMemoryIO(runtime2, address3, type2.getNativeSize()) : new NullMemoryIO(runtime2);
            return sbv.getStructClass().newInstance(runtime2.getCurrentContext(), new IRubyObject[]{new Pointer(runtime2, memory)}, Block.NULL_BLOCK);
        }
        throw runtime2.newTypeError("unsupported callback parameter type: " + type2);
    }

    private static final IRubyObject getStringParameter(Ruby runtime2, Closure.Buffer buffer, int index2) {
        return FFIUtil.getString(runtime2, buffer.getAddress(index2));
    }

    private static final boolean isReturnTypeValid(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: 
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case LONG_LONG: 
                case ULONG_LONG: 
                case LONG: 
                case ULONG: 
                case FLOAT: 
                case DOUBLE: 
                case POINTER: 
                case BOOL: {
                    return true;
                }
            }
        } else {
            if (type2 instanceof CallbackInfo) {
                return true;
            }
            if (type2 instanceof StructByValue) {
                return true;
            }
        }
        return false;
    }

    private static final boolean isParameterTypeValid(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case LONG_LONG: 
                case ULONG_LONG: 
                case LONG: 
                case ULONG: 
                case FLOAT: 
                case DOUBLE: 
                case POINTER: 
                case BOOL: 
                case STRING: {
                    return true;
                }
            }
        } else {
            if (type2 instanceof CallbackInfo) {
                return true;
            }
            if (type2 instanceof StructByValue) {
                return true;
            }
        }
        return false;
    }

    static final class CallbackMemoryIO
    extends InvalidMemoryIO
    implements AllocatedDirectMemoryIO {
        private final Closure.Handle handle;
        private final AtomicBoolean released = new AtomicBoolean(false);

        public CallbackMemoryIO(Ruby runtime2, Closure.Handle handle) {
            super(runtime2);
            this.handle = handle;
        }

        public final long getAddress() {
            return this.handle.getAddress();
        }

        public final boolean isNull() {
            return false;
        }

        public final boolean isDirect() {
            return true;
        }

        public void free() {
            if (this.released.getAndSet(true)) {
                throw this.runtime.newRuntimeError("callback already freed");
            }
            this.handle.dispose();
        }

        public void setAutoRelease(boolean autorelease2) {
            this.handle.setAutoRelease(autorelease2);
        }
    }

    private static final class CallbackProxy
    extends AbstractCallbackProxy
    implements Closure {
        private final Object proc;

        CallbackProxy(Ruby runtime2, ClosureInfo closureInfo, Object proc2) {
            super(runtime2, closureInfo);
            this.proc = proc2;
        }

        public void invoke(Closure.Buffer buffer) {
            this.invoke(buffer, this.proc);
        }
    }

    private static final class WeakRefCallbackProxy
    extends AbstractCallbackProxy
    implements Closure {
        private final WeakReference<Object> proc;

        WeakRefCallbackProxy(Ruby runtime2, ClosureInfo closureInfo, Object proc2) {
            super(runtime2, closureInfo);
            this.proc = new WeakReference<Object>(proc2);
        }

        public void invoke(Closure.Buffer buffer) {
            Object recv2 = this.proc.get();
            if (recv2 == null) {
                buffer.setIntReturn(0);
                return;
            }
            this.invoke(buffer, recv2);
        }
    }

    private static abstract class AbstractCallbackProxy
    implements Closure {
        protected final Ruby runtime;
        protected final ClosureInfo closureInfo;

        AbstractCallbackProxy(Ruby runtime2, ClosureInfo closureInfo) {
            this.runtime = runtime2;
            this.closureInfo = closureInfo;
        }

        protected final void invoke(Closure.Buffer buffer, Object recv2) {
            ThreadContext context = this.runtime.getCurrentContext();
            IRubyObject[] params2 = new IRubyObject[this.closureInfo.parameterTypes.length];
            for (int i = 0; i < params2.length; ++i) {
                params2[i] = CallbackManager.fromNative(this.runtime, this.closureInfo.parameterTypes[i], buffer, i);
            }
            IRubyObject retVal = recv2 instanceof RubyProc ? ((RubyProc)recv2).call(context, params2) : (recv2 instanceof Block ? ((Block)recv2).call(context, params2) : ((IRubyObject)recv2).callMethod(context, "call", params2));
            CallbackManager.setReturnValue(this.runtime, this.closureInfo.returnType, buffer, retVal);
        }
    }

    @JRubyClass(name={"FFI::Callback"}, parent="FFI::Pointer")
    static class Callback
    extends Pointer {
        private final CallbackInfo cbInfo;

        Callback(Ruby runtime2, Closure.Handle handle, CallbackInfo cbInfo) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass("Callback"), new CallbackMemoryIO(runtime2, handle), Long.MAX_VALUE);
            this.cbInfo = cbInfo;
        }

        void dispose() {
            MemoryIO mem = this.getMemoryIO();
            if (mem instanceof CallbackMemoryIO) {
                ((CallbackMemoryIO)mem).free();
            }
        }
    }

    private static class ClosureInfo {
        final CallingConvention convention;
        final Type returnType;
        final Type[] parameterTypes;
        final CallContext callContext;

        public ClosureInfo(Ruby runtime2, Type returnType, Type[] paramTypes, CallingConvention convention) {
            this.convention = convention;
            com.kenai.jffi.Type[] ffiParameterTypes = new com.kenai.jffi.Type[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                if (CallbackManager.isParameterTypeValid(paramTypes[i]) && (ffiParameterTypes[i] = FFIUtil.getFFIType(paramTypes[i])) != null) continue;
                throw runtime2.newTypeError("invalid callback parameter type: " + paramTypes[i]);
            }
            com.kenai.jffi.Type ffiReturnType = null;
            if (!CallbackManager.isReturnTypeValid(returnType) || (ffiReturnType = FFIUtil.getFFIType(returnType)) == null) {
                runtime2.newTypeError("invalid callback return type: " + returnType);
            }
            this.callContext = new CallContext(ffiReturnType, ffiParameterTypes, convention);
            this.returnType = returnType;
            this.parameterTypes = (Type[])paramTypes.clone();
        }
    }

    private static final class SingletonHolder {
        static final CallbackManager INSTANCE = new CallbackManager();

        private SingletonHolder() {
        }
    }
}

