/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class ReflectionCallback
implements Callback {
    private Method method;
    private Class type;
    private String methodName;
    private Class[] argumentTypes;
    private boolean isRestArgs;
    private Arity arity;
    private boolean isStaticMethod;
    private boolean fast;

    public ReflectionCallback(Class type2, String methodName, Class[] argumentTypes, boolean isRestArgs, boolean isStaticMethod, Arity arity2, boolean fast) {
        this.type = type2;
        this.methodName = methodName;
        this.argumentTypes = argumentTypes;
        this.isRestArgs = isRestArgs;
        this.isStaticMethod = isStaticMethod;
        this.arity = arity2;
        this.fast = fast;
        assert (type2 != null);
        assert (methodName != null);
        assert (arity2 != null);
        this.loadMethod(fast);
    }

    private void loadMethod(boolean fast) {
        Class[] args2;
        Class[] types;
        if (this.isStaticMethod) {
            types = new Class[this.argumentTypes.length + 1];
            System.arraycopy(this.argumentTypes, 0, types, 1, this.argumentTypes.length);
            types[0] = IRubyObject.class;
            args2 = types;
        } else {
            args2 = this.argumentTypes;
        }
        if (!fast) {
            types = new Class[args2.length + 1];
            System.arraycopy(args2, 0, types, 0, args2.length);
            types[args2.length] = Block.class;
            args2 = types;
        }
        try {
            this.method = this.type.getMethod(this.methodName, args2);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("NoSuchMethodException: Cannot get method \"" + this.methodName + "\" in class \"" + this.type.getName() + "\" by Reflection.");
        }
        catch (SecurityException e) {
            throw new RuntimeException("SecurityException: Cannot get method \"" + this.methodName + "\" in class \"" + this.type.getName() + "\" by Reflection.");
        }
    }

    protected final Object[] packageRestArgumentsForReflection(Object[] originalArgs) {
        IRubyObject[] restArray = new IRubyObject[originalArgs.length - (this.argumentTypes.length - 1)];
        Object[] result = new Object[this.argumentTypes.length];
        try {
            System.arraycopy(originalArgs, this.argumentTypes.length - 1, restArray, 0, originalArgs.length - (this.argumentTypes.length - 1));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            assert (false) : e;
            return null;
        }
        System.arraycopy(originalArgs, 0, result, 0, this.argumentTypes.length - 1);
        result[this.argumentTypes.length - 1] = restArray;
        return result;
    }

    public IRubyObject execute(IRubyObject recv2, IRubyObject[] oargs, Block block) {
        this.arity.checkArity(recv2.getRuntime(), oargs);
        Object[] methodArgs2 = oargs;
        if (this.isRestArgs) {
            methodArgs2 = this.packageRestArgumentsForReflection(methodArgs2);
        }
        try {
            IRubyObject receiver2 = recv2;
            if (this.isStaticMethod) {
                Object[] args2 = new Object[methodArgs2.length + (this.fast ? 1 : 2)];
                System.arraycopy(methodArgs2, 0, args2, 1, methodArgs2.length);
                args2[0] = recv2;
                if (!this.fast) {
                    args2[methodArgs2.length + 1] = block;
                }
                receiver2 = null;
                methodArgs2 = args2;
            } else {
                Object[] args3 = new Object[methodArgs2.length + (this.fast ? 0 : 1)];
                System.arraycopy(methodArgs2, 0, args3, 0, methodArgs2.length);
                if (!this.fast) {
                    args3[methodArgs2.length] = block;
                }
                methodArgs2 = args3;
            }
            return (IRubyObject)this.method.invoke((Object)receiver2, methodArgs2);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RaiseException) {
                throw (RaiseException)e.getTargetException();
            }
            if (e.getTargetException() instanceof JumpException) {
                throw (JumpException)e.getTargetException();
            }
            if (e.getTargetException() instanceof ThreadKill) {
                throw (ThreadKill)e.getTargetException();
            }
            if (e.getTargetException() instanceof Exception) {
                if (e.getTargetException() instanceof MainExitException) {
                    throw (RuntimeException)e.getTargetException();
                }
                recv2.getRuntime().getJavaSupport().handleNativeException(e.getTargetException(), this.method);
                return recv2.getRuntime().getNil();
            }
            throw (Error)e.getTargetException();
        }
        catch (IllegalAccessException e) {
            StringBuilder message2 = new StringBuilder();
            message2.append(e.getMessage());
            message2.append(':');
            message2.append(" methodName=").append(this.methodName);
            message2.append(" recv=").append(recv2.toString());
            message2.append(" type=").append(this.type.getName());
            message2.append(" methodArgs=[");
            for (int i = 0; i < methodArgs2.length; ++i) {
                message2.append(methodArgs2[i]);
                message2.append(' ');
            }
            message2.append(']');
            assert (false) : message2.toString();
            return null;
        }
        catch (IllegalArgumentException e) {
            assert (false) : e;
            return null;
        }
    }

    public Arity getArity() {
        return this.arity;
    }
}

