/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Annotation;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.Notation;
import org.netbeans.modules.xml.schema.model.Redefine;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.DerivationsImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaAttributes;
import org.netbeans.modules.xml.schema.model.impl.SchemaComponentImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaElements;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.w3c.dom.Element;

public class SchemaImpl
extends SchemaComponentImpl
implements Schema {
    public static final String TNS = "tns";
    private Component foreignParent;
    private CachedTargetNamespace mCachedTargetNamespace = new CachedTargetNamespace(this);

    public SchemaImpl(SchemaModelImpl model) {
        this(model, SchemaImpl.createNewComponent(SchemaElements.SCHEMA, model));
    }

    public SchemaImpl(SchemaModelImpl model, Element e) {
        super(model, e);
    }

    @Override
    public Class<? extends SchemaComponent> getComponentType() {
        return Schema.class;
    }

    @Override
    public Collection<SchemaModelReference> getSchemaReferences() {
        return this.getChildren(SchemaModelReference.class);
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Collection<GlobalElement> getElements() {
        return this.getChildren(GlobalElement.class);
    }

    @Override
    public void removeElement(GlobalElement element) {
        this.removeChild("elements", (Component)element);
    }

    @Override
    public void addElement(GlobalElement element) {
        this.appendChild("elements", (Component)element);
    }

    @Override
    public Collection<GlobalAttributeGroup> getAttributeGroups() {
        return this.getChildren(GlobalAttributeGroup.class);
    }

    @Override
    public void removeAttributeGroup(GlobalAttributeGroup group) {
        this.removeChild("attributeGroups", (Component)group);
    }

    @Override
    public void addAttributeGroup(GlobalAttributeGroup group) {
        this.appendChild("attributeGroups", (Component)group);
    }

    @Override
    public void removeExternalReference(SchemaModelReference ref) {
        this.removeChild("schemaReferences", (Component)ref);
    }

    @Override
    public void addExternalReference(SchemaModelReference ref) {
        ArrayList<Class> afterList = new ArrayList<Class>();
        afterList.add(Annotation.class);
        afterList.add(SchemaModelReference.class);
        this.addAfter("schemaReferences", (Component)ref, afterList);
    }

    @Override
    public Collection<GlobalComplexType> getComplexTypes() {
        return this.getChildren(GlobalComplexType.class);
    }

    @Override
    public void removeComplexType(GlobalComplexType type) {
        this.removeChild("complexTypes", (Component)type);
    }

    @Override
    public void addComplexType(GlobalComplexType type) {
        this.appendChild("complexTypes", (Component)type);
    }

    @Override
    public Collection<GlobalAttribute> getAttributes() {
        return this.getChildren(GlobalAttribute.class);
    }

    @Override
    public void addAttribute(GlobalAttribute attr) {
        this.appendChild("attributes", (Component)attr);
    }

    @Override
    public void removeAttribute(GlobalAttribute attr) {
        this.removeChild("attributes", (Component)attr);
    }

    @Override
    public void setVersion(String ver) {
        this.setAttribute("version", SchemaAttributes.VERSION, ver);
    }

    @Override
    public String getVersion() {
        return this.getAttribute(SchemaAttributes.VERSION);
    }

    @Override
    public void setLanguage(String language) {
        this.setAttribute("language", SchemaAttributes.LANGUAGE, language);
    }

    @Override
    public String getLanguage() {
        return this.getAttribute(SchemaAttributes.LANGUAGE);
    }

    @Override
    public void setFinalDefault(Set<Schema.Final> finalDefault) {
        this.setAttribute("finalDefault", SchemaAttributes.FINAL_DEFAULT, finalDefault == null ? null : Util.convertEnumSet(Schema.Final.class, finalDefault));
    }

    @Override
    public Set<Schema.Final> getFinalDefault() {
        String s = this.getAttribute(SchemaAttributes.FINAL_DEFAULT);
        return s == null ? null : Util.valuesOf(Schema.Final.class, s);
    }

    @Override
    public Set<Schema.Final> getFinalDefaultEffective() {
        Set<Schema.Final> v = this.getFinalDefault();
        return v == null ? this.getFinalDefaultDefault() : v;
    }

    @Override
    public Set<Schema.Final> getFinalDefaultDefault() {
        return new DerivationsImpl.DerivationSet<Schema.Final>();
    }

    @Override
    public void setTargetNamespace(String uri) {
        String currentTargetNamespace = this.getTargetNamespace();
        this.setAttribute("targetNamespace", SchemaAttributes.TARGET_NS, uri);
        this.ensureValueNamespaceDeclared(uri, currentTargetNamespace, TNS);
    }

    @Override
    public String getTargetNamespace() {
        return this.mCachedTargetNamespace.getTargetNamespace();
    }

    @Override
    public void setElementFormDefault(Form form) {
        this.setAttribute("elementFormDefault", SchemaAttributes.ELEM_FORM_DEFAULT, (Object)form);
    }

    @Override
    public Form getElementFormDefault() {
        String s = this.getAttribute(SchemaAttributes.ELEM_FORM_DEFAULT);
        return s == null ? null : Util.parse(Form.class, s);
    }

    @Override
    public void setAttributeFormDefault(Form form) {
        this.setAttribute("attributeFormDefault", SchemaAttributes.ATTR_FORM_DEFAULT, (Object)form);
    }

    @Override
    public Form getAttributeFormDefault() {
        String s = this.getAttribute(SchemaAttributes.ATTR_FORM_DEFAULT);
        return s == null ? null : Util.parse(Form.class, s);
    }

    @Override
    public Collection<GlobalSimpleType> getSimpleTypes() {
        return this.getChildren(GlobalSimpleType.class);
    }

    @Override
    public void removeSimpleType(GlobalSimpleType type) {
        this.removeChild("simpleTypes", (Component)type);
    }

    @Override
    public void addSimpleType(GlobalSimpleType type) {
        this.appendChild("simpleTypes", (Component)type);
    }

    @Override
    public Collection<GlobalGroup> getGroups() {
        return this.getChildren(GlobalGroup.class);
    }

    @Override
    public void removeGroup(GlobalGroup group) {
        this.removeChild("groups", (Component)group);
    }

    @Override
    public void addGroup(GlobalGroup group) {
        this.appendChild("groups", (Component)group);
    }

    @Override
    public Collection<Notation> getNotations() {
        return this.getChildren(Notation.class);
    }

    @Override
    public void removeNotation(Notation notation) {
        this.removeChild("notations", (Component)notation);
    }

    @Override
    public void addNotation(Notation notation) {
        this.appendChild("notations", (Component)notation);
    }

    @Override
    public void setBlockDefault(Set<Schema.Block> blockDefault) {
        this.setAttribute("blockDefault", SchemaAttributes.BLOCK_DEFAULT, blockDefault == null ? null : Util.convertEnumSet(Schema.Block.class, blockDefault));
    }

    @Override
    public Set<Schema.Block> getBlockDefault() {
        String s = this.getAttribute(SchemaAttributes.BLOCK_DEFAULT);
        return s == null ? null : Util.valuesOf(Schema.Block.class, s);
    }

    @Override
    public Set<Schema.Block> getBlockDefaultEffective() {
        Set<Schema.Block> v = this.getBlockDefault();
        return v == null ? this.getBlockDefaultDefault() : v;
    }

    @Override
    public Set<Schema.Block> getBlockDefaultDefault() {
        return new DerivationsImpl.DerivationSet<Schema.Block>();
    }

    @Override
    public Form getElementFormDefaultEffective() {
        Form v = this.getElementFormDefault();
        return v == null ? this.getElementFormDefaultDefault() : v;
    }

    @Override
    public Form getElementFormDefaultDefault() {
        return Form.UNQUALIFIED;
    }

    @Override
    public Form getAttributeFormDefaultEffective() {
        Form v = this.getAttributeFormDefault();
        return v == null ? this.getAttributeFormDefaultDefault() : v;
    }

    @Override
    public Form getAttributeFormDefaultDefault() {
        return Form.UNQUALIFIED;
    }

    @Override
    public Collection<Redefine> getRedefines() {
        return this.getChildren(Redefine.class);
    }

    @Override
    public Collection<Include> getIncludes() {
        return this.getChildren(Include.class);
    }

    @Override
    public Collection<Import> getImports() {
        return this.getChildren(Import.class);
    }

    @Override
    public Collection<GlobalElement> findAllGlobalElements() {
        ArrayList<GlobalElement> result = new ArrayList<GlobalElement>();
        Collection<GlobalElement> tempCollection = this.getElements();
        if (tempCollection != null) {
            result.addAll(tempCollection);
        }
        result.addAll(this.getExternalGlobalElements(this.getImports()));
        result.addAll(this.getExternalGlobalElements(this.getIncludes()));
        result.addAll(this.getExternalGlobalElements(this.getRedefines()));
        return result;
    }

    private Collection<GlobalElement> getExternalGlobalElements(Collection<? extends SchemaModelReference> externalRefs) {
        ArrayList<GlobalElement> result = new ArrayList<GlobalElement>();
        for (SchemaModelReference schemaModelReference : externalRefs) {
            try {
                SchemaModel sm = schemaModelReference.resolveReferencedModel();
                if (!sm.getState().equals((Object)Model.State.VALID)) continue;
                result.addAll(sm.getSchema().findAllGlobalElements());
            }
            catch (CatalogModelException ex) {}
        }
        return result;
    }

    @Override
    public Collection<GlobalType> findAllGlobalTypes() {
        ArrayList<GlobalType> result = new ArrayList<GlobalType>();
        Collection<GlobalType> tempCollection = this.getSimpleTypes();
        if (tempCollection != null) {
            result.addAll(tempCollection);
        }
        if ((tempCollection = this.getComplexTypes()) != null) {
            result.addAll(tempCollection);
        }
        result.addAll(this.getExternalGlobalTypes(this.getImports()));
        result.addAll(this.getExternalGlobalTypes(this.getIncludes()));
        result.addAll(this.getExternalGlobalTypes(this.getRedefines()));
        return result;
    }

    private Collection<GlobalType> getExternalGlobalTypes(Collection<? extends SchemaModelReference> externalRefs) {
        ArrayList<GlobalType> result = new ArrayList<GlobalType>();
        for (SchemaModelReference schemaModelReference : externalRefs) {
            try {
                SchemaModel sm = schemaModelReference.resolveReferencedModel();
                if (!sm.getState().equals((Object)Model.State.VALID)) continue;
                result.addAll(sm.getSchema().findAllGlobalTypes());
            }
            catch (CatalogModelException ex) {}
        }
        return result;
    }

    public Component getForeignParent() {
        return this.foreignParent;
    }

    public void setForeignParent(Component component) {
        this.foreignParent = component;
    }

    private static class CachedTargetNamespace {
        private Schema mSchema;
        private boolean mCached = false;
        private String mTargetNamespace;

        public CachedTargetNamespace(Schema schema) {
            this.mSchema = schema;
            SchemaModel sModel = this.mSchema.getModel();
            assert (sModel != null);
            sModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("targetNamespace".equals(propName)) {
                        CachedTargetNamespace.this.discardCache();
                    }
                }
            });
        }

        public synchronized void discardCache() {
            this.mCached = false;
        }

        public synchronized String getTargetNamespace() {
            if (!this.mCached || this.mSchema.getModel().isIntransaction()) {
                this.mTargetNamespace = this.mSchema.getAttribute(SchemaAttributes.TARGET_NS);
                this.mCached = true;
            }
            return this.mTargetNamespace;
        }
    }
}

