/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.util.Collection;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexerImplementation;
import org.openide.util.Lookup;

public final class RepositoryIndexer {
    public static void indexRepo(RepositoryInfo repo) {
        assert (repo != null);
        RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(repo);
        if (impl == null) {
            return;
        }
        impl.indexRepo(repo);
    }

    public static void updateIndexWithArtifacts(RepositoryInfo repo, Collection<Artifact> artifacts) {
        assert (repo != null);
        if (artifacts == null || artifacts.size() == 0) {
            return;
        }
        RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(repo);
        if (impl == null) {
            return;
        }
        impl.updateIndexWithArtifacts(repo, artifacts);
    }

    public static void deleteArtifactFromIndex(RepositoryInfo repo, Artifact artifact) {
        assert (repo != null);
        if (artifact == null) {
            return;
        }
        RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(repo);
        if (impl == null) {
            return;
        }
        impl.deleteArtifactFromIndex(repo, artifact);
    }

    static RepositoryIndexerImplementation findImplementation(RepositoryInfo repo) {
        Collection res = Lookup.getDefault().lookupAll(RepositoryIndexerImplementation.class);
        for (RepositoryIndexerImplementation impl : res) {
            if (!impl.getType().equals(repo.getType())) continue;
            return impl;
        }
        Logger.getLogger(RepositoryIndexer.class.getName()).info("Cannot find repository indexer type:" + repo.getType() + " for repository " + repo.getName());
        return null;
    }

    public static String[] getAvailableTypes() {
        Collection res = Lookup.getDefault().lookupAll(RepositoryIndexerImplementation.class);
        String[] toRet = new String[res.size()];
        int index = 0;
        for (RepositoryIndexerImplementation impl : res) {
            toRet[index] = impl.getType();
            ++index;
        }
        return toRet;
    }
}

