/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.builder;

import com.sun.perseus.builder.Messages;
import com.sun.perseus.builder.SVGTinyModelFactory;
import com.sun.perseus.model.CompositeNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Font;
import com.sun.perseus.model.FontFace;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.UpdateAdapter;
import com.sun.perseus.model.UpdateListener;
import com.sun.perseus.platform.GZIPSupport;
import com.sun.perseus.platform.ThreadSupport;
import com.sun.perseus.util.SimpleTokenizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ModelBuilder
extends DefaultHandler {
    public static final String DTD_SUBSET = "<!ATTLIST svg\n     xmlns CDATA #FIXED \"http://www.w3.org/2000/svg\"\n     xmlns:xlink CDATA #FIXED \"http://www.w3.org/1999/xlink\"\n>";
    public static final String LOAD_INTERRUPTED = "Load Interrupted : ";
    protected static String dtdids = "-//W3C//DTD SVG 1.1 Tiny//EN";
    protected ElementNode currentElement;
    protected DocumentNode modelRoot;
    protected Vector entityStreams = new Vector();
    protected Vector pendingPrefixMapping = null;
    protected Vector pendingPrefixMappingCache = new Vector();

    ModelBuilder(Vector modelFactoryIn, DocumentNode modelRootIn) {
        if (modelFactoryIn == null) {
            modelFactoryIn = SVGTinyModelFactory.getPrototypes(modelRootIn);
        }
        this.modelRoot = modelRootIn;
        int n = modelFactoryIn.size();
        for (int i = 0; i < n; ++i) {
            this.modelRoot.addPrototype((ElementNode)modelFactoryIn.elementAt(i));
        }
    }

    final DocumentNode getModelRoot() {
        return this.modelRoot;
    }

    protected void invokeAndWait(Runnable runnable) throws SAXException {
        try {
            if (ThreadSupport.isInterrupted(Thread.currentThread())) {
                throw new InterruptedException();
            }
            this.modelRoot.invokeAndWait(runnable);
        }
        catch (InterruptedException ie) {
            throw new SAXException(LOAD_INTERRUPTED + Thread.currentThread());
        }
    }

    public final InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (publicId == null || dtdids.indexOf(publicId) != -1) {
            InputSource is = new InputSource();
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(DTD_SUBSET.getBytes()));
            is.setCharacterStream(reader);
            this.entityStreams.addElement(reader);
            return is;
        }
        return null;
    }

    public final void setDocumentLocator(Locator locator) {
    }

    public final void startDocument() {
    }

    public final void endDocument() throws SAXException {
        try {
            this.modelRoot.validate();
        }
        catch (DOMException de) {
            de.printStackTrace();
            throw new SAXException(de.getMessage());
        }
        this.invokeAndWait(new Runnable(){

            public void run() {
                UpdateListener um = ModelBuilder.this.modelRoot.getUpdateListener();
                ModelBuilder.this.modelRoot.setLoaded(true);
                um.loadComplete(ModelBuilder.this.modelRoot);
            }
        });
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.pendingPrefixMappingCache.addElement(new String[]{prefix, uri});
        this.pendingPrefixMapping = this.pendingPrefixMappingCache;
    }

    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ElementNode modelNode = null;
        try {
            String[][] traitAliases;
            String styleAttribute;
            String[][] requiredTraitsNS;
            int i;
            modelNode = (ElementNode)this.modelRoot.createElementNS(uri, localName);
            if (this.pendingPrefixMapping != null) {
                int n = this.pendingPrefixMapping.size();
                for (i = 0; i < n; ++i) {
                    String[] mapping = (String[])this.pendingPrefixMapping.elementAt(i);
                    this.modelRoot.addNamespacePrefix(mapping[0], mapping[1], modelNode);
                }
                this.pendingPrefixMapping.removeAllElements();
                this.pendingPrefixMapping = null;
            }
            modelNode.setLoaded(false);
            String[] requiredTraits = modelNode.getRequiredTraits();
            if (requiredTraits != null) {
                for (i = 0; i < requiredTraits.length; ++i) {
                    if (attributes.getValue(requiredTraits[i]) != null) continue;
                    throw new SAXException(Messages.formatMessage(Messages.ERROR_MISSING_ATTRIBUTE, new Object[]{requiredTraits[i], modelNode.getNamespaceURI(), modelNode.getLocalName()}));
                }
            }
            if ((requiredTraitsNS = modelNode.getRequiredTraitsNS()) != null) {
                for (int i2 = 0; i2 < requiredTraitsNS.length; ++i2) {
                    if (attributes.getValue(requiredTraitsNS[i2][0], requiredTraitsNS[i2][1]) != null) continue;
                    throw new SAXException(Messages.formatMessage(Messages.ERROR_MISSING_ATTRIBUTE_NS, new Object[]{requiredTraitsNS[i2][1], requiredTraitsNS[i2][0], modelNode.getNamespaceURI(), modelNode.getLocalName()}));
                }
            }
            int n = attributes.getLength();
            for (int i3 = 0; i3 < n; ++i3) {
                modelNode.setAttributeNS(attributes.getURI(i3), attributes.getLocalName(i3), attributes.getValue(i3));
            }
            String[][] defaultTraits = modelNode.getDefaultTraits();
            if (defaultTraits != null) {
                for (int i4 = 0; i4 < defaultTraits.length; ++i4) {
                    if (attributes.getValue(defaultTraits[i4][0]) != null) continue;
                    modelNode.setAttribute(defaultTraits[i4][0], defaultTraits[i4][1]);
                }
            }
            if ((styleAttribute = attributes.getValue("style")) != null) {
                this.parseStyleAttribute(styleAttribute, modelNode);
            }
            if ((traitAliases = modelNode.getTraitAliases()) != null) {
                for (int i5 = 0; i5 < traitAliases.length; ++i5) {
                    String v;
                    if (attributes.getValue(traitAliases[i5][0]) != null || (v = attributes.getValue(traitAliases[i5][1])) == null) continue;
                    modelNode.setAttribute(traitAliases[i5][0], v);
                }
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
            throw new SAXException(e.getMessage());
        }
        if (this.currentElement != null) {
            this.addToParent(modelNode, this.currentElement);
        } else {
            this.addToParent(modelNode, this.modelRoot);
        }
        this.currentElement = modelNode;
        final ElementNode startedNode = modelNode;
        final UpdateListener ul = this.modelRoot.getUpdateListener();
        this.invokeAndWait(new Runnable(){

            public void run() {
                ul.loadBegun(startedNode);
            }
        });
        try {
            this.modelRoot.checkDelayedException();
        }
        catch (DOMException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void parseStyleAttribute(String styleValue, ElementNode elt) {
        SimpleTokenizer st = new SimpleTokenizer(styleValue, ",");
        while (st.hasMoreTokens()) {
            String traitSpec = st.nextToken();
            int ci = traitSpec.indexOf(58);
            String traitName = null;
            String traitValue = null;
            if (ci != -1) {
                traitName = traitSpec.substring(0, ci);
                traitValue = traitSpec.substring(ci + 1);
            } else {
                traitName = "";
                traitValue = "";
            }
            elt.setAttribute(traitName, traitValue);
        }
    }

    void addToParent(final ElementNode child, final CompositeNode parent) throws SAXException {
        this.invokeAndWait(new Runnable(){

            public void run() {
                parent.add(child);
            }
        });
        if (ThreadSupport.isInterrupted(Thread.currentThread())) {
            throw new SAXException(LOAD_INTERRUPTED + Thread.currentThread());
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentElement instanceof Font) {
            this.invokeAndWait(new Runnable(){

                public void run() {
                    ModelNode fc = ModelBuilder.this.currentElement.getFirstChildNode();
                    if (fc != null && fc instanceof FontFace) {
                        ModelBuilder.this.modelRoot.addFontFace((FontFace)fc);
                    }
                }
            });
        }
        this.invokeAndWait(new Runnable(){

            public void run() {
                UpdateListener um = ModelBuilder.this.modelRoot.getUpdateListener();
                ModelBuilder.this.currentElement.setLoaded(true);
                um.loadComplete(ModelBuilder.this.currentElement);
            }
        });
        ModelNode parent = this.currentElement.getParent();
        this.currentElement = parent instanceof ElementNode ? (ElementNode)parent : null;
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement != null) {
            final String text = new String(ch, start, length);
            final UpdateListener ul = this.modelRoot.getUpdateListener();
            this.invokeAndWait(new Runnable(){

                public void run() {
                    ModelBuilder.this.currentElement.appendTextChild(text);
                    ul.textInserted(ModelBuilder.this.currentElement);
                }
            });
        } else {
            System.err.println(">>>>>>>>>>>>>> currentElement is null!!!!!!!");
        }
    }

    public final void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    public static DocumentNode loadDocument(String svgURI) throws IOException {
        InputStream is = GZIPSupport.openHandleGZIP(svgURI);
        DocumentNode doc = new DocumentNode();
        doc.setLoaded(false);
        doc.setDocumentURI(svgURI);
        UpdateAdapter updateAdapter = new UpdateAdapter();
        doc.setUpdateListener(updateAdapter);
        ModelBuilder.loadDocument(is, doc);
        if (!updateAdapter.loadSuccess()) {
            Exception cause = updateAdapter.getLoadingFailedException();
            if (cause == null) {
                throw new IOException();
            }
            throw new IOException(cause.getMessage());
        }
        return doc;
    }

    public static void loadDocument(InputStream is, DocumentNode root) {
        ModelBuilder.loadDocument(is, root, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDocument(InputStream is, final DocumentNode root, Vector modelFactory) {
        block47: {
            if (root == null) {
                throw new IllegalArgumentException();
            }
            root.setLoaded(false);
            String svgURI = root.getURIBase();
            if (is == null && svgURI == null) {
                throw new IllegalArgumentException();
            }
            final UpdateListener updateListener = root.getUpdateListener();
            if (updateListener == null) {
                throw new IllegalArgumentException();
            }
            root.addNamespacePrefix("xlink", "http://www.w3.org/1999/xlink", root);
            root.addNamespacePrefix("", "http://www.w3.org/2000/svg", root);
            ModelBuilder modelBuilder = null;
            InputStream gzipIS = null;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                SAXParser parser = null;
                SAXParser saxParser = parser = factory.newSAXParser();
                if (is == null) {
                    is = GZIPSupport.openHandleGZIP(svgURI);
                }
                final InputStream fgzipIS = gzipIS = GZIPSupport.handleGZIP(is);
                root.invokeAndWait(new Runnable(){

                    public void run() {
                        updateListener.loadStarting(root, fgzipIS);
                    }
                });
                modelBuilder = new ModelBuilder(modelFactory, root);
                saxParser.parse(gzipIS, (DefaultHandler)modelBuilder);
            }
            catch (ParserConfigurationException pce) {
                ModelBuilder.loadingFailed(updateListener, root, pce);
            }
            catch (SAXParseException spe) {
                ModelBuilder.loadingFailed(updateListener, root, spe);
            }
            catch (SAXException se) {
                ModelBuilder.loadingFailed(updateListener, root, se);
            }
            catch (IOException ioe) {
                ModelBuilder.loadingFailed(updateListener, root, ioe);
            }
            catch (Exception e) {
                ModelBuilder.loadingFailed(updateListener, root, e);
            }
            finally {
                try {
                    if (gzipIS != null) {
                        gzipIS.close();
                    }
                }
                catch (IOException ioe) {}
                if (modelBuilder == null) break block47;
                int n = modelBuilder.entityStreams.size();
                for (int i = 0; i < n; ++i) {
                    Reader r = (Reader)modelBuilder.entityStreams.elementAt(i);
                    try {
                        r.close();
                        continue;
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    protected static void loadingFailed(final UpdateListener updateListener, final DocumentNode root, final Exception e) {
        System.err.println(">>>>>>>>>>>>>>>>>>> +++++ Loading failed ...");
        e.printStackTrace();
        try {
            root.invokeAndWait(new Runnable(){

                public void run() {
                    updateListener.loadingFailed(root, e);
                }
            });
        }
        catch (InterruptedException ie) {
            return;
        }
    }
}

