/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.List;
import org.netbeans.lib.profiler.heap.ArrayDump;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectArrayLazyList;

class ObjectArrayDump
extends ArrayDump
implements ObjectArrayInstance {
    ObjectArrayDump(ClassDump cls, long offset) {
        super(cls, offset);
    }

    @Override
    public int getSize() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return this.dumpClass.classDumpSegment.getMinimumInstanceSize() + HPROF_ARRAY_OVERHEAD + idSize * this.getLength();
    }

    @Override
    public List getValues() {
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        HprofHeap heap = this.dumpClass.getHprof();
        return new ObjectArrayLazyList(heap, dumpBuffer, this.getLength(), this.getOffset());
    }

    long getOffset() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return this.fileOffset + 1L + (long)idSize + 4L + 4L + (long)idSize;
    }
}

