/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class LivenessMemoryResultsDiff
extends LivenessMemoryResultsSnapshot {
    private float[] avgObjectAge;
    private String[] classNames;
    private int[] maxSurvGen;
    private int[] nTotalAllocObjects;
    private long[] nTrackedAllocObjects;
    private int[] nTrackedLiveObjects;
    private long[] trackedLiveObjectsSize;
    private int nClasses;
    private long maxTrackedLiveObjectsSizeDiff;
    private long minTrackedLiveObjectsSizeDiff;

    public LivenessMemoryResultsDiff(LivenessMemoryResultsSnapshot snapshot1, LivenessMemoryResultsSnapshot snapshot2) {
        this.computeDiff(snapshot1, snapshot2);
    }

    @Override
    public float[] getAvgObjectAge() {
        return this.avgObjectAge;
    }

    @Override
    public long getBeginTime() {
        return -1L;
    }

    @Override
    public String getClassName(int classId) {
        return null;
    }

    @Override
    public String[] getClassNames() {
        return this.classNames;
    }

    @Override
    public JMethodIdTable getJMethodIdTable() {
        return null;
    }

    @Override
    public int[] getMaxSurvGen() {
        return this.maxSurvGen;
    }

    public long getMaxTrackedLiveObjectsSizeDiff() {
        return this.maxTrackedLiveObjectsSizeDiff;
    }

    @Override
    public long getMaxValue() {
        return -1L;
    }

    public long getMinTrackedLiveObjectsSizeDiff() {
        return this.minTrackedLiveObjectsSizeDiff;
    }

    @Override
    public int getNAlloc() {
        return this.getNProfiledClasses();
    }

    @Override
    public int getNInstrClasses() {
        return this.getNProfiledClasses();
    }

    @Override
    public int getNProfiledClasses() {
        return this.nClasses;
    }

    @Override
    public long getNTotalTracked() {
        return -1L;
    }

    @Override
    public long getNTotalTrackedBytes() {
        return -1L;
    }

    @Override
    public long[] getNTrackedAllocObjects() {
        return this.nTrackedAllocObjects;
    }

    @Override
    public int getNTrackedItems() {
        return this.getNProfiledClasses();
    }

    @Override
    public int[] getNTrackedLiveObjects() {
        return this.nTrackedLiveObjects;
    }

    @Override
    public long[] getObjectsSizePerClass() {
        return null;
    }

    @Override
    public long getTimeTaken() {
        return -1L;
    }

    @Override
    public long[] getTrackedLiveObjectsSize() {
        return this.trackedLiveObjectsSize;
    }

    @Override
    public boolean containsStacks() {
        return false;
    }

    @Override
    public PresoObjAllocCCTNode createPresentationCCT(int classId, boolean dontShowZeroLiveObjAllocPaths) {
        return null;
    }

    @Override
    public int[] getnTotalAllocObjects() {
        return this.nTotalAllocObjects;
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        return null;
    }

    private void computeDiff(LivenessMemoryResultsSnapshot snapshot1, LivenessMemoryResultsSnapshot snapshot2) {
        int s1nClasses = snapshot1.getNTrackedItems();
        int s2nClasses = snapshot2.getNTrackedItems();
        HashMap<String, Integer> classNamesIdxMap = new HashMap<String, Integer>(s1nClasses);
        ArrayList<Long> nTrackedAllocObjectsArr = new ArrayList<Long>(s1nClasses);
        ArrayList<Integer> nTrackedLiveObjectsArr = new ArrayList<Integer>(s1nClasses);
        ArrayList<Integer> maxSurvGenArr = new ArrayList<Integer>(s1nClasses);
        ArrayList<Float> avgObjectAgeArr = new ArrayList<Float>(s1nClasses);
        ArrayList<Long> trackedLiveObjectsSizeArr = new ArrayList<Long>(s1nClasses);
        ArrayList<Integer> nTotalAllocObjectsArr = new ArrayList<Integer>(s1nClasses);
        String[] s1ClassNames = snapshot1.getClassNames();
        long[] s1NTrackedAllocObjects = snapshot1.getNTrackedAllocObjects();
        int[] s1NTrackedLiveObjects = snapshot1.getNTrackedLiveObjects();
        int[] s1MaxSurvGen = snapshot1.getMaxSurvGen();
        float[] s1AvgObjectAge = snapshot1.getAvgObjectAge();
        long[] s1TrackedLiveObjectsSize = snapshot1.getTrackedLiveObjectsSize();
        int[] s1NTotalAllocObjects = snapshot1.getnTotalAllocObjects();
        int idx = 0;
        for (int i = 0; i < s1nClasses; ++i) {
            if (s1NTotalAllocObjects[i] <= 0) continue;
            Integer classIdx = (Integer)classNamesIdxMap.get(s1ClassNames[i]);
            if (classIdx != null) {
                int classIndex = classIdx;
                long nTrackedAllocObjects = (Long)nTrackedAllocObjectsArr.get(classIndex);
                int nTrackedLiveObjects = (Integer)nTrackedLiveObjectsArr.get(classIndex);
                int maxSurvGen = (Integer)maxSurvGenArr.get(classIndex);
                float avgObjectAge = ((Float)avgObjectAgeArr.get(classIndex)).floatValue();
                long trackedLiveObjectsSize = (Long)trackedLiveObjectsSizeArr.get(classIndex);
                int nTotalAllocObjects = (Integer)nTotalAllocObjectsArr.get(classIndex);
                nTrackedAllocObjectsArr.set(classIndex, new Long(nTrackedAllocObjects - s1NTrackedAllocObjects[i]));
                nTrackedLiveObjectsArr.set(classIndex, new Integer(nTrackedLiveObjects - s1NTrackedLiveObjects[i]));
                maxSurvGenArr.set(classIndex, new Integer(maxSurvGen - s1MaxSurvGen[i]));
                avgObjectAgeArr.set(classIndex, new Float(avgObjectAge - s1AvgObjectAge[i]));
                trackedLiveObjectsSizeArr.set(classIndex, new Long(trackedLiveObjectsSize - s1TrackedLiveObjectsSize[i]));
                nTotalAllocObjectsArr.set(classIndex, new Integer(nTotalAllocObjects - s1NTotalAllocObjects[i]));
                continue;
            }
            classNamesIdxMap.put(s1ClassNames[i], new Integer(idx));
            nTrackedAllocObjectsArr.add(new Long(0L - s1NTrackedAllocObjects[i]));
            nTrackedLiveObjectsArr.add(new Integer(0 - s1NTrackedLiveObjects[i]));
            maxSurvGenArr.add(new Integer(0 - s1MaxSurvGen[i]));
            avgObjectAgeArr.add(new Float(0.0f - s1AvgObjectAge[i]));
            trackedLiveObjectsSizeArr.add(new Long(0L - s1TrackedLiveObjectsSize[i]));
            nTotalAllocObjectsArr.add(new Integer(0 - s1NTotalAllocObjects[i]));
            ++idx;
        }
        String[] s2ClassNames = snapshot2.getClassNames();
        long[] s2NTrackedAllocObjects = snapshot2.getNTrackedAllocObjects();
        int[] s2NTrackedLiveObjects = snapshot2.getNTrackedLiveObjects();
        int[] s2MaxSurvGen = snapshot2.getMaxSurvGen();
        float[] s2AvgObjectAge = snapshot2.getAvgObjectAge();
        long[] s2TrackedLiveObjectsSize = snapshot2.getTrackedLiveObjectsSize();
        int[] s2NTotalAllocObjects = snapshot2.getnTotalAllocObjects();
        for (int i = 0; i < s2nClasses; ++i) {
            String className = s2ClassNames[i];
            long nTrackedAllocObject = s2NTrackedAllocObjects[i];
            int nTrackedLiveObject = s2NTrackedLiveObjects[i];
            int maxSGen = s2MaxSurvGen[i];
            float avtOAge = s2AvgObjectAge[i];
            long trackedLiveObjectSize = s2TrackedLiveObjectsSize[i];
            int nTotalAllocObject = s2NTotalAllocObjects[i];
            if (s2NTotalAllocObjects[i] <= 0) continue;
            Integer classIdx = (Integer)classNamesIdxMap.get(className);
            if (classIdx != null) {
                int classIndex = classIdx;
                nTrackedAllocObjectsArr.set(classIndex, new Long((Long)nTrackedAllocObjectsArr.get(classIndex) + nTrackedAllocObject));
                nTrackedLiveObjectsArr.set(classIndex, new Integer((Integer)nTrackedLiveObjectsArr.get(classIndex) + nTrackedLiveObject));
                maxSurvGenArr.set(classIndex, new Integer((Integer)maxSurvGenArr.get(classIndex) + maxSGen));
                avgObjectAgeArr.set(classIndex, new Float(((Float)avgObjectAgeArr.get(classIndex)).floatValue() + avtOAge));
                trackedLiveObjectsSizeArr.set(classIndex, new Long((Long)trackedLiveObjectsSizeArr.get(classIndex) + trackedLiveObjectSize));
                nTotalAllocObjectsArr.set(classIndex, new Integer((Integer)nTotalAllocObjectsArr.get(classIndex) + nTotalAllocObject));
                continue;
            }
            classNamesIdxMap.put(className, new Integer(nTrackedAllocObjectsArr.size()));
            nTrackedAllocObjectsArr.add(new Long(nTrackedAllocObject));
            nTrackedLiveObjectsArr.add(new Integer(nTrackedLiveObject));
            maxSurvGenArr.add(new Integer(maxSGen));
            avgObjectAgeArr.add(new Float(avtOAge));
            trackedLiveObjectsSizeArr.add(new Long(trackedLiveObjectSize));
            nTotalAllocObjectsArr.add(new Integer(nTotalAllocObject));
        }
        this.nClasses = classNamesIdxMap.size();
        this.classNames = new String[this.nClasses];
        this.nTrackedAllocObjects = new long[this.nClasses];
        this.nTrackedLiveObjects = new int[this.nClasses];
        this.maxSurvGen = new int[this.nClasses];
        this.avgObjectAge = new float[this.nClasses];
        this.trackedLiveObjectsSize = new long[this.nClasses];
        this.nTotalAllocObjects = new int[this.nClasses];
        this.minTrackedLiveObjectsSizeDiff = Integer.MAX_VALUE;
        this.maxTrackedLiveObjectsSizeDiff = Integer.MIN_VALUE;
        Iterator classNamesIter = classNamesIdxMap.entrySet().iterator();
        int index = 0;
        while (classNamesIter.hasNext()) {
            Map.Entry entry = classNamesIter.next();
            String className = (String)entry.getKey();
            int classIndex = (Integer)entry.getValue();
            this.classNames[index] = className;
            this.nTrackedAllocObjects[index] = (Long)nTrackedAllocObjectsArr.get(classIndex);
            this.nTrackedLiveObjects[index] = (Integer)nTrackedLiveObjectsArr.get(classIndex);
            this.maxSurvGen[index] = (Integer)maxSurvGenArr.get(classIndex);
            this.avgObjectAge[index] = ((Float)avgObjectAgeArr.get(classIndex)).floatValue();
            this.trackedLiveObjectsSize[index] = (Long)trackedLiveObjectsSizeArr.get(classIndex);
            this.nTotalAllocObjects[index] = (Integer)nTotalAllocObjectsArr.get(classIndex);
            this.minTrackedLiveObjectsSizeDiff = Math.min(this.minTrackedLiveObjectsSizeDiff, this.trackedLiveObjectsSize[index]);
            this.maxTrackedLiveObjectsSizeDiff = Math.max(this.maxTrackedLiveObjectsSizeDiff, this.trackedLiveObjectsSize[index]);
            ++index;
        }
        if (this.minTrackedLiveObjectsSizeDiff > 0L && this.maxTrackedLiveObjectsSizeDiff > 0L) {
            this.minTrackedLiveObjectsSizeDiff = 0L;
        } else if (this.minTrackedLiveObjectsSizeDiff < 0L && this.maxTrackedLiveObjectsSizeDiff < 0L) {
            this.maxTrackedLiveObjectsSizeDiff = 0L;
        }
    }
}

