/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.ui.commit.CommitTable;
import org.netbeans.modules.mercurial.ui.diff.MultiDiffPanel;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.versioning.hooks.HgHook;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.VCSHookContext;
import org.netbeans.modules.versioning.util.AutoResizingPanel;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.TemplateSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CommitPanel
extends AutoResizingPanel
implements PreferenceChangeListener,
TableModelListener,
ChangeListener {
    private final AutoResizingPanel basePanel = new AutoResizingPanel();
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    private static final boolean DEFAULT_DISPLAY_FILES = true;
    private static final boolean DEFAULT_DISPLAY_HOOKS = false;
    final JLabel filesLabel = new JLabel();
    final PlaceholderPanel progressPanel = new PlaceholderPanel();
    private final JPanel filesPanel = new JPanel(new GridLayout(1, 1));
    private final JLabel filesSectionButton = new JLabel();
    private final JPanel filesSectionPanel2 = new JPanel();
    private final PlaceholderPanel hookSectionPanel = new PlaceholderPanel();
    private final JLabel hooksSectionButton = new JLabel();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JTextArea messageTextArea = new JTextArea();
    private final JLabel recentLink = new JLabel();
    private final JLabel templateLink = new JLabel();
    private Icon expandedIcon;
    private Icon collapsedIcon;
    private CommitTable commitTable;
    private Collection<HgHook> hooks = Collections.emptyList();
    private HgHookContext hookContext;
    private JTabbedPane tabbedPane;
    private HashMap<File, MultiDiffPanel> displayedDiffs = new HashMap();
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public CommitPanel() {
        this.initComponents();
        this.initInteraction();
    }

    void setCommitTable(CommitTable commitTable) {
        this.commitTable = commitTable;
    }

    void setErrorLabel(String htmlErrorLabel) {
        this.jLabel2.setText(htmlErrorLabel);
    }

    public void addNotify() {
        super.addNotify();
        HgModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        TemplateSelector ts = new TemplateSelector(HgModuleConfig.getDefault().getPreferences());
        if (ts.isAutofill()) {
            this.messageTextArea.setText(ts.getTemplate());
        } else {
            List messages;
            String lastCommitMessage = HgModuleConfig.getDefault().getLastCanceledCommitMessage();
            if (lastCommitMessage.isEmpty() && new StringSelector.RecentMessageSelector(HgModuleConfig.getDefault().getPreferences()).isAutoFill() && (messages = Utils.getStringList((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage")).size() > 0) {
                lastCommitMessage = (String)messages.get(0);
            }
            this.messageTextArea.setText(lastCommitMessage);
        }
        this.messageTextArea.selectAll();
        this.initCollapsibleSections();
    }

    private void initCollapsibleSections() {
        JTree tv = new JTree();
        BasicTreeUI tvui = (BasicTreeUI)tv.getUI();
        this.expandedIcon = tvui.getExpandedIcon();
        this.collapsedIcon = tvui.getCollapsedIcon();
        this.initSectionButton(this.filesSectionButton, this.filesSectionPanel2, "initFilesPanel", true);
        if (!this.hooks.isEmpty()) {
            this.hooksSectionButton.setText(this.hooks.size() == 1 ? this.hooks.iterator().next().getDisplayName() : CommitPanel.getMessage("LBL_Advanced"));
            this.initSectionButton(this.hooksSectionButton, (JPanel)this.hookSectionPanel, "initHooksPanel", false);
        } else {
            this.hooksSectionButton.setVisible(false);
        }
    }

    private void initSectionButton(final JLabel label, final JPanel panel, final String initPanelMethodName, boolean defaultSectionDisplayed) {
        if (defaultSectionDisplayed) {
            this.displaySection(label, panel, initPanelMethodName);
        } else {
            this.hideSection(label, panel);
        }
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (panel.isVisible()) {
                    CommitPanel.this.hideSection(label, panel);
                } else {
                    CommitPanel.this.displaySection(label, panel, initPanelMethodName);
                }
            }
        });
    }

    private void displaySection(JLabel sectionButton, Container sectionPanel, String initPanelMethodName) {
        if (sectionPanel.getComponentCount() == 0) {
            this.invokeInitPanelMethod(initPanelMethodName);
        }
        sectionPanel.setVisible(true);
        sectionButton.setIcon(this.expandedIcon);
        this.enlargeVerticallyAsNecessary();
    }

    private void hideSection(JLabel sectionButton, JPanel sectionPanel) {
        sectionPanel.setVisible(false);
        sectionButton.setIcon(this.collapsedIcon);
    }

    private void invokeInitPanelMethod(String methodName) {
        try {
            this.getClass().getDeclaredMethod(methodName, new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initFilesPanel() {
        this.filesPanel.add(this.commitTable.getComponent());
        this.filesPanel.setPreferredSize(new Dimension(0, 2 * this.messageTextArea.getPreferredSize().height));
        this.filesSectionPanel2.setLayout(new BoxLayout(this.filesSectionPanel2, 1));
        this.filesSectionPanel2.add(this.filesLabel);
        this.filesSectionPanel2.add(this.makeVerticalStrut(this.filesLabel, this.filesPanel, 0));
        this.filesSectionPanel2.add(this.filesPanel);
        this.filesLabel.setAlignmentX(0.0f);
        this.filesPanel.setAlignmentX(0.0f);
    }

    private void initHooksPanel() {
        assert (!this.hooks.isEmpty());
        if (this.hooks.size() == 1) {
            this.hookSectionPanel.add((Component)this.hooks.iterator().next().createComponent((VCSHookContext)this.hookContext));
        } else {
            JTabbedPane hooksTabbedPane = new JTabbedPane();
            for (HgHook hook : this.hooks) {
                hooksTabbedPane.add((Component)hook.createComponent((VCSHookContext)this.hookContext), hook.getDisplayName());
            }
            this.hookSectionPanel.add((Component)hooksTabbedPane);
        }
    }

    String getCommitMessage() {
        return this.messageTextArea.getText();
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        HgModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    void setHooks(Collection<HgHook> hooks, HgHookContext context) {
        if (hooks == null) {
            hooks = Collections.emptyList();
        }
        this.hooks = hooks;
        this.hookContext = context;
    }

    private void onBrowseRecentMessages() {
        StringSelector.RecentMessageSelector selector = new StringSelector.RecentMessageSelector(HgModuleConfig.getDefault().getPreferences());
        String message = selector.getRecentMessage(CommitPanel.getMessage("CTL_CommitForm_RecentTitle"), CommitPanel.getMessage("CTL_CommitForm_RecentPrompt"), Utils.getStringList((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage"));
        if (message != null) {
            this.messageTextArea.replaceSelection(message);
        }
    }

    private void onTemplate() {
        TemplateSelector ts = new TemplateSelector(HgModuleConfig.getDefault().getPreferences());
        if (ts.show()) {
            this.messageTextArea.setText(ts.getTemplate());
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            Runnable inAWT = new Runnable(){

                @Override
                public void run() {
                    CommitPanel.this.commitTable.dataChanged();
                    CommitPanel.this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
                }
            };
            if (EventQueue.isDispatchThread()) {
                inAWT.run();
            } else {
                EventQueue.invokeLater(inAWT);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    private void initComponents() {
        this.jLabel1.setLabelFor(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)CommitPanel.getMessage("CTL_CommitForm_Message"));
        this.recentLink.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/recent_messages.png")));
        this.recentLink.setToolTipText(CommitPanel.getMessage("CTL_CommitForm_RecentMessages"));
        this.templateLink.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/load_template.png")));
        this.templateLink.setToolTipText(CommitPanel.getMessage("CTL_CommitForm_LoadTemplate"));
        this.messageTextArea.setColumns(60);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(4);
        this.messageTextArea.setTabSize(4);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMinimumSize(new Dimension(80, 18));
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.messageTextArea.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitForm_Message"));
        this.messageTextArea.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitForm_Message"));
        Mnemonics.setLocalizedText((JLabel)this.filesSectionButton, (String)CommitPanel.getMessage("LBL_CommitDialog_FilesToCommit"));
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)CommitPanel.getMessage("CTL_CommitForm_FilesToCommit"));
        Mnemonics.setLocalizedText((JLabel)this.hooksSectionButton, (String)CommitPanel.getMessage("LBL_Advanced"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)"jLabel2");
        VerticallyNonResizingPanel topPanel = new VerticallyNonResizingPanel();
        topPanel.setLayout(new BoxLayout((Container)topPanel, 0));
        topPanel.add(this.jLabel1);
        topPanel.add(Box.createHorizontalGlue());
        topPanel.add(this.recentLink);
        topPanel.add(this.makeHorizontalStrut(this.recentLink, this.templateLink, 0));
        topPanel.add(this.templateLink);
        this.jLabel1.setAlignmentY(1.0f);
        this.recentLink.setAlignmentY(1.0f);
        this.templateLink.setAlignmentY(1.0f);
        VerticallyNonResizingPanel bottomPanel = new VerticallyNonResizingPanel();
        bottomPanel.setLayout(new BoxLayout((Container)bottomPanel, 0));
        bottomPanel.add(this.jLabel2);
        bottomPanel.add(this.makeFlexibleHorizontalStrut(15, 90, Short.MAX_VALUE));
        bottomPanel.add((Component)this.progressPanel);
        this.jLabel2.setAlignmentY(0.5f);
        this.progressPanel.setAlignmentY(0.5f);
        this.basePanel.setLayout((LayoutManager)new BoxLayout((Container)this.basePanel, 1));
        this.basePanel.add((Component)topPanel);
        this.basePanel.add(this.makeVerticalStrut(this.jLabel1, this.jScrollPane1, 0));
        this.basePanel.add((Component)this.jScrollPane1);
        this.basePanel.add(this.makeVerticalStrut(this.jScrollPane1, this.filesSectionButton, 0));
        this.basePanel.add((Component)this.filesSectionButton);
        this.basePanel.add(this.makeVerticalStrut(this.filesSectionButton, this.filesSectionPanel2, 0));
        this.basePanel.add((Component)this.filesSectionPanel2);
        this.basePanel.add(this.makeVerticalStrut(this.filesSectionPanel2, this.hooksSectionButton, 0));
        this.basePanel.add((Component)this.hooksSectionButton);
        this.basePanel.add(this.makeVerticalStrut(this.hooksSectionButton, (JComponent)this.hookSectionPanel, 0));
        this.basePanel.add((Component)this.hookSectionPanel);
        this.basePanel.add(this.makeVerticalStrut((JComponent)this.hookSectionPanel, this.jLabel2, 0));
        this.basePanel.add((Component)bottomPanel);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add((Component)this.basePanel);
        topPanel.setAlignmentX(0.0f);
        this.jScrollPane1.setAlignmentX(0.0f);
        this.filesSectionButton.setAlignmentX(0.0f);
        this.filesSectionPanel2.setAlignmentX(0.0f);
        this.hooksSectionButton.setAlignmentX(0.0f);
        this.hookSectionPanel.setAlignmentX(0.0f);
        bottomPanel.setAlignmentX(0.0f);
        this.basePanel.setBorder(BorderFactory.createEmptyBorder(26, this.getContainerGap(7), 0, 15));
        this.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitDialog"));
        this.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitDialog"));
    }

    private void initInteraction() {
        this.recentLink.setCursor(Cursor.getPredefinedCursor(12));
        this.recentLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommitPanel.this.onBrowseRecentMessages();
            }
        });
        this.templateLink.setCursor(Cursor.getPredefinedCursor(12));
        this.templateLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommitPanel.this.onTemplate();
            }
        });
        Spellchecker.register((JTextComponent)this.messageTextArea);
    }

    private Component makeVerticalStrut(JComponent compA, JComponent compB, int relatedUnrelated) {
        int height = LayoutStyle.getSharedInstance().getPreferredGap(compA, compB, relatedUnrelated, 5, (Container)((Object)this));
        return Box.createVerticalStrut(height);
    }

    private Component makeHorizontalStrut(JComponent compA, JComponent compB, int relatedUnrelated) {
        int width = LayoutStyle.getSharedInstance().getPreferredGap(compA, compB, relatedUnrelated, 7, (Container)((Object)this));
        return Box.createHorizontalStrut(width);
    }

    private Component makeFlexibleHorizontalStrut(int minWidth, int prefWidth, int maxWidth) {
        return new Box.Filler(new Dimension(minWidth, 0), new Dimension(prefWidth, 0), new Dimension(maxWidth, 0));
    }

    private int getContainerGap(int direction) {
        return LayoutStyle.getSharedInstance().getContainerGap((JComponent)((Object)this), direction, null);
    }

    private static String getMessage(String msgKey) {
        return NbBundle.getMessage(CommitPanel.class, (String)msgKey);
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabbedPane && this.tabbedPane.getSelectedComponent() == this.basePanel) {
            this.commitTable.setModifiedFiles(new HashSet<File>(this.getModifiedFiles().keySet()));
        }
    }

    void openDiff(HgFileNode[] nodes) {
        for (HgFileNode node : nodes) {
            File file;
            MultiDiffPanel panel;
            if (this.tabbedPane == null) {
                this.initializeTabs();
            }
            if ((panel = this.displayedDiffs.get(file = node.getFile())) == null) {
                panel = new MultiDiffPanel(file, "BASE", "LOCAL", false);
                this.displayedDiffs.put(file, panel);
                this.tabbedPane.addTab(file.getName(), panel);
            }
            this.tabbedPane.setSelectedComponent(panel);
        }
        this.revalidate();
        this.repaint();
    }

    SaveCookie[] getSaveCookies() {
        return this.getModifiedFiles().values().toArray(new SaveCookie[0]);
    }

    EditorCookie[] getEditorCookies() {
        LinkedList<EditorCookie> allCookies = new LinkedList<EditorCookie>();
        for (Map.Entry<File, MultiDiffPanel> e : this.displayedDiffs.entrySet()) {
            EditorCookie[] cookies = e.getValue().getEditorCookies(true);
            if (cookies.length <= 0) continue;
            allCookies.add(cookies[0]);
        }
        return allCookies.toArray(new EditorCookie[allCookies.size()]);
    }

    boolean canCommit() {
        boolean result = true;
        if (this.tabbedPane != null && this.tabbedPane.getSelectedComponent() != this.basePanel) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(CommitPanel.class, (String)"MSG_CommitDialog_CommitFromDiff"), NbBundle.getMessage(CommitPanel.class, (String)"LBL_CommitDialog_CommitFromDiff"), 0, 3, null, NotifyDescriptor.YES_OPTION);
            result = NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify(nd);
        }
        return result;
    }

    private void initializeTabs() {
        this.tabbedPane = new JTabbedPane(1, 1);
        this.tabbedPane.addTab(NbBundle.getMessage(CommitPanel.class, (String)"CTL_CommitDialog_Tab_Commit"), (Component)this.basePanel);
        this.tabbedPane.setPreferredSize(this.basePanel.getPreferredSize());
        this.add(this.tabbedPane);
        this.tabbedPane.addChangeListener(this);
    }

    private HashMap<File, SaveCookie> getModifiedFiles() {
        HashMap<File, SaveCookie> modifiedFiles = new HashMap<File, SaveCookie>();
        for (Map.Entry<File, MultiDiffPanel> e : this.displayedDiffs.entrySet()) {
            SaveCookie[] cookies = e.getValue().getSaveCookies(false);
            if (cookies.length <= 0) continue;
            modifiedFiles.put(e.getKey(), cookies[0]);
        }
        return modifiedFiles;
    }
}

