/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.status.VersioningPanel;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class HgVersioningTopComponent
extends TopComponent {
    private static final long serialVersionUID = 1L;
    private VersioningPanel syncPanel;
    private VCSContext context;
    private String contentTitle;
    private String branchTitle;
    private long lastUpdateTimestamp;
    private static final String PREFERRED_ID = "hgversioning";
    private static HgVersioningTopComponent instance;

    public HgVersioningTopComponent() {
        this.putClientProperty("SlidingName", NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/mercurial/resources/icons/versioning-view.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.syncPanel = new VersioningPanel(this);
        this.add(this.syncPanel);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected void componentActivated() {
        this.updateTitle();
        this.syncPanel.focus();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshContent();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    private void refreshContent() {
        if (this.syncPanel == null) {
            return;
        }
        this.updateTitle();
        this.syncPanel.setContext(this.context);
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
        this.updateTitle();
    }

    void setBranchTitle(String branchTitle) {
        this.branchTitle = branchTitle;
        this.updateTitle();
    }

    public void contentRefreshed() {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        this.updateTitle();
    }

    private void updateTitle() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HgVersioningTopComponent.this.contentTitle == null) {
                    HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
                } else {
                    File baseFile = HgUtils.getRootFile(HgVersioningTopComponent.this.context);
                    String name = "";
                    if (baseFile != null) {
                        name = baseFile.getName();
                    }
                    if (HgVersioningTopComponent.this.branchTitle == null) {
                        HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_MultiTitle", (Object)HgVersioningTopComponent.this.contentTitle, (Object)(name.equals(HgVersioningTopComponent.this.contentTitle) ? "" : "[" + name + "]")));
                    } else {
                        HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title_ContentBranch", (Object)HgVersioningTopComponent.this.contentTitle, (Object)(name.equals(HgVersioningTopComponent.this.contentTitle) ? "" : "[" + name + "] "), (Object)HgVersioningTopComponent.this.branchTitle));
                    }
                }
            }
        });
    }

    String getContentTitle() {
        return this.contentTitle;
    }

    public static synchronized HgVersioningTopComponent getDefault() {
        if (instance == null) {
            instance = new HgVersioningTopComponent();
        }
        return instance;
    }

    public static synchronized HgVersioningTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Mercurial.LOG.log(Level.FINE, "Cannot find hgversioning component. It will not be located properly in the window system.");
            return HgVersioningTopComponent.getDefault();
        }
        if (win instanceof HgVersioningTopComponent) {
            return (HgVersioningTopComponent)win;
        }
        Mercurial.LOG.log(Level.FINE, "There seem to be multiple components with the 'hgversioning' ID. That is a potential source of errors and unexpected behavior.");
        return HgVersioningTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void performRefreshAction() {
        this.syncPanel.performRefreshAction();
    }

    public void setContext(VCSContext ctx) {
        this.syncPanel.cancelRefresh();
        if (ctx == null) {
            this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"MSG_Preparing"));
            this.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
            this.context = ctx;
            this.syncPanel.setContext(ctx);
            this.setBranchTitle(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_VersioningView_UnnamedBranchTitle"));
            this.refreshContent();
        }
        this.setToolTipText(this.getContextFilesList(ctx, NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title")));
    }

    private String getContextFilesList(VCSContext ctx, String def) {
        if (ctx == null || ctx.getRootFiles().size() == 0) {
            return def;
        }
        StringBuffer sb = new StringBuffer(200);
        sb.append("<html>");
        for (File file : ctx.getRootFiles()) {
            sb.append(file.getAbsolutePath());
            sb.append("<br>");
        }
        sb.delete(sb.length() - 4, Integer.MAX_VALUE);
        return sb.toString();
    }

    public boolean hasContext() {
        return this.context != null && this.context.getRootFiles().size() > 0;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return HgVersioningTopComponent.getDefault();
        }
    }
}

