/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.api.VerificationWarningOverrider;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreatePersistenceUnit;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceUnitPresent
extends JPAClassRule {
    public PersistenceUnitPresent() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY));
    }

    @Override
    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        Project project = FileOwnerQuery.getOwner((FileObject)problemContext.getFileObject());
        if (project == null) {
            return null;
        }
        PersistenceScope[] persistenceScopeArray = PersistenceUtils.getPersistenceScopes((Project)project);
        for (PersistenceScope persistenceScope : persistenceScopeArray) {
            if (!persistenceScope.getClassPath().contains(problemContext.getFileObject())) continue;
            try {
                PersistenceUnit[] persistenceUnitArray;
                FileObject fileObject = persistenceScope.getPersistenceXml();
                if (fileObject == null || (persistenceUnitArray = PersistenceMetadata.getDefault().getRoot(fileObject).getPersistenceUnit()) == null || persistenceUnitArray.length <= 0) continue;
                return null;
            }
            catch (IOException iOException) {
                JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
        for (VerificationWarningOverrider verificationWarningOverrider : project.getLookup().lookupAll(VerificationWarningOverrider.class)) {
            if (!verificationWarningOverrider.suppressWarning("no_persitence_unit_warning")) continue;
            return null;
        }
        return new ErrorDescription[]{PersistenceUnitPresent.createProblem((Element)typeElement, problemContext, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_MissingPersistenceUnitHint"), Severity.WARNING, new CreatePersistenceUnit(project))};
    }
}

