/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.completion;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

public class GsfCompletionDoc
implements CompletionDocumentation {
    private String content = null;
    private URL docURL = null;
    private AbstractAction goToSource = null;
    private ElementHandle elementHandle;
    private Language language;
    private CompilationController controller;

    private GsfCompletionDoc(final CompilationController controller, final ElementHandle elementHandle, URL url) {
        Language embeddedLanguage;
        this.controller = controller;
        this.language = controller.getLanguage();
        if (elementHandle != null && elementHandle.getMimeType() != null && (embeddedLanguage = LanguageRegistry.getInstance().getLanguageByMimeType(elementHandle.getMimeType())) != null && embeddedLanguage.getParser() != null) {
            this.language = embeddedLanguage;
        }
        CodeCompletionHandler completer = this.language.getCompletionProvider();
        this.elementHandle = elementHandle;
        if (elementHandle != null) {
            this.goToSource = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Completion.get().hideAll();
                    UiUtils.open(controller.getSource(), elementHandle);
                }
            };
            this.docURL = url != null ? url : null;
        }
        if (completer != null) {
            this.content = completer.document((CompilationInfo)controller, elementHandle);
        }
        if (this.content == null) {
            Completion.get().hideDocumentation();
        }
    }

    public static final GsfCompletionDoc create(CompilationController controller, ElementHandle elementHandle) {
        return new GsfCompletionDoc(controller, elementHandle, null);
    }

    public String getText() {
        return this.content;
    }

    public URL getURL() {
        return this.docURL;
    }

    public CompletionDocumentation resolveLink(String link) {
        ElementHandle handle;
        if (link.startsWith("www.")) {
            link = "http://" + link;
        }
        if (link.matches("[a-z]+://.*")) {
            try {
                URL url = new URL(link);
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                return null;
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
        }
        if ((handle = this.language.getCompletionProvider().resolveLink(link, this.elementHandle)) != null) {
            URL url = null;
            if (handle instanceof ElementHandle.UrlHandle) {
                String url_text = ((ElementHandle.UrlHandle)handle).getUrl();
                try {
                    url = new URL(url_text);
                }
                catch (MalformedURLException mue) {
                    Logger.getLogger("global").log(Level.INFO, null, mue);
                }
            }
            return new GsfCompletionDoc(this.controller, handle, url);
        }
        return null;
    }

    public Action getGotoSourceAction() {
        return this.goToSource;
    }
}

