/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.IndexBatchEntry;
import org.netbeans.modules.gsfret.source.usages.IndexDocumentImpl;
import org.openide.filesystems.FileObject;

public class SourceAnalyser
implements IndexDocumentFactory {
    private final Index index;
    private final Map<String, List<String>> references;

    public SourceAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.references = new HashMap<String, List<String>>();
    }

    public final boolean isUpToDate(String resourceName, long resourceMTime) throws IOException {
        return this.index.isUpToDate(resourceName, resourceMTime);
    }

    public void store() throws IOException {
    }

    public boolean isValid() throws IOException {
        return this.index.isValid(true);
    }

    public void analyse(Language language, Iterable<ParserResult> data) throws IOException {
        Indexer indexer = language.getIndexer();
        if (indexer != null) {
            for (ParserResult result : data) {
                String fileUrl = indexer.getPersistentUrl(result.getFile().getFile());
                List<IndexDocument> documents = indexer.index(result, (IndexDocumentFactory)this);
                if (documents == null) {
                    documents = Collections.emptyList();
                }
                this.index.store(fileUrl, documents);
            }
        }
    }

    void analyseUnitAndStore(Indexer indexer, ParserResult result) throws IOException {
        String fileUrl = indexer.getPersistentUrl(result.getFile().getFile());
        FileObject fo = result.getFile().getFileObject();
        List documents = null;
        if (fo != null && fo.isValid() && (documents = indexer.index(result, (IndexDocumentFactory)this)) == null) {
            documents = Collections.emptyList();
        }
        this.index.store(fileUrl, documents);
    }

    public void delete(ParserFile parserFile, Language language) throws IOException {
        if (!this.index.isValid(false)) {
            return;
        }
        Indexer indexer = language.getIndexer();
        if (indexer != null && indexer.isIndexable(parserFile)) {
            String fileUrl = indexer.getPersistentUrl(parserFile.getFile());
            this.index.store(fileUrl, null);
        }
    }

    Map<String, String> getTimeStamps() throws IOException {
        return this.index.getTimeStamps();
    }

    public IndexDocument createDocument(int initialPairs) {
        return new IndexDocumentImpl(initialPairs);
    }

    public IndexDocument createDocument(int initialPairs, String overrideUrl) {
        return new IndexDocumentImpl(initialPairs, overrideUrl);
    }

    public String toString() {
        return "SourceAnalyzer(" + ((Object)((Object)this.index)).toString().substring(((Object)((Object)this.index)).toString().indexOf("@") + 1) + ")";
    }

    boolean hasData() {
        try {
            return !this.index.isValid(false);
        }
        catch (IOException ioe) {
            return true;
        }
    }

    void batchStore(List<IndexBatchEntry> list, boolean create) throws IOException {
        this.index.batchStore(list, create);
    }
}

