/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.xml;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.asm.model.lang.instruction.Instruction;
import org.netbeans.modules.cnd.asm.model.lang.instruction.InstructionArgs;

public abstract class XMLBaseInstruction
implements Instruction {
    private final String name;
    private final String groupName;
    private final String description;
    private final Collection<InstructionArgs> args;
    private Map<String, String> propMap;

    public XMLBaseInstruction(String name, String groupName, String description, Collection<InstructionArgs> args) {
        this.name = name;
        this.groupName = groupName;
        this.args = args;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<InstructionArgs> getArguments() {
        return this.args;
    }

    @Override
    public String getProperty(String name) {
        if (this.propMap != null) {
            return this.propMap.get(name);
        }
        return null;
    }

    public String toString() {
        return this.name + " " + this.description;
    }

    protected void setProperty(String name, String value) {
        try {
            String t = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Method m = this.getClass().getMethod(t, String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception ex) {
            this.setMap(name, value);
        }
    }

    private void setMap(String name, String value) {
        if (this.propMap == null) {
            this.propMap = new HashMap<String, String>();
        }
        this.propMap.put(name, value);
    }
}

