/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.JavaProjectSettings;
import org.netbeans.modules.java.project.PackageDisplayUtils;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.netbeans.spi.java.project.support.ui.PackageViewChildren;
import org.netbeans.spi.java.project.support.ui.TreeRootNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class PackageView {
    private PackageView() {
    }

    public static Node createPackageView(SourceGroup group) {
        return new RootNode(group);
    }

    public static Node findPath(Node rootNode, Object object) {
        PackageRootNode.PathFinder pf = (PackageRootNode.PathFinder)rootNode.getLookup().lookup(PackageRootNode.PathFinder.class);
        if (pf != null) {
            return pf.findPath(rootNode, object);
        }
        TreeRootNode.PathFinder pf2 = (TreeRootNode.PathFinder)rootNode.getLookup().lookup(TreeRootNode.PathFinder.class);
        if (pf2 != null) {
            return pf2.findPath(rootNode, object);
        }
        return null;
    }

    public static ComboBoxModel createListView(SourceGroup group) {
        Parameters.notNull((CharSequence)"group", (Object)group);
        TreeSet<PackageItem> data = new TreeSet<PackageItem>();
        PackageView.findNonExcludedPackages(null, data, group.getRootFolder(), group, false);
        return new DefaultComboBoxModel<PackageItem>(data.toArray(new PackageItem[data.size()]));
    }

    static void findNonExcludedPackages(PackageViewChildren children, Collection<PackageItem> target, FileObject fo, SourceGroup group, boolean showProgress) {
        if (showProgress) {
            ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(PackageView.class, (String)"PackageView.find_packages_progress", (Object)FileUtil.getFileDisplayName((FileObject)fo)));
            progress.start(1000);
            PackageView.findNonExcludedPackages(children, target, fo, group, progress, 0, 1000);
            progress.finish();
        } else {
            PackageView.findNonExcludedPackages(children, target, fo, group, null, 0, 0);
        }
    }

    private static void findNonExcludedPackages(PackageViewChildren children, Collection<PackageItem> target, FileObject fo, SourceGroup group, ProgressHandle progress, int start, int end) {
        assert (fo.isFolder()) : "Package view only accepts folders";
        if (progress != null) {
            String path = FileUtil.getRelativePath((FileObject)children.getRoot(), (FileObject)fo);
            assert (path != null) : fo + " in " + children.getRoot();
            progress.progress(path.replace('/', '.'), start);
        }
        if (!fo.isValid()) {
            return;
        }
        if (!VisibilityQuery.getDefault().isVisible(fo)) {
            return;
        }
        boolean hasSubfolders = false;
        boolean hasFiles = false;
        ArrayList<FileObject> folders = new ArrayList<FileObject>();
        for (FileObject kid : fo.getChildren()) {
            if (!kid.isValid() || !VisibilityQuery.getDefault().isVisible(kid) || !group.contains(kid)) continue;
            if (kid.isFolder()) {
                folders.add(kid);
                hasSubfolders = true;
                continue;
            }
            hasFiles = true;
        }
        if (hasFiles || !hasSubfolders) {
            if (target != null) {
                target.add(new PackageItem(group, fo, !hasFiles));
            } else if (fo.isValid()) {
                children.add(fo, !hasFiles, false);
            }
        }
        if (!folders.isEmpty()) {
            int diff = (end - start) / folders.size();
            int c = 0;
            for (FileObject kid : folders) {
                PackageView.findNonExcludedPackages(children, target, kid, group, progress, start + c * diff, start + (c + 1) * diff);
                ++c;
            }
        }
    }

    public static ListCellRenderer listRenderer() {
        return new PackageListCellRenderer();
    }

    private static final class PackageListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PackageListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof PackageItem) {
                PackageItem pkgitem = (PackageItem)value;
                this.setText(pkgitem.getLabel());
                this.setIcon(pkgitem.getIcon());
            } else {
                String pkgitem = (String)value;
                this.setText(pkgitem);
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    static final class PackageItem
    implements Comparable<PackageItem> {
        private static Map<Image, Icon> image2icon = new IdentityHashMap<Image, Icon>();
        private final boolean empty;
        private final FileObject pkg;
        private final String pkgname;
        private Icon icon;

        public PackageItem(SourceGroup group, FileObject pkg, boolean empty) {
            this.pkg = pkg;
            this.empty = empty;
            String path = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)pkg);
            assert (path != null) : "No " + pkg + " in " + group;
            this.pkgname = path.replace('/', '.');
        }

        public String toString() {
            return this.pkgname;
        }

        public String getLabel() {
            return PackageDisplayUtils.getDisplayLabel(this.pkgname);
        }

        public Icon getIcon() {
            if (this.icon == null) {
                Image image = PackageDisplayUtils.getIcon(this.pkg, this.pkgname, this.empty);
                this.icon = image2icon.get(image);
                if (this.icon == null) {
                    this.icon = new ImageIcon(image);
                    image2icon.put(image, this.icon);
                }
            }
            return this.icon;
        }

        @Override
        public int compareTo(PackageItem p) {
            return this.pkgname.compareTo(p.pkgname);
        }
    }

    @SuppressWarnings(value={"DE_MIGHT_IGNORE"})
    private static final class RootNode
    extends FilterNode
    implements PropertyChangeListener {
        private SourceGroup sourceGroup;
        private static boolean IN_UNIT_TEST = false;

        private RootNode(SourceGroup group) {
            super(RootNode.getOriginalNode(group));
            this.sourceGroup = group;
            JavaProjectSettings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, JavaProjectSettings.class));
            group.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group));
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String prop = event.getPropertyName();
            if ("packageViewType".equals(prop) || "containership".equals(prop)) {
                if (IN_UNIT_TEST) {
                    this.changeOriginal(RootNode.getOriginalNode(this.sourceGroup), true);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RootNode.this.changeOriginal(RootNode.getOriginalNode(RootNode.this.sourceGroup), true);
                        }
                    });
                }
            }
        }

        private static Node getOriginalNode(SourceGroup group) {
            FileObject root = group.getRootFolder();
            if (root == null || !root.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            switch (JavaProjectSettings.getPackageViewType()) {
                case 0: {
                    return new PackageRootNode(group);
                }
                case 1: {
                    return new TreeRootNode(group);
                }
            }
            assert (false) : "Unknown PackageView Type";
            return new PackageRootNode(group);
        }

        static {
            try {
                Class.forName("junit.framework.TestCase");
                IN_UNIT_TEST = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

