/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.indicator;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.api.impl.IndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;

public abstract class IndicatorConfiguration {
    private final IndicatorMetadata metadata;
    private final int position;
    private final List<VisualizerConfiguration> visualizerConfigurations;
    private String actionDisplayName;
    private String actionTooltip;
    private boolean visible;

    public IndicatorConfiguration(IndicatorMetadata metadata, int position, boolean visible) {
        this.metadata = metadata;
        this.position = position;
        this.visible = visible;
        this.visualizerConfigurations = new ArrayList<VisualizerConfiguration>();
    }

    public IndicatorConfiguration(IndicatorMetadata metadata) {
        this(metadata, 0, true);
    }

    public abstract String getID();

    public final void addVisualizerConfiguration(VisualizerConfiguration configuration) {
        if (configuration != null && !this.visualizerConfigurations.contains(configuration)) {
            this.visualizerConfigurations.add(configuration);
        }
    }

    public final void setActionDisplayName(String actionDisplayName) {
        this.actionDisplayName = actionDisplayName;
    }

    public final void setActionTooltip(String actionTooltip) {
        this.actionTooltip = actionTooltip;
    }

    protected final IndicatorMetadata getIndicatorMetadata() {
        return this.metadata;
    }

    protected final int getIndicatorPosition() {
        return this.position;
    }

    protected final List<VisualizerConfiguration> getVisualizerConfigurations() {
        return this.visualizerConfigurations;
    }

    private final String getActionDisplayName() {
        return this.actionDisplayName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    static {
        IndicatorConfigurationAccessor.setDefault(new IndicatorConfigurationAccessorImpl());
    }

    private static final class IndicatorConfigurationAccessorImpl
    extends IndicatorConfigurationAccessor {
        private IndicatorConfigurationAccessorImpl() {
        }

        @Override
        public IndicatorMetadata getIndicatorMetadata(IndicatorConfiguration configuration) {
            return configuration.getIndicatorMetadata();
        }

        @Override
        public int getIndicatorPosition(IndicatorConfiguration configuration) {
            return configuration.getIndicatorPosition();
        }

        @Override
        public List<VisualizerConfiguration> getVisualizerConfigurations(IndicatorConfiguration configuration) {
            return configuration.getVisualizerConfigurations();
        }

        @Override
        public String getActionDisplayName(IndicatorConfiguration configuration) {
            return configuration.getActionDisplayName();
        }

        @Override
        public String getActionTooltip(IndicatorConfiguration configuration) {
            return configuration.actionTooltip;
        }
    }
}

