/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.JavaSourceTaskFactory;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.java.source.support.LookupBasedJavaSourceTaskFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class TreeNavigatorJavaSourceFactory
extends LookupBasedJavaSourceTaskFactory {
    private CancellableTask<CompilationInfo> task;

    static TreeNavigatorJavaSourceFactory getInstance() {
        for (JavaSourceTaskFactory javaSourceTaskFactory : Lookup.getDefault().lookupAll(JavaSourceTaskFactory.class)) {
            if (!(javaSourceTaskFactory instanceof TreeNavigatorJavaSourceFactory)) continue;
            return (TreeNavigatorJavaSourceFactory)javaSourceTaskFactory;
        }
        return null;
    }

    public TreeNavigatorJavaSourceFactory() {
        super(JavaSource.Phase.UP_TO_DATE, JavaSource.Priority.NORMAL);
    }

    public synchronized CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
        return new WrapperTask(this.task);
    }

    public List<FileObject> getFileObjects() {
        List list = super.getFileObjects();
        if (list.size() == 1) {
            return list;
        }
        return Collections.emptyList();
    }

    public FileObject getFile() {
        List list = super.getFileObjects();
        if (list.size() == 1) {
            return (FileObject)list.get(0);
        }
        return null;
    }

    public synchronized void setLookup(Lookup lookup, CancellableTask<CompilationInfo> cancellableTask) {
        this.task = cancellableTask;
        super.setLookup(lookup);
    }

    static class WrapperTask
    implements CancellableTask<CompilationInfo> {
        private final CancellableTask<CompilationInfo> delegate;

        public WrapperTask(CancellableTask<CompilationInfo> cancellableTask) {
            this.delegate = cancellableTask;
        }

        public void cancel() {
            if (this.delegate != null) {
                this.delegate.cancel();
            }
        }

        public void run(CompilationInfo compilationInfo) throws Exception {
            if (this.delegate != null) {
                this.delegate.run((Object)compilationInfo);
            }
        }
    }

    public static final class CaretAwareFactoryImpl
    extends CaretAwareJavaSourceTaskFactory {
        private CancellableTask<CompilationInfo> task;

        static CaretAwareFactoryImpl getInstance() {
            return (CaretAwareFactoryImpl)((Object)Lookup.getDefault().lookup(CaretAwareFactoryImpl.class));
        }

        public CaretAwareFactoryImpl() {
            super(JavaSource.Phase.UP_TO_DATE, JavaSource.Priority.LOW);
        }

        protected synchronized CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
            return new WrapperTask(this.task);
        }

        public List<FileObject> getFileObjects() {
            List list = super.getFileObjects();
            if (list.size() == 1) {
                return list;
            }
            return Collections.emptyList();
        }

        public FileObject getFile() {
            List list = super.getFileObjects();
            if (list.size() == 1) {
                return (FileObject)list.get(0);
            }
            return null;
        }

        public synchronized void setTask(CancellableTask<CompilationInfo> cancellableTask) {
            this.task = cancellableTask;
            FileObject fileObject = this.getFile();
            if (fileObject != null) {
                this.reschedule(fileObject);
            }
        }
    }
}

