/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.testrunner.RubyOutputLineHandler;
import org.netbeans.modules.ruby.testrunner.ui.TestHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerInputProcessorFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerLineConvertor;
import org.openide.LifecycleManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class TestExecutionManager
implements RerunHandler {
    private static final Logger LOGGER = Logger.getLogger(TestExecutionManager.class.getName());
    private ExecutionService execution;
    private Future<Integer> result;
    private boolean finished;
    private TestRunnerLineConvertor outConvertor;
    private TestRunnerLineConvertor errConvertor;
    private TestRunnerInputProcessorFactory outFactory;
    private TestRunnerInputProcessorFactory errFactory;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final RequestProcessor testExecutionProcessor = new RequestProcessor("Ruby Test Execution Processor");
    private static final TestExecutionManager INSTANCE = new TestExecutionManager();

    private TestExecutionManager() {
    }

    public static TestExecutionManager getInstance() {
        return INSTANCE;
    }

    synchronized void finish() {
        this.setFinished(true);
    }

    synchronized void reset() {
        this.finished = false;
    }

    synchronized void init(RubyExecutionDescriptor rubyDescriptor) {
        RubyProcessCreator rpc = new RubyProcessCreator(rubyDescriptor);
        ExecutionDescriptor descriptor = rubyDescriptor.toExecutionDescriptor();
        this.execution = ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)descriptor, (String)rubyDescriptor.getDisplayName());
    }

    synchronized void start(RubyExecutionDescriptor rubyDescriptor, TestHandlerFactory handlerFactory, TestSession session) {
        this.setFinished(false);
        session.setRerunHandler((RerunHandler)this);
        Manager manager = Manager.getInstance();
        this.outConvertor = new TestRunnerLineConvertor(manager, session, handlerFactory);
        this.errConvertor = new TestRunnerLineConvertor(manager, session, handlerFactory);
        session.setOutputLineHandler((OutputLineHandler)new RubyOutputLineHandler(session.getFileLocator()));
        rubyDescriptor.addOutConvertor((LineConvertor)this.outConvertor);
        rubyDescriptor.addErrConvertor((LineConvertor)this.errConvertor);
        this.outFactory = new TestRunnerInputProcessorFactory(manager, session, handlerFactory.printSummary());
        this.errFactory = new TestRunnerInputProcessorFactory(manager, session, false);
        rubyDescriptor.setOutProcessorFactory((ExecutionDescriptor.InputProcessorFactory)this.outFactory);
        rubyDescriptor.setErrProcessorFactory((ExecutionDescriptor.InputProcessorFactory)this.errFactory);
        rubyDescriptor.lineBased(true);
        RubyProcessCreator rpc = new RubyProcessCreator(rubyDescriptor);
        final Runnable oldPostExecutionHook = rubyDescriptor.getPostBuild();
        ExecutionDescriptor descriptor = rubyDescriptor.toExecutionDescriptor().postExecution(new Runnable(){

            @Override
            public void run() {
                TestExecutionManager.this.refresh();
                if (oldPostExecutionHook != null) {
                    oldPostExecutionHook.run();
                }
            }
        });
        this.execution = ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)descriptor, (String)rubyDescriptor.getDisplayName());
        this.runExecution();
    }

    private void runExecution() {
        this.result = this.execution.run();
        this.testExecutionProcessor.post(new Runnable(){

            @Override
            public void run() {
                try {
                    TestExecutionManager.this.result.get();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
                TestExecutionManager.this.setFinished(TestExecutionManager.this.result.isDone());
            }
        });
    }

    public synchronized boolean enabled() {
        return this.finished || this.result != null && this.result.isDone();
    }

    private void setFinished(boolean finished) {
        this.finished = finished;
        this.changeSupport.fireChange();
    }

    public synchronized void rerun() {
        assert (this.enabled());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Re-running: " + this.execution);
        }
        this.refresh();
        this.setFinished(false);
        LifecycleManager.getDefault().saveAll();
        this.runExecution();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public synchronized void refresh() {
        TestSession newSession = null;
        if (this.outConvertor != null) {
            newSession = this.outConvertor.refreshSession();
        }
        if (this.errConvertor != null) {
            this.errConvertor.refreshSession();
        }
        if (newSession != null && this.outFactory != null) {
            this.outFactory.refreshSession(newSession);
        }
        if (newSession != null && this.errFactory != null) {
            this.errFactory.refreshSession(newSession);
        }
    }
}

