/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ErrorInfoPanel
extends JPanel {
    private static final String EMPTYCARD = "emptyCard";
    private static final String CONTENTCARD = "contentCard";
    private static final String ERRORICON = "org/netbeans/modules/db/resources/errorIcon.png";
    private static final String INFOICON = "org/netbeans/modules/db/resources/infoIcon.png";
    private ImageIcon errorIcon;
    private ImageIcon infoIcon;
    private Color errorColor;
    private Color infoColor;
    private JPanel contentPanel;
    private JPanel emptyPanel;
    private JLabel iconLabel;
    private JLabel msgLabel;

    public ErrorInfoPanel() {
        this.initComponents();
        this.add((Component)this.emptyPanel, EMPTYCARD);
    }

    public void setup() {
        this.errorColor = UIManager.getColor("nb.errorForeground");
        if (this.errorColor == null) {
            this.errorColor = new Color(255, 0, 0);
        }
        this.infoColor = UIManager.getColor("nb.warningForeground");
        if (this.infoColor == null) {
            this.infoColor = UIManager.getColor("Label.foreground");
        }
        this.errorIcon = ImageUtilities.loadImageIcon((String)ERRORICON, (boolean)false);
        this.infoIcon = ImageUtilities.loadImageIcon((String)INFOICON, (boolean)false);
    }

    public void clear() {
        ((CardLayout)this.getLayout()).show(this, EMPTYCARD);
    }

    public void setError(String msg) {
        ((CardLayout)this.getLayout()).show(this, CONTENTCARD);
        this.msgLabel.setText(msg);
        this.msgLabel.setForeground(this.errorColor);
        this.iconLabel.setIcon(this.errorIcon);
    }

    public void setInfo(String msg) {
        ((CardLayout)this.getLayout()).show(this, CONTENTCARD);
        this.msgLabel.setText(msg);
        this.msgLabel.setForeground(this.infoColor);
        this.iconLabel.setIcon(this.infoIcon);
    }

    public void set(String msg, boolean isError) {
        if (isError) {
            this.setError(msg);
        } else {
            this.setInfo(msg);
        }
    }

    private void initComponents() {
        this.emptyPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.msgLabel = new JLabel();
        GroupLayout emptyPanelLayout = new GroupLayout(this.emptyPanel);
        this.emptyPanel.setLayout(emptyPanelLayout);
        emptyPanelLayout.setHorizontalGroup(emptyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 278, Short.MAX_VALUE));
        emptyPanelLayout.setVerticalGroup(emptyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 18, Short.MAX_VALUE));
        this.setLayout(new CardLayout());
        this.iconLabel.setText(NbBundle.getMessage(ErrorInfoPanel.class, (String)"ErrorInfoPanel.iconLabel.text"));
        this.msgLabel.setText(NbBundle.getMessage(ErrorInfoPanel.class, (String)"ErrorInfoPanel.msgLabel.text"));
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.iconLabel, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.msgLabel, -1, 374, Short.MAX_VALUE)));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iconLabel, -2, 16, -2).addComponent(this.msgLabel, -2, 16, -2)));
        this.add((Component)this.contentPanel, CONTENTCARD);
    }
}

